/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.helper;

import com.lothrazar.library.core.BlockPosDim;
import com.lothrazar.library.util.BlockPosUtil;
import com.lothrazar.simpletomb.ConfigTomb;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;

public class WorldHelper {
    public static float getRandom(RandomSource rand, double min, double max) {
        return (float)(rand.m_188500_() * (max - min) + min);
    }

    public static boolean isValidPlacement(Level level, BlockPos myPos) {
        if (level.m_151570_(myPos)) {
            return false;
        }
        BlockState blockState = level.m_8055_(myPos);
        return blockState.m_60795_() || blockState.m_60734_() == Blocks.f_49990_;
    }

    public static BlockPosDim findGraveSpawn(Player player, BlockPos initPos) {
        int xRange = (Integer)ConfigTomb.HSEARCHRANGE.get();
        int yRange = (Integer)ConfigTomb.VSEARCHRANGE.get();
        int zRange = (Integer)ConfigTomb.HSEARCHRANGE.get();
        Level level = player.m_9236_();
        if (WorldHelper.isValidPlacement(level, initPos) && WorldHelper.isValidSolid(level, initPos)) {
            return new BlockPosDim(initPos, level);
        }
        ArrayList<BlockPos> positionsWithSolidBelow = new ArrayList<BlockPos>();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int x = initPos.m_123341_() - xRange; x < initPos.m_123341_() + xRange; ++x) {
            for (int y = initPos.m_123342_() - yRange; y < initPos.m_123342_() + yRange; ++y) {
                for (int z = initPos.m_123343_() - zRange; z < initPos.m_123343_() + zRange; ++z) {
                    BlockPos myPos = new BlockPos(x, y, z);
                    boolean isValid = WorldHelper.isValidPlacement(level, myPos);
                    if (!isValid) continue;
                    if (WorldHelper.isValidSolid(level, myPos)) {
                        positionsWithSolidBelow.add(myPos);
                        continue;
                    }
                    positions.add(myPos);
                }
            }
        }
        BlockPos found = null;
        if (positionsWithSolidBelow.size() > 0) {
            BlockPosUtil.sortByDistance((BlockPos)initPos, positionsWithSolidBelow);
            found = (BlockPos)positionsWithSolidBelow.get(0);
        } else if (positions.size() > 0) {
            BlockPosUtil.sortByDistance((BlockPos)initPos, positions);
            found = (BlockPos)positions.get(0);
        } else {
            return null;
        }
        return new BlockPosDim(found, level);
    }

    private static boolean isValidSolid(Level level, BlockPos myPos) {
        return level.m_8055_(myPos.m_7495_()).m_60815_();
    }

    public static BlockPos getInitialPos(Level level, BlockPos pos) {
        boolean validY;
        WorldBorder border = level.m_6857_();
        boolean validXZ = border.m_61937_(pos);
        boolean bl = validY = !level.m_151570_(pos);
        if (validXZ && validY) {
            return pos;
        }
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (!validXZ) {
            x = Math.min(Math.max(pos.m_123341_(), (int)border.m_61955_()), (int)border.m_61957_());
            z = Math.min(Math.max(pos.m_123343_(), (int)border.m_61956_()), (int)border.m_61958_());
        }
        if (!validY) {
            if (y < 1) {
                y = 1;
            }
            if (y > level.m_151558_()) {
                y = level.m_151558_() - 1;
            }
        }
        return new BlockPos(x, y, z);
    }

    public static boolean isRuleKeepInventory(Player player) {
        return WorldHelper.isRuleKeepInventory(player.m_9236_());
    }

    public static boolean isRuleKeepInventory(Level level) {
        return level.m_46469_().m_46207_(GameRules.f_46133_);
    }

    public static void removeNoEvent(Level level, BlockPos pos) {
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
    }

    public static boolean placeGrave(Level level, BlockPos pos, BlockState state) {
        return level.m_7731_(pos, state, 2);
    }
}

