/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.event;

import com.lothrazar.library.core.BlockPosDim;
import com.lothrazar.library.util.LevelWorldUtil;
import com.lothrazar.library.util.RenderUtil;
import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.item.GraveKeyItem;
import com.lothrazar.simpletomb.particle.ParticleGraveSmoke;
import com.lothrazar.simpletomb.particle.ParticleGraveSoul;
import com.lothrazar.simpletomb.particle.ParticleRotatingSmoke;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="simpletomb", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)TombRegistry.GRAVE_SMOKE.get(), ParticleGraveSmoke.Factory::new);
        event.registerSpriteSet((ParticleType)TombRegistry.ROTATING_SMOKE.get(), ParticleRotatingSmoke.Factory::new);
        event.registerSpriteSet((ParticleType)TombRegistry.SOUL.get(), ParticleGraveSoul.Factory::new);
    }

    @SubscribeEvent
    public void render(RenderLevelStageEvent event) {
        ItemStack stack;
        LocalPlayer player;
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS && (player = Minecraft.m_91087_().f_91074_) != null && player.m_9236_() != null && (stack = player.m_21205_()).m_41720_() == TombRegistry.GRAVE_KEY.get()) {
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            BlockPosDim location = ((GraveKeyItem)((Object)TombRegistry.GRAVE_KEY.get())).getTombPos(stack);
            if (location != null && !location.isOrigin() && location.getDimension().equalsIgnoreCase(LevelWorldUtil.dimensionToString((Level)player.m_9236_())) && player.m_9236_().m_46739_(location.toBlockPos())) {
                PoseStack poseStack = event.getPoseStack();
                poseStack.m_85836_();
                RenderUtil.createBox((MultiBufferSource.BufferSource)bufferSource, (PoseStack)poseStack, (float)location.getX(), (float)location.getY(), (float)location.getZ(), (float)1.0f);
                poseStack.m_85849_();
            }
        }
    }
}

