/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.block;

import com.lothrazar.library.util.TimeUtil;
import com.lothrazar.simpletomb.block.BlockEntityTomb;
import com.lothrazar.simpletomb.block.BlockTomb;
import com.lothrazar.simpletomb.block.ModelTomb;
import com.lothrazar.simpletomb.data.MessageType;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderTomb
implements BlockEntityRenderer<BlockEntityTomb> {
    private static final ResourceLocation SKELETON_HEAD = new ResourceLocation("minecraft", "textures/entity/skeleton/skeleton.png");
    private final Font font;

    public RenderTomb(BlockEntityRendererProvider.Context cx) {
        this.font = cx.m_173586_();
    }

    public void render(BlockEntityTomb te, float partialTicks, PoseStack poseStack, MultiBufferSource iRenderTypeBuffer, int light, int destroyStage) {
        int rotationIndex;
        float value;
        if (te == null) {
            return;
        }
        if (!te.hasOwner()) {
            return;
        }
        BlockState knownState = te.m_58904_().m_8055_(te.m_58899_());
        if (!(knownState.m_60734_() instanceof BlockTomb)) {
            return;
        }
        Direction facing = (Direction)knownState.m_61143_(BlockTomb.FACING);
        BlockTomb grave = (BlockTomb)knownState.m_60734_();
        ModelTomb graveModel = grave.getGraveType();
        this.renderHalloween(poseStack, iRenderTypeBuffer, graveModel, facing, light, TimeUtil.isNight((Level)te.m_58904_()));
        light = 0xF000F0;
        float modX = 0.5f;
        float modZ = 0.5f;
        float modY = switch (graveModel) {
            case ModelTomb.GRAVE_CROSS -> {
                value = 0.25f;
                yield 0.06375f;
            }
            case ModelTomb.GRAVE_NORMAL -> {
                value = 0.12625f;
                yield 0.5f;
            }
            default -> {
                value = 0.18875f;
                yield 0.4f;
            }
        };
        boolean isCross = graveModel == ModelTomb.GRAVE_CROSS;
        switch (facing) {
            case SOUTH: {
                rotationIndex = 0;
                if (isCross) {
                    modZ = 1.0f - value;
                    break;
                }
                modZ = value;
                break;
            }
            case WEST: {
                rotationIndex = -1;
                if (isCross) {
                    modX = value;
                    break;
                }
                modX = 1.0f - value;
                break;
            }
            case EAST: {
                rotationIndex = 1;
                if (isCross) {
                    modX = 1.0f - value;
                    break;
                }
                modX = value;
                break;
            }
            default: {
                rotationIndex = 2;
                modZ = isCross ? value : 1.0f - value;
            }
        }
        poseStack.m_85836_();
        poseStack.m_252880_(modX, modY, modZ);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        if (isCross) {
            switch (facing) {
                case SOUTH: {
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    break;
                }
                case WEST: {
                    poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                    break;
                }
                case EAST: {
                    poseStack.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
                    break;
                }
                default: {
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                }
            }
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f * (float)rotationIndex));
        Font fontRender = this.font;
        int textColor = -1;
        this.showString(ChatFormatting.BOLD + MessageType.MESSAGE_RIP.getTranslation(new Object[0]), poseStack, iRenderTypeBuffer, fontRender, 0, textColor, 0.007f, light);
        this.showString(ChatFormatting.BOLD + te.getOwnerName(), poseStack, iRenderTypeBuffer, fontRender, 11, textColor, 0.005f, light);
        float scaleForDate = 0.004f;
        long days = te.timer / 24000;
        String dateString = MessageType.MESSAGE_DAY.getTranslation(days);
        this.showString(ChatFormatting.BOLD + dateString, poseStack, iRenderTypeBuffer, fontRender, 20, textColor, scaleForDate, light);
        Date date = new Date(te.getOwnerDeathTime());
        String fdateString = new SimpleDateFormat("yyyy/MM/dd").format(date);
        String timeString = new SimpleDateFormat("HH:mm:ss").format(date);
        this.showString(ChatFormatting.BOLD + fdateString, poseStack, iRenderTypeBuffer, fontRender, 36, textColor, scaleForDate, light);
        this.showString(ChatFormatting.BOLD + timeString, poseStack, iRenderTypeBuffer, fontRender, 46, textColor, scaleForDate, light);
        poseStack.m_85849_();
    }

    private void showString(String content, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, Font fontRenderer, int posY, int color, float scale, int light) {
        matrixStack.m_85836_();
        matrixStack.m_85841_(scale, scale, scale);
        fontRenderer.m_271703_(content, (float)(-fontRenderer.m_92895_(content) / 2), (float)(posY - 30), color, false, matrixStack.m_85850_().m_252922_(), iRenderTypeBuffer, Font.DisplayMode.NORMAL, 0, light);
        matrixStack.m_85849_();
    }

    private void renderHalloween(PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, ModelTomb graveModel, Direction facing, int light, boolean isNight) {
        RenderSystem.disableCull();
        float decoX = 0.5f;
        float decoY = 0.07f;
        float decoZ = 0.5f;
        switch (graveModel) {
            case GRAVE_NORMAL: {
                decoY += 0.35f;
                break;
            }
            case GRAVE_CROSS: {
                if (facing == Direction.SOUTH) {
                    decoX -= 0.2f;
                    break;
                }
                if (facing == Direction.WEST) {
                    decoZ -= 0.2f;
                    break;
                }
                if (facing == Direction.EAST) {
                    decoZ += 0.2f;
                    break;
                }
                decoX += 0.2f;
                break;
            }
            default: {
                decoY += 0.1f;
            }
        }
        Minecraft.m_91087_().f_90987_.m_174784_(SKELETON_HEAD);
        matrixStack.m_85836_();
        matrixStack.m_252880_(decoX, decoY, decoZ);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(facing.m_122435_() + (float)(facing == Direction.SOUTH || facing == Direction.NORTH ? 180 : 0)));
        if (graveModel == ModelTomb.GRAVE_NORMAL || graveModel == ModelTomb.GRAVE_SIMPLE) {
            matrixStack.m_85841_(0.2f, 0.2f, 0.2f);
            ItemStack stack = new ItemStack((ItemLike)(isNight ? Blocks.f_50144_ : Blocks.f_50133_));
            Minecraft.m_91087_().m_91291_().m_115143_(stack, ItemDisplayContext.NONE, false, matrixStack, iRenderTypeBuffer, 0xF000F0, OverlayTexture.f_118083_, Minecraft.m_91087_().m_91291_().m_174264_(stack, null, null, 0));
        } else {
            matrixStack.m_85841_(0.3f, 0.3f, 0.3f);
        }
        matrixStack.m_85849_();
    }
}

