/*
 * Decompiled with CFR 0.152.
 */
package com.haoict.tiab.common.entities;

import com.haoict.tiab.common.config.TiabConfig;
import com.haoict.tiab.common.core.EntityTypeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;

public class TimeAcceleratorEntity
extends Entity {
    private static final EntityDataAccessor<Integer> timeRate = SynchedEntityData.m_135353_(TimeAcceleratorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int remainingTime;
    private BlockPos pos;

    public TimeAcceleratorEntity(EntityType entityType, Level worldIn) {
        super(entityType, worldIn);
        this.f_19804_.m_135381_(timeRate, (Object)1);
    }

    public TimeAcceleratorEntity(Level worldIn, BlockPos pos, double posX, double posY, double posZ) {
        this((EntityType)EntityTypeRegistry.timeAcceleratorEntityType.get(), worldIn);
        this.pos = pos;
        this.m_6034_(posX, posY, posZ);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(timeRate, (Object)1);
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (this.pos == null) {
            if (!level.f_46443_) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
            return;
        }
        BlockState blockState = level.m_8055_(this.pos);
        ServerLevel serverWorld = level.m_7654_().m_129880_(level.m_46472_());
        BlockEntity targetTE = level.m_7702_(this.pos);
        for (int i = 0; i < this.getTimeRate(); ++i) {
            if (targetTE != null) {
                BlockEntityTicker ticker = targetTE.m_58900_().m_155944_(level, targetTE.m_58903_());
                if (ticker == null) continue;
                ticker.m_155252_(level, this.pos, targetTE.m_58900_(), targetTE);
                continue;
            }
            if (serverWorld != null && blockState.m_60823_()) {
                if (level.f_46441_.m_188503_(((Integer)TiabConfig.COMMON.averageUpdateRandomTick.get()).intValue()) != 0) continue;
                blockState.m_222972_(serverWorld, this.pos, level.f_46441_);
                continue;
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
            break;
        }
        --this.remainingTime;
        if (this.remainingTime <= 0 && !level.f_46443_) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected void m_7378_(CompoundTag compound) {
        this.f_19804_.m_135381_(timeRate, (Object)compound.m_128451_("timeRate"));
        this.setRemainingTime(compound.m_128451_("remainingTime"));
        this.pos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("position"));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("timeRate", this.getTimeRate());
        compound.m_128405_("remainingTime", this.getRemainingTime());
        compound.m_128365_("position", (Tag)NbtUtils.m_129224_((BlockPos)this.pos));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int getTimeRate() {
        return (Integer)this.f_19804_.m_135370_(timeRate);
    }

    public void setTimeRate(int rate) {
        this.f_19804_.m_135381_(timeRate, (Object)rate);
    }

    public int getRemainingTime() {
        return this.remainingTime;
    }

    public void setRemainingTime(int remainingTime) {
        this.remainingTime = remainingTime;
    }
}

