/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.render;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;

public class ShaderModBridge {
    private static final MethodHandle SHADERS_ENABLED;
    private static final MethodHandle NVIDIUM_ENABLED;

    public static boolean isNvidiumEnabled() {
        if (NVIDIUM_ENABLED != null) {
            try {
                return NVIDIUM_ENABLED.invokeExact();
            }
            catch (Throwable e) {
                return false;
            }
        }
        return false;
    }

    public static boolean areShadersEnabled() {
        if (SHADERS_ENABLED != null) {
            try {
                return SHADERS_ENABLED.invokeExact();
            }
            catch (Throwable e) {
                return false;
            }
        }
        return false;
    }

    static {
        MethodHandle shadersEnabled = null;
        try {
            Class<?> irisApiClass = Class.forName("net.irisshaders.iris.api.v0.IrisApi");
            Method instanceGetter = irisApiClass.getDeclaredMethod("getInstance", new Class[0]);
            Object irisApiInstance = instanceGetter.invoke(null, new Object[0]);
            shadersEnabled = MethodHandles.lookup().unreflect(irisApiClass.getDeclaredMethod("isShaderPackInUse", new Class[0])).bindTo(irisApiInstance);
        }
        catch (Throwable irisApiClass) {
            // empty catch block
        }
        SHADERS_ENABLED = shadersEnabled;
        MethodHandle nvidiumEnabled = null;
        try {
            Class<?> nvidiumClass = Class.forName("me.cortex.nvidium.Nvidium");
            nvidiumEnabled = MethodHandles.lookup().findStaticGetter(nvidiumClass, "IS_ENABLED", Boolean.TYPE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        NVIDIUM_ENABLED = nvidiumEnabled;
    }
}

