/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.quad.blender;

import java.util.Arrays;
import me.jellysquid.mods.sodium.client.model.color.ColorProvider;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.util.ColorMixer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;

public abstract class BlendedColorProvider<T>
implements ColorProvider<T> {
    private static boolean shouldUseVertexBlending;

    public static void checkBlendingEnabled() {
        shouldUseVertexBlending = (Integer)Minecraft.m_91087_().f_91066_.m_232121_().m_231551_() > 0;
    }

    @Override
    public void getColors(WorldSlice view, BlockPos pos, T state, ModelQuadView quad, int[] output) {
        if (shouldUseVertexBlending) {
            for (int vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
                output[vertexIndex] = this.getVertexColor(view, pos, quad, vertexIndex);
            }
        } else {
            Arrays.fill(output, ColorARGB.toABGR(this.getColor(view, pos.m_123341_(), pos.m_123342_(), pos.m_123343_())));
        }
    }

    private int getVertexColor(WorldSlice world, BlockPos blockPos, ModelQuadView quad, int vertexIndex) {
        float posX = quad.getX(vertexIndex) - 0.5f;
        float posY = quad.getY(vertexIndex) - 0.5f;
        float posZ = quad.getZ(vertexIndex) - 0.5f;
        int intX = Mth.m_14143_((float)posX);
        int intY = Mth.m_14143_((float)posY);
        int intZ = Mth.m_14143_((float)posZ);
        int worldIntX = blockPos.m_123341_() + intX;
        int worldIntY = blockPos.m_123342_() + intY;
        int worldIntZ = blockPos.m_123343_() + intZ;
        int c00 = this.getColor(world, worldIntX + 0, worldIntY, worldIntZ + 0);
        int c01 = this.getColor(world, worldIntX + 0, worldIntY, worldIntZ + 1);
        int c10 = this.getColor(world, worldIntX + 1, worldIntY, worldIntZ + 0);
        int c11 = this.getColor(world, worldIntX + 1, worldIntY, worldIntZ + 1);
        int z0 = c00 != c01 ? ColorMixer.mix(c00, c01, posZ - (float)intZ) : c00;
        int z1 = c10 != c11 ? ColorMixer.mix(c10, c11, posZ - (float)intZ) : c10;
        int x0 = z0 != z1 ? ColorMixer.mix(z0, z1, posX - (float)intX) : z0;
        return ColorARGB.toABGR(x0);
    }

    protected abstract int getColor(WorldSlice var1, int var2, int var3, int var4);
}

