/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui;

import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.data.fingerprint.HashedFingerprint;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptionPages;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.gui.console.Console;
import me.jellysquid.mods.sodium.client.gui.console.message.MessageLevel;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import me.jellysquid.mods.sodium.client.gui.prompt.ScreenPrompt;
import me.jellysquid.mods.sodium.client.gui.prompt.ScreenPromptable;
import me.jellysquid.mods.sodium.client.gui.widgets.AbstractWidget;
import me.jellysquid.mods.sodium.client.gui.widgets.FlatButtonWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.VideoSettingsScreen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.embeddedt.embeddium.util.PlatformUtil;
import org.jetbrains.annotations.Nullable;

public class SodiumOptionsGUI
extends Screen
implements ScreenPromptable {
    private static final boolean IS_POPUP_SAFE = !PlatformUtil.modPresent("controllable") && !PlatformUtil.isDevelopmentEnvironment();
    private final List<OptionPage> pages = new ArrayList<OptionPage>();
    private final List<ControlElement<?>> controls = new ArrayList();
    private final Screen prevScreen;
    private OptionPage currentPage;
    private FlatButtonWidget applyButton;
    private FlatButtonWidget closeButton;
    private FlatButtonWidget undoButton;
    private FlatButtonWidget donateButton;
    private FlatButtonWidget hideDonateButton;
    private boolean hasPendingChanges;
    private ControlElement<?> hoveredElement;
    @Nullable
    private ScreenPrompt prompt;
    private static final List<FormattedText> DONATION_PROMPT_MESSAGE = List.of(FormattedText.m_130773_((FormattedText[])new FormattedText[]{Component.m_237113_((String)"Hello!")}), FormattedText.m_130773_((FormattedText[])new FormattedText[]{Component.m_237113_((String)"It seems that you've been enjoying "), Component.m_237113_((String)"Embeddium").m_6270_(Style.f_131099_.m_178520_(2616210)), Component.m_237113_((String)", a fork of Sodium for Minecraft.")}), FormattedText.m_130773_((FormattedText[])new FormattedText[]{Component.m_237113_((String)"Sodium is complex, and requires "), Component.m_237113_((String)"thousands of hours").m_6270_(Style.f_131099_.m_178520_(16739840)), Component.m_237113_((String)" of development, debugging, and tuning to create the experience that players have come to expect.")}), FormattedText.m_130773_((FormattedText[])new FormattedText[]{Component.m_237113_((String)"If you'd like to show a token of appreciation, and support the development of Sodium in the process, then consider "), Component.m_237113_((String)"buying them a coffee").m_6270_(Style.f_131099_.m_178520_(15550926)), Component.m_237113_((String)".")}), FormattedText.m_130773_((FormattedText[])new FormattedText[]{Component.m_237113_((String)"And thanks again for using the mod! We hope it helps you (and your computer.)")}));

    public SodiumOptionsGUI(Screen prevScreen) {
        super((Component)Component.m_237115_((String)"Embeddium Options"));
        this.prevScreen = prevScreen;
        this.pages.add(SodiumGameOptionPages.general());
        this.pages.add(SodiumGameOptionPages.quality());
        this.pages.add(SodiumGameOptionPages.performance());
        this.pages.add(SodiumGameOptionPages.advanced());
        this.checkPromptTimers();
    }

    private void checkPromptTimers() {
        Instant threshold;
        if (!IS_POPUP_SAFE) {
            return;
        }
        SodiumGameOptions options = SodiumClientMod.options();
        if (options.notifications.forceDisableDonationPrompts || options.notifications.hasSeenDonationPrompt) {
            return;
        }
        HashedFingerprint fingerprint = null;
        try {
            fingerprint = HashedFingerprint.loadFromDisk();
        }
        catch (Throwable t) {
            SodiumClientMod.logger().error("Failed to read the fingerprint from disk", t);
        }
        if (fingerprint == null) {
            return;
        }
        Instant now = Instant.now();
        if (now.isAfter(threshold = Instant.ofEpochSecond(fingerprint.timestamp()).plus(3L, ChronoUnit.DAYS))) {
            this.openDonationPrompt(options);
        }
    }

    private void openDonationPrompt(SodiumGameOptions options) {
        ScreenPrompt prompt = new ScreenPrompt(this, DONATION_PROMPT_MESSAGE, 320, 190, new ScreenPrompt.Action((Component)Component.m_237113_((String)"Support Sodium"), this::openDonationPage));
        prompt.m_93692_(true);
        options.notifications.hasSeenDonationPrompt = true;
        try {
            options.writeChanges();
        }
        catch (IOException e) {
            SodiumClientMod.logger().error("Failed to update config file", (Throwable)e);
        }
    }

    public void setPage(OptionPage page) {
        this.currentPage = page;
        this.rebuildGUI();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.rebuildGUI();
        if (this.prompt != null) {
            this.prompt.init();
        }
    }

    private void rebuildGUI() {
        this.controls.clear();
        this.m_169413_();
        if (this.currentPage == null) {
            if (this.pages.isEmpty()) {
                throw new IllegalStateException("No pages are available?!");
            }
            this.currentPage = this.pages.get(0);
        }
        this.rebuildGUIPages();
        this.rebuildGUIOptions();
        this.undoButton = new FlatButtonWidget(new Dim2i(this.f_96543_ - 211, this.f_96544_ - 30, 65, 20), (Component)Component.m_237115_((String)"sodium.options.buttons.undo"), this::undoChanges);
        this.applyButton = new FlatButtonWidget(new Dim2i(this.f_96543_ - 142, this.f_96544_ - 30, 65, 20), (Component)Component.m_237115_((String)"sodium.options.buttons.apply"), this::applyChanges);
        this.closeButton = new FlatButtonWidget(new Dim2i(this.f_96543_ - 73, this.f_96544_ - 30, 65, 20), (Component)Component.m_237115_((String)"gui.done"), this::m_7379_);
        this.donateButton = new FlatButtonWidget(new Dim2i(this.f_96543_ - 128, 6, 100, 20), (Component)Component.m_237115_((String)"sodium.options.buttons.donate"), this::openDonationPage);
        this.hideDonateButton = new FlatButtonWidget(new Dim2i(this.f_96543_ - 26, 6, 20, 20), (Component)Component.m_237113_((String)"x"), this::hideDonationButton);
        if (SodiumClientMod.options().notifications.hasClearedDonationButton || SodiumClientMod.options().notifications.forceDisableDonationPrompts) {
            this.setDonationButtonVisibility(false);
        }
        this.m_142416_(this.undoButton);
        this.m_142416_(this.applyButton);
        this.m_142416_(this.closeButton);
        this.m_142416_(this.donateButton);
        this.m_142416_(this.hideDonateButton);
    }

    private void setDonationButtonVisibility(boolean value) {
        this.donateButton.setVisible(value);
        this.hideDonateButton.setVisible(value);
    }

    private void hideDonationButton() {
        SodiumGameOptions options = SodiumClientMod.options();
        options.notifications.hasClearedDonationButton = true;
        try {
            options.writeChanges();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save configuration", e);
        }
        this.setDonationButtonVisibility(false);
    }

    private void rebuildGUIPages() {
        int x = 6;
        int y = 6;
        for (OptionPage page : this.pages) {
            int width = 12 + this.f_96547_.m_92852_((FormattedText)page.getName());
            FlatButtonWidget button = new FlatButtonWidget(new Dim2i(x, y, width, 18), page.getName(), () -> this.setPage(page));
            button.setSelected(this.currentPage == page);
            x += width + 6;
            this.m_142416_(button);
        }
    }

    private void rebuildGUIOptions() {
        int x = 6;
        int y = 28;
        for (OptionGroup group : this.currentPage.getGroups()) {
            for (Option option : group.getOptions()) {
                Control control = option.getControl();
                ControlElement element = control.createElement(new Dim2i(x, y, 200, 18));
                this.m_142416_(element);
                this.controls.add(element);
                y += 18;
            }
            y += 4;
        }
    }

    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        super.m_280273_(drawContext);
        this.updateControls();
        super.m_88315_(drawContext, this.prompt != null ? -1 : mouseX, this.prompt != null ? -1 : mouseY, delta);
        if (this.hoveredElement != null) {
            this.renderOptionTooltip(drawContext, this.hoveredElement);
        }
        if (this.prompt != null) {
            this.prompt.m_88315_(drawContext, mouseX, mouseY, delta);
        }
    }

    private void updateControls() {
        ControlElement hovered = this.getActiveControls().filter(AbstractWidget::isHovered).findFirst().orElse(this.getActiveControls().filter(AbstractWidget::m_93696_).findFirst().orElse(null));
        boolean hasChanges = this.getAllOptions().anyMatch(Option::hasChanged);
        for (OptionPage page : this.pages) {
            for (Option option : page.getOptions()) {
                if (!option.hasChanged()) continue;
                hasChanges = true;
            }
        }
        this.applyButton.setEnabled(hasChanges);
        this.undoButton.setVisible(hasChanges);
        this.closeButton.setEnabled(!hasChanges);
        this.hasPendingChanges = hasChanges;
        this.hoveredElement = hovered;
    }

    private Stream<Option<?>> getAllOptions() {
        return this.pages.stream().flatMap(s -> s.getOptions().stream());
    }

    private Stream<ControlElement<?>> getActiveControls() {
        return this.controls.stream();
    }

    private void renderOptionTooltip(GuiGraphics drawContext, ControlElement<?> element) {
        int boxYCutoff;
        int boxHeight;
        int boxYLimit;
        Dim2i dim = element.getDimensions();
        int textPadding = 3;
        int boxPadding = 3;
        int boxWidth = 200;
        int boxY = dim.y();
        int boxX = dim.getLimitX() + boxPadding;
        Option<?> option = element.getOption();
        ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>(this.f_96547_.m_92923_((FormattedText)option.getTooltip(), boxWidth - textPadding * 2));
        OptionImpact impact = option.getImpact();
        if (impact != null) {
            tooltip.add(Language.m_128107_().m_5536_((FormattedText)Component.m_237110_((String)"sodium.options.performance_impact_string", (Object[])new Object[]{impact.getLocalizedName()}).m_130940_(ChatFormatting.GRAY)));
        }
        if ((boxYLimit = boxY + (boxHeight = tooltip.size() * 12 + boxPadding)) > (boxYCutoff = this.f_96544_ - 40)) {
            boxY -= boxYLimit - boxYCutoff;
        }
        drawContext.m_280024_(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -536870912, -536870912);
        for (int i = 0; i < tooltip.size(); ++i) {
            drawContext.m_280648_(this.f_96547_, (FormattedCharSequence)tooltip.get(i), boxX + textPadding, boxY + textPadding + i * 12, -1);
        }
    }

    private void applyChanges() {
        HashSet dirtyStorages = new HashSet();
        EnumSet<OptionFlag> flags = EnumSet.noneOf(OptionFlag.class);
        this.getAllOptions().forEach(option -> {
            if (!option.hasChanged()) {
                return;
            }
            option.applyChanges();
            flags.addAll(option.getFlags());
            dirtyStorages.add(option.getStorage());
        });
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91073_ != null) {
            if (flags.contains((Object)OptionFlag.REQUIRES_RENDERER_RELOAD)) {
                client.f_91060_.m_109818_();
            } else if (flags.contains((Object)OptionFlag.REQUIRES_RENDERER_UPDATE)) {
                client.f_91060_.m_109826_();
            }
        }
        if (flags.contains((Object)OptionFlag.REQUIRES_ASSET_RELOAD)) {
            client.m_91312_(((Integer)client.f_91066_.m_232119_().m_231551_()).intValue());
            client.m_91088_();
        }
        if (flags.contains((Object)OptionFlag.REQUIRES_GAME_RESTART)) {
            Console.instance().logMessage(MessageLevel.WARN, (Component)Component.m_237115_((String)"sodium.console.game_restart"), 10.0);
        }
        for (OptionStorage storage : dirtyStorages) {
            storage.save();
        }
    }

    private void undoChanges() {
        this.getAllOptions().forEach(Option::reset);
    }

    private void openDonationPage() {
        Util.m_137581_().m_137646_("https://caffeinemc.net/donate");
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.prompt != null && this.prompt.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.prompt == null && keyCode == 80 && (modifiers & 1) != 0) {
            Minecraft.m_91087_().m_91152_((Screen)new VideoSettingsScreen(this.prevScreen, Minecraft.m_91087_().f_91066_));
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.prompt != null) {
            return this.prompt.m_6375_(mouseX, mouseY, button);
        }
        boolean clicked = super.m_6375_(mouseX, mouseY, button);
        if (!clicked) {
            this.m_7522_(null);
            return true;
        }
        return clicked;
    }

    public boolean m_6913_() {
        return !this.hasPendingChanges;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.prevScreen);
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.prompt == null ? super.m_6702_() : this.prompt.getWidgets();
    }

    @Override
    public void setPrompt(@Nullable ScreenPrompt prompt) {
        this.prompt = prompt;
    }

    @Override
    @Nullable
    public ScreenPrompt getPrompt() {
        return this.prompt;
    }

    @Override
    public Dim2i getDimensions() {
        return new Dim2i(0, 0, this.f_96543_, this.f_96544_);
    }
}

