/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sawmill;

import com.google.common.collect.ImmutableSet;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.sawmill.CarpenterTrades;
import net.mehvahdjukaar.sawmill.CommonConfigs;
import net.mehvahdjukaar.sawmill.NetworkStuff;
import net.mehvahdjukaar.sawmill.SawmillBlock;
import net.mehvahdjukaar.sawmill.SawmillClient;
import net.mehvahdjukaar.sawmill.SawmillMenu;
import net.mehvahdjukaar.sawmill.SawmillRecipeGenerator;
import net.mehvahdjukaar.sawmill.WoodcuttingRecipe;
import net.mehvahdjukaar.sawmill.forge.SawmillModImpl;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SawmillMod {
    public static final String MOD_ID = "sawmill";
    public static final Logger LOGGER = LogManager.getLogger((String)"Sawmill");
    public static final boolean KUBEJS = PlatHelper.isModLoaded((String)"kubejs");
    public static final Supplier<Block> SAWMILL_BLOCK = RegHelper.registerBlockWithItem((ResourceLocation)SawmillMod.res("sawmill"), SawmillBlock::new);
    public static final Supplier<MenuType<SawmillMenu>> SAWMILL_MENU = RegHelper.registerMenuType((ResourceLocation)SawmillMod.res("sawmill"), SawmillMenu::new);
    public static final Supplier<SoundEvent> SAWMILL_TAKE = RegHelper.registerSound((ResourceLocation)SawmillMod.res("ui.sawmill.take_result"));
    public static final Supplier<SoundEvent> SAWMILL_SELECT = RegHelper.registerSound((ResourceLocation)SawmillMod.res("ui.sawmill.select_recipe"));
    public static final Supplier<SoundEvent> CARPENTER_WORK = RegHelper.registerSound((ResourceLocation)SawmillMod.res("entity.villager.work_carpenter"));
    public static final Supplier<RecipeSerializer<WoodcuttingRecipe>> WOODCUTTING_RECIPE_SERIALIZER = RegHelper.registerRecipeSerializer((ResourceLocation)SawmillMod.res("woodcutting"), WoodcuttingRecipe.Serializer::new);
    public static final Supplier<RecipeType<WoodcuttingRecipe>> WOODCUTTING_RECIPE = RegHelper.registerRecipeType((ResourceLocation)SawmillMod.res("woodcutting"));
    public static final ResourceKey<PoiType> CARPENTER_POI_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256805_, (ResourceLocation)SawmillMod.res("carpenter"));
    public static final Supplier<PoiType> CARPENTER_POI = RegHelper.registerPOI((ResourceLocation)SawmillMod.res("carpenter"), () -> new PoiType(new HashSet(SAWMILL_BLOCK.get().m_49965_().m_61056_()), 1, 1));
    public static final Supplier<VillagerProfession> CARPENTER = SawmillMod.registerVillager("carpenter", CARPENTER_POI_KEY, CARPENTER_WORK);
    public static final TagKey<Item> BLACKLIST = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)SawmillMod.res("blacklist"));
    private static final Object lock = new Object();
    private static boolean receivedTags = false;
    private static final Map<ResourceLocation, Collection<Holder>> tags = new HashMap<ResourceLocation, Collection<Holder>>();
    private static final Map<TagKey<Item>, List<ItemStack>> cachedTags = new HashMap<TagKey<Item>, List<ItemStack>>();
    private static final Map<RecipeType<?>, Boolean> cachedWhitelist = new HashMap();
    private static final List<Holder<RecipeType<?>>> whitelist = new ArrayList();

    private static Supplier<VillagerProfession> registerVillager(String name, ResourceKey<PoiType> jobSite, Supplier<SoundEvent> workSound) {
        return RegHelper.register((ResourceLocation)SawmillMod.res(name), () -> new VillagerProfession(name, holder -> holder.m_203565_(jobSite), holder -> holder.m_203565_(jobSite), ImmutableSet.of(), ImmutableSet.of(), (SoundEvent)workSound.get()), (ResourceKey)Registries.f_256749_);
    }

    public static void init() {
        if (PlatHelper.getPhysicalSide().isClient()) {
            SawmillClient.init();
        }
        NetworkStuff.init();
        CarpenterTrades.init();
        CommonConfigs.init();
        RegHelper.addItemsToTabsRegistration(event -> event.addAfter(CreativeModeTabs.f_256791_, stack -> stack.m_150930_(Items.f_42776_), new ItemLike[]{SAWMILL_BLOCK.get().m_5456_()}));
        PlatHelper.addServerReloadListener((PreparableReloadListener)SawmillRecipeGenerator.INSTANCE, (ResourceLocation)SawmillMod.res("recipe_generator"));
    }

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static Collection<ItemStack> getTagElements(TagKey<Item> tag) {
        return cachedTags.computeIfAbsent(tag, t -> {
            Collection<Holder> tagList = tags.get(t.f_203868_());
            if (tagList == null) {
                return List.of();
            }
            return tagList.stream().map(h -> ((Item)h.m_203334_()).m_7968_()).toList();
        });
    }

    public static void clearTagHacks() {
        whitelist.clear();
        cachedTags.clear();
        cachedWhitelist.clear();
        receivedTags = false;
    }

    public static boolean isWhitelisted(Recipe<?> recipe) {
        boolean ret = cachedWhitelist.computeIfAbsent(recipe.m_6671_(), recipeType -> whitelist.stream().anyMatch(h -> h.m_203334_() == recipeType));
        if (ret && CommonConfigs.MOD_BLACKLIST.get().contains(recipe.m_6423_().m_135827_())) {
            return false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTagManagerResults(List<TagManager.LoadResult<?>> results) {
        if (!CommonConfigs.SAVE_RECIPES.get().booleanValue() && !CommonConfigs.DYNAMIC_RECIPES.get().booleanValue()) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            tags.clear();
            for (TagManager.LoadResult<?> r : results) {
                if (r.f_203928_() != Registries.f_256913_) continue;
                for (Map.Entry e : r.f_203929_().entrySet()) {
                    tags.computeIfAbsent((ResourceLocation)e.getKey(), y -> new ArrayList()).addAll((Collection)e.getValue());
                }
            }
            for (TagManager.LoadResult<?> r : results) {
                if (r.f_203928_() != Registries.f_256954_) continue;
                whitelist.addAll(((Collection)r.f_203929_().get(SawmillMod.res("whitelist"))).stream().map(holder -> holder).toList());
                break;
            }
            receivedTags = true;
            lock.notifyAll();
        }
        LOGGER.info("Intercepted tag results");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForTags() {
        Object object = lock;
        synchronized (object) {
            if (!receivedTags) {
                try {
                    LOGGER.info("Waiting for tags");
                    lock.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Sawmill error:", e);
                }
            }
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isVanillaIngredient(Ingredient ing) {
        return SawmillModImpl.isVanillaIngredient(ing);
    }
}

