/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sawmill;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.sawmill.CommonConfigs;
import net.mehvahdjukaar.sawmill.NetworkStuff;
import net.mehvahdjukaar.sawmill.WoodcuttingRecipe;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RecipeSorter {
    private static final List<Item> ITEM_ORDER = new ArrayList<Item>();
    private static final List<Item> UNSORTED = new ArrayList<Item>();

    public static void accept(List<WoodcuttingRecipe> sawmillRecipes) {
        UNSORTED.clear();
        sawmillRecipes.forEach(r -> UNSORTED.add(r.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41720_()));
    }

    public static void acceptOrder(IntList list) {
        UNSORTED.clear();
        ITEM_ORDER.clear();
        list.forEach(i -> ITEM_ORDER.add((Item)BuiltInRegistries.f_257033_.m_7942_(i)));
    }

    public static void refreshIfNeeded(RegistryAccess reg) {
        if (UNSORTED.isEmpty()) {
            return;
        }
        ITEM_ORDER.clear();
        if (!CreativeModeTabs.m_257543_().m_257905_()) {
            CreativeModeTabs.m_269226_((FeatureFlagSet)FeatureFlags.f_244377_, (boolean)false, (HolderLookup.Provider)reg);
        }
        HashMap<CreativeModeTab, List> tabContent = new HashMap<CreativeModeTab, List>();
        for (CreativeModeTab t : CreativeModeTabs.m_257388_()) {
            ArrayList<Pair> weights = new ArrayList<Pair>();
            List list = tabContent.computeIfAbsent(t, creativeModeTabs -> t.m_260957_().stream().map(ItemStack::m_41720_).toList());
            Iterator<Item> iterator = UNSORTED.iterator();
            while (iterator.hasNext()) {
                Item i = iterator.next();
                int index = list.indexOf(i);
                if (index == -1) continue;
                weights.add(Pair.of((Object)i, (Object)index));
                iterator.remove();
            }
            weights.sort(Comparator.comparingInt(Pair::getSecond));
            ITEM_ORDER.addAll(weights.stream().map(Pair::getFirst).toList());
        }
        UNSORTED.clear();
    }

    public static void sort(List<WoodcuttingRecipe> recipes, Level level) {
        if (CommonConfigs.SORT_RECIPES.get().booleanValue()) {
            RecipeSorter.refreshIfNeeded(level.m_9598_());
            recipes.sort(Comparator.comparingInt(value -> ITEM_ORDER.indexOf(value.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41720_())));
        }
    }

    public static void sendOrderToClient(@Nullable ServerPlayer player) {
        RecipeSorter.refreshIfNeeded(Utils.hackyGetRegistryAccess());
        IntArrayList list = new IntArrayList();
        ITEM_ORDER.forEach(arg_0 -> RecipeSorter.lambda$sendOrderToClient$4((IntList)list, arg_0));
        NetworkStuff.SyncRecipeOrder message = new NetworkStuff.SyncRecipeOrder((IntList)list);
        if (player != null) {
            NetworkStuff.CHANNEL.sendToClientPlayer(player, (Message)message);
        } else {
            NetworkStuff.CHANNEL.sendToAllClientPlayers((Message)message);
        }
    }

    private static /* synthetic */ void lambda$sendOrderToClient$4(IntList list, Item i) {
        list.add(BuiltInRegistries.f_257033_.m_7447_((Object)i));
    }
}

