/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sawmill;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.misc.StrOpt;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.trades.ItemListingRegistry;
import net.mehvahdjukaar.moonlight.api.trades.ModItemListing;
import net.mehvahdjukaar.sawmill.SawmillMod;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public final class CarpenterTrades {
    private static final Supplier<Map<VillagerType, List<WoodType>>> TYPE_MAP = Suppliers.memoize(() -> {
        HashMap<VillagerType, List<WoodType>> map = new HashMap<VillagerType, List<WoodType>>();
        map.put(VillagerType.f_35821_, List.of(CarpenterTrades.wood("birch"), CarpenterTrades.wood("oak")));
        map.put(VillagerType.f_35820_, List.of(CarpenterTrades.wood("jungle"), CarpenterTrades.wood("bamboo")));
        map.put(VillagerType.f_35823_, List.of(CarpenterTrades.wood("spruce")));
        map.put(VillagerType.f_35825_, List.of(CarpenterTrades.wood("spruce")));
        map.put(VillagerType.f_35822_, List.of(CarpenterTrades.wood("acacia")));
        ArrayList<WoodType> desertList = new ArrayList<WoodType>();
        CarpenterTrades.maybeAddWood(desertList, "cactus");
        if (desertList.isEmpty()) {
            desertList.add(CarpenterTrades.wood("jungle"));
        }
        map.put(VillagerType.f_35819_, desertList);
        ArrayList<WoodType> swampList = new ArrayList<WoodType>();
        CarpenterTrades.maybeAddWood(swampList, "swamp", "cypress");
        if (swampList.isEmpty()) {
            swampList.add(CarpenterTrades.wood("dark_oak"));
        }
        map.put(VillagerType.f_35824_, swampList);
        return map;
    });

    public static void init() {
        ItemListingRegistry.registerSerializer((ResourceLocation)SawmillMod.res("wood_item_to_emerald"), WoodToItemListing.CODEC);
        ItemListingRegistry.registerSerializer((ResourceLocation)SawmillMod.res("log_stripping"), LogStrippingListing.CODEC);
    }

    private static WoodType wood(String name) {
        return WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation(name));
    }

    private static void maybeAddWood(List<WoodType> list, String ... names) {
        for (WoodType t : WoodTypeRegistry.getTypes()) {
            for (String name : names) {
                if (!t.id.m_135815_().contains(name)) continue;
                list.add(t);
            }
        }
    }

    @Nullable
    private static WoodType getTypeSpecificWoodType(Entity trader, RandomSource random) {
        if (trader instanceof VillagerDataHolder) {
            VillagerDataHolder d = (VillagerDataHolder)trader;
            List<WoodType> list = TYPE_MAP.get().getOrDefault(d.m_7141_().m_35560_(), List.of(WoodTypeRegistry.OAK_TYPE));
            return list.get(random.m_188503_(list.size()));
        }
        return null;
    }

    public record WoodToItemListing(boolean buys, String childKey, int woodPrice, ItemStack emeralds, int maxTrades, int xp, float priceMult, int level, boolean typeDependant) implements ModItemListing
    {
        public static final Codec<WoodToItemListing> CODEC = RecordCodecBuilder.create(i -> i.group((App)StrOpt.of((Codec)Codec.BOOL, (String)"buys", (Object)true).forGetter(WoodToItemListing::buys), (App)Codec.STRING.fieldOf("wood_block").forGetter(WoodToItemListing::childKey), (App)ExtraCodecs.f_144629_.fieldOf("wood_block_amount").forGetter(WoodToItemListing::woodPrice), (App)ItemStack.f_41582_.fieldOf("emeralds").forGetter(WoodToItemListing::emeralds), (App)StrOpt.of((Codec)ExtraCodecs.f_144629_, (String)"max_trades", (Object)16).forGetter(WoodToItemListing::maxTrades), (App)StrOpt.of((Codec)ExtraCodecs.f_144629_, (String)"xp").forGetter(w -> Optional.of(w.xp)), (App)StrOpt.of((Codec)ExtraCodecs.f_184349_, (String)"price_multiplier", (Object)Float.valueOf(0.05f)).forGetter(WoodToItemListing::priceMult), (App)StrOpt.of((Codec)Codec.intRange((int)1, (int)5), (String)"level", (Object)1).forGetter(WoodToItemListing::level), (App)StrOpt.of((Codec)Codec.BOOL, (String)"type_dependant", (Object)false).forGetter(WoodToItemListing::typeDependant)).apply((Applicative)i, WoodToItemListing::createDefault));

        private static WoodToItemListing createDefault(boolean buys, String wood, int woodAmount, ItemStack emeralds, int maxTrades, Optional<Integer> xp, float priceMult, int level, boolean typeDependant) {
            return new WoodToItemListing(buys, wood, woodAmount, emeralds, maxTrades, xp.orElse(ModItemListing.defaultXp((boolean)buys, (int)level)), priceMult, level, typeDependant);
        }

        public boolean isValid() {
            return WoodTypeRegistry.OAK_TYPE.getItemOfThis(this.childKey) != null;
        }

        public Codec<? extends ModItemListing> getCodec() {
            return CODEC;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity trader, RandomSource random) {
            WoodType type = null;
            if (this.typeDependant && (type = CarpenterTrades.getTypeSpecificWoodType(trader, random)) == null) {
                return null;
            }
            ArrayList types = new ArrayList(WoodTypeRegistry.getTypes());
            int tries = 0;
            while (tries < 50 && !types.isEmpty()) {
                ++tries;
                if (type == null) {
                    type = (WoodType)types.get(random.m_188503_(types.size()));
                }
                types.remove(type);
                Item w = type.getItemOfThis(this.childKey);
                if (w == null) continue;
                ItemStack wood = new ItemStack((ItemLike)w, this.woodPrice);
                ItemStack emerald = this.emeralds;
                if (wood.m_41619_()) {
                    throw new AssertionError((Object)("Wood item is empty. How? Key:" + this.childKey + ", Wood Type:" + type + ", ItemStack: " + wood + ", Item: " + w + ", Block: " + type.getBlockOfThis(this.childKey)));
                }
                if (this.buys) {
                    return new MerchantOffer(wood, ItemStack.f_41583_, emerald, this.maxTrades, this.xp, this.priceMult);
                }
                return new MerchantOffer(emerald, ItemStack.f_41583_, wood, this.maxTrades, this.xp, this.priceMult);
            }
            return null;
        }

        public int getLevel() {
            return this.level;
        }
    }

    public record LogStrippingListing(ItemStack price, int amount, int maxTrades, int xp, float priceMult, int level) implements ModItemListing
    {
        public static final Codec<LogStrippingListing> CODEC = RecordCodecBuilder.create(i -> i.group((App)ItemStack.f_41582_.fieldOf("price").forGetter(LogStrippingListing::price), (App)Codec.INT.fieldOf("amount").forGetter(LogStrippingListing::amount), (App)StrOpt.of((Codec)ExtraCodecs.f_144629_, (String)"max_trades", (Object)16).forGetter(LogStrippingListing::maxTrades), (App)StrOpt.of((Codec)ExtraCodecs.f_144629_, (String)"xp").forGetter(w -> Optional.of(w.xp)), (App)StrOpt.of((Codec)ExtraCodecs.f_184349_, (String)"price_multiplier", (Object)Float.valueOf(0.05f)).forGetter(LogStrippingListing::priceMult), (App)StrOpt.of((Codec)Codec.intRange((int)1, (int)5), (String)"level", (Object)1).forGetter(LogStrippingListing::level)).apply((Applicative)i, LogStrippingListing::createDefault));

        private static LogStrippingListing createDefault(ItemStack price, int amount, int maxTrades, Optional<Integer> xp, float priceMult, int level) {
            return new LogStrippingListing(price, amount, maxTrades, xp.orElse(ModItemListing.defaultXp((boolean)false, (int)level)), priceMult, level);
        }

        public Codec<? extends ModItemListing> getCodec() {
            return CODEC;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity trader, RandomSource random) {
            WoodType type = CarpenterTrades.getTypeSpecificWoodType(trader, random);
            if (type == null) {
                return null;
            }
            Item log = type.log.m_5456_();
            Item stripped = type.getItemOfThis("stripped_log");
            if (stripped != null) {
                return new MerchantOffer(new ItemStack((ItemLike)log, this.amount), this.price, new ItemStack((ItemLike)stripped, this.amount), this.maxTrades, this.xp, this.priceMult);
            }
            return null;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

