/*
 * Decompiled with CFR 0.152.
 */
package cech12.bucketlib.item;

import cech12.bucketlib.api.item.UniversalBucketItem;
import cech12.bucketlib.util.BucketLibUtil;
import cech12.bucketlib.util.RegistryUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.DispenseFluidContainer;

public class UniversalBucketDispenseBehaviour
extends DefaultDispenseItemBehavior {
    private static final UniversalBucketDispenseBehaviour INSTANCE = new UniversalBucketDispenseBehaviour();
    private final DefaultDispenseItemBehavior dispenseBehavior = new DefaultDispenseItemBehavior();
    private final DispenseFluidContainer dispenseFluidBehavior = DispenseFluidContainer.getInstance();

    public static UniversalBucketDispenseBehaviour getInstance() {
        return INSTANCE;
    }

    private UniversalBucketDispenseBehaviour() {
    }

    @Nonnull
    public ItemStack m_7498_(@Nonnull BlockSource source, @Nonnull ItemStack stack) {
        if (stack.m_41720_() instanceof UniversalBucketItem) {
            if (BucketLibUtil.isEmpty(stack)) {
                return this.fillBucket(source, stack);
            }
            return this.emptyBucket(source, stack);
        }
        return this.dispenseFluidBehavior.m_7498_(source, stack);
    }

    private ItemStack fillBucket(@Nonnull BlockSource source, @Nonnull ItemStack stack) {
        BucketPickup bucketPickup;
        ItemStack vanillaStack;
        UniversalBucketItem universalBucketItem;
        Item item;
        BlockPos pickupPosition;
        ServerLevel level = source.m_7727_();
        BlockState blockState = level.m_8055_(pickupPosition = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)));
        RegistryUtil.BucketBlock bucketBlock = RegistryUtil.getBucketBlock(blockState.m_60734_());
        if (bucketBlock != null && (item = stack.m_41720_()) instanceof UniversalBucketItem && (universalBucketItem = (UniversalBucketItem)item).canHoldBlock(bucketBlock.block()) && (item = bucketBlock.block()) instanceof BucketPickup && !(vanillaStack = (bucketPickup = (BucketPickup)item).m_142598_((LevelAccessor)level, pickupPosition, blockState)).m_41619_()) {
            if (stack.m_41613_() == 1) {
                return BucketLibUtil.addBlock(stack, bucketBlock.block());
            }
            ItemStack usedStack = stack.m_41777_();
            usedStack.m_41764_(1);
            ItemStack resultStack = BucketLibUtil.addBlock(usedStack, bucketBlock.block());
            if (stack.m_41613_() == 1) {
                return resultStack;
            }
            if (((DispenserBlockEntity)source.m_8118_()).m_59237_(resultStack) < 0) {
                this.dispenseBehavior.m_6115_(source, resultStack);
            }
            ItemStack stackCopy = stack.m_41777_();
            stackCopy.m_41774_(1);
            return stackCopy;
        }
        return this.dispenseFluidBehavior.m_7498_(source, stack);
    }

    private ItemStack emptyBucket(@Nonnull BlockSource source, @Nonnull ItemStack stack) {
        ServerLevel level = source.m_7727_();
        BlockPos placePosition = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
        if (BucketLibUtil.containsBlock(stack)) {
            DispensibleContainerItem dispensibleContainerItem;
            Item item;
            Block placeBlock = BucketLibUtil.getBlock(stack);
            if (placeBlock != null && (item = placeBlock.m_5456_()) instanceof DispensibleContainerItem && (dispensibleContainerItem = (DispensibleContainerItem)item).m_142073_(null, (Level)level, placePosition, null)) {
                return BucketLibUtil.removeBlock(stack, true);
            }
        } else if (BucketLibUtil.containsEntityType(stack)) {
            Item item;
            ItemStack resultStack = stack;
            boolean fluidPlaced = false;
            if (BucketLibUtil.containsFluid(resultStack)) {
                resultStack = this.dispenseFluidBehavior.m_7498_(source, stack);
                fluidPlaced = true;
            }
            if (!BucketLibUtil.containsFluid(resultStack) && (item = stack.m_41720_()) instanceof UniversalBucketItem) {
                UniversalBucketItem bucketItem = (UniversalBucketItem)item;
                return bucketItem.spawnEntityFromBucket(null, (Level)source.m_7727_(), resultStack, placePosition, !fluidPlaced);
            }
            return resultStack;
        }
        return this.dispenseFluidBehavior.m_7498_(source, stack);
    }
}

