/*
 * Decompiled with CFR 0.152.
 */
package cech12.bucketlib.api.item;

import cech12.bucketlib.api.BucketLibTags;
import cech12.bucketlib.config.ServerConfig;
import cech12.bucketlib.item.UniversalBucketFluidHandler;
import cech12.bucketlib.util.BucketLibUtil;
import cech12.bucketlib.util.ColorUtil;
import cech12.bucketlib.util.RegistryUtil;
import cech12.bucketlib.util.WorldInteractionUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.axolotl.AxolotlAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class UniversalBucketItem
extends Item {
    private final Properties properties;

    public UniversalBucketItem(Properties properties) {
        super(new Item.Properties());
        this.properties = properties;
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        Component argument;
        Object descriptionId = this.m_5671_(stack);
        if (BucketLibUtil.containsEntityType(stack)) {
            descriptionId = (String)descriptionId + ".entity";
            EntityType<?> entityType = BucketLibUtil.getEntityType(stack);
            argument = entityType != null ? entityType.m_20676_() : Component.m_237113_((String)"?");
        } else if (BucketLibUtil.containsFluid(stack)) {
            descriptionId = (String)descriptionId + ".filled";
            Fluid fluid = BucketLibUtil.getFluid(stack);
            argument = fluid.getFluidType().getDescription();
        } else if (BucketLibUtil.containsBlock(stack)) {
            descriptionId = (String)descriptionId + ".filled";
            Block block = BucketLibUtil.getBlock(stack);
            argument = block != null ? block.m_49954_() : Component.m_237113_((String)"?");
        } else if (BucketLibUtil.containsMilk(stack)) {
            descriptionId = (String)descriptionId + ".filled";
            argument = Component.m_237115_((String)"fluid_type.minecraft.milk");
        } else {
            return Component.m_237115_((String)descriptionId);
        }
        return Component.m_237110_((String)descriptionId, (Object[])new Object[]{argument});
    }

    public boolean isCracked(ItemStack stack) {
        Fluid fluid = BucketLibUtil.getFluid(stack);
        if (fluid != Fluids.f_76191_) {
            int fluidTemperature = fluid.getFluidType().getTemperature();
            Integer upperCrackingTemperature = this.getUpperBreakTemperature();
            Integer lowerCrackingTemperature = this.getLowerBreakTemperature();
            return this.isCrackingFluid(fluid) || upperCrackingTemperature != null && fluidTemperature >= upperCrackingTemperature || lowerCrackingTemperature != null && fluidTemperature <= lowerCrackingTemperature && !BucketLibUtil.isAffectedByInfinityEnchantment(stack);
        }
        return false;
    }

    public boolean canHoldFluid(Fluid fluid) {
        if (fluid == Fluids.f_76191_) {
            return true;
        }
        Item bucket = fluid.m_6859_();
        if (bucket instanceof MilkBucketItem && fluid != ForgeMod.MILK.get()) {
            return false;
        }
        if (!(bucket instanceof MilkBucketItem || bucket instanceof BucketItem && ((BucketItem)bucket).getFluid() == fluid)) {
            return false;
        }
        if (this.properties.allowedFluidsTag != null || this.properties.allowedFluids != null) {
            return this.isAllowedFluid(fluid);
        }
        if (this.properties.deniedFluidsTag != null || this.properties.deniedFluids != null) {
            return !this.isDeniedFluid(fluid);
        }
        int fluidTemperature = fluid.getFluidType().getTemperature();
        Integer maxTemperature = this.getMaxTemperature();
        Integer minTemperature = this.getMinTemperature();
        return !(maxTemperature != null && fluidTemperature > maxTemperature || minTemperature != null && fluidTemperature < minTemperature);
    }

    public boolean canHoldEntity(EntityType<?> entityType) {
        if (this.canObtainEntities()) {
            if (this.properties.allowedEntitiesTag != null || this.properties.allowedEntities != null) {
                return this.isAllowedEntity(entityType);
            }
            if (this.properties.deniedEntitiesTag != null || this.properties.deniedEntities != null) {
                return !this.isDeniedEntity(entityType);
            }
            return true;
        }
        return false;
    }

    public boolean canHoldBlock(Block block) {
        if (this.canObtainBlocks()) {
            if (this.properties.allowedBlocksTag != null || this.properties.allowedBlocks != null) {
                return this.isAllowedBlock(block);
            }
            if (this.properties.deniedBlocksTag != null || this.properties.deniedBlocks != null) {
                return !this.isDeniedBlock(block);
            }
            return true;
        }
        return false;
    }

    public int getMaxStackSize(ItemStack stack) {
        return BucketLibUtil.isEmpty(stack) ? this.properties.maxStackSize : 1;
    }

    public boolean isDamageable(ItemStack stack) {
        return this.getDurability() > 0;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getDurability();
    }

    public void m_6883_(@Nonnull ItemStack itemStack, @Nonnull Level level, @Nonnull Entity entity, int position, boolean selected) {
        if (!level.f_46443_) {
            if (!entity.m_5825_() && this.hasBurningContent(itemStack)) {
                entity.m_146917_(0);
                entity.m_20254_(5);
                if (BucketLibUtil.notCreative(entity) && entity.f_19797_ % 20 == 0) {
                    BucketLibUtil.damageByOne(itemStack);
                }
            } else if (!entity.m_6060_() && entity.m_142079_() && this.hasFreezingContent(itemStack)) {
                int ticks = entity.m_146888_() + (entity.f_146808_ ? 1 : 3);
                entity.m_146917_(Math.min(entity.m_146891_(), ticks));
                if (BucketLibUtil.notCreative(entity) && entity.f_19797_ % 40 == 0 && entity.m_146890_()) {
                    entity.m_6469_(level.m_269111_().m_269109_(), entity.m_6095_().m_204039_(EntityTypeTags.f_144295_) ? 5.0f : 1.0f);
                    BucketLibUtil.damageByOne(itemStack);
                }
            }
        }
    }

    private boolean hasBurningContent(@Nonnull ItemStack itemStack) {
        Integer burningTemperature = this.getBurningTemperature();
        Fluid fluid = BucketLibUtil.getFluid(itemStack);
        return fluid != Fluids.f_76191_ && (burningTemperature != null && fluid.getFluidType().getTemperature() >= burningTemperature || this.isBurningFluid(fluid)) || this.isBurningBlock(BucketLibUtil.getBlock(itemStack));
    }

    private boolean hasFreezingContent(@Nonnull ItemStack itemStack) {
        Integer freezingTemperature = this.getFreezingTemperature();
        Fluid fluid = BucketLibUtil.getFluid(itemStack);
        return fluid != Fluids.f_76191_ && (freezingTemperature != null && fluid.getFluidType().getTemperature() <= freezingTemperature || this.isFreezingFluid(fluid)) || this.isFreezingBlock(BucketLibUtil.getBlock(itemStack));
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand interactionHand) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        boolean isEmpty = BucketLibUtil.isEmpty(itemstack);
        BlockHitResult blockHitResult = UniversalBucketItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)(isEmpty ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (blockHitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos hitBlockPos = blockHitResult.m_82425_();
            BlockState hitBlockState = level.m_8055_(hitBlockPos);
            Direction hitDirection = blockHitResult.m_82434_();
            BlockPos relativeBlockPos = hitBlockPos.m_121945_(hitDirection);
            if (isEmpty) {
                InteractionResultHolder<ItemStack> caldronInteractionResult = WorldInteractionUtil.tryPickupFromCauldron(level, player, interactionHand, blockHitResult);
                if (caldronInteractionResult.m_19089_().m_19077_()) {
                    return caldronInteractionResult;
                }
                FluidActionResult fluidActionResult = FluidUtil.tryPickUpFluid((ItemStack)itemstack, (Player)player, (Level)level, (BlockPos)hitBlockPos, (Direction)hitDirection);
                if (fluidActionResult.isSuccess()) {
                    return InteractionResultHolder.m_19092_((Object)ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)fluidActionResult.getResult()), (boolean)level.m_5776_());
                }
                RegistryUtil.BucketBlock bucketBlock = RegistryUtil.getBucketBlock(hitBlockState.m_60734_());
                if (bucketBlock != null && this.canHoldBlock(bucketBlock.block())) {
                    ItemStack fakeStack = new ItemStack((ItemLike)Items.f_42446_);
                    player.m_21008_(interactionHand, fakeStack);
                    InteractionResultHolder interactionResult = fakeStack.m_41682_(level, player, interactionHand);
                    player.m_21008_(interactionHand, itemstack);
                    if (interactionResult.m_19089_().m_19077_()) {
                        return new InteractionResultHolder(interactionResult.m_19089_(), (Object)ItemUtils.m_41813_((ItemStack)itemstack.m_41777_(), (Player)player, (ItemStack)BucketLibUtil.addBlock(ItemHandlerHelper.copyStackWithSize((ItemStack)itemstack, (int)1), bucketBlock.block())));
                    }
                }
            } else {
                InteractionResultHolder<ItemStack> caldronInteractionResult = WorldInteractionUtil.tryPlaceIntoCauldron(level, player, interactionHand, blockHitResult);
                if (caldronInteractionResult.m_19089_().m_19077_()) {
                    return caldronInteractionResult;
                }
                if (BucketLibUtil.containsFluid(itemstack)) {
                    FluidStack fluidStack = FluidUtil.getFluidHandler((ItemStack)itemstack).map(fluidHandler -> fluidHandler.getFluidInTank(0)).orElse(FluidStack.EMPTY);
                    for (BlockPos pos : Arrays.asList(hitBlockPos, relativeBlockPos)) {
                        FluidActionResult fluidActionResult = FluidUtil.tryPlaceFluid((Player)player, (Level)level, (InteractionHand)interactionHand, (BlockPos)pos, (ItemStack)BucketLibUtil.removeEntityType(itemstack, false), (FluidStack)fluidStack);
                        if (!fluidActionResult.isSuccess()) continue;
                        if (BucketLibUtil.containsEntityType(itemstack)) {
                            this.spawnEntityFromBucket(player, level, itemstack, pos, false);
                        }
                        return InteractionResultHolder.m_19092_((Object)BucketLibUtil.createEmptyResult(itemstack, player, fluidActionResult.getResult(), interactionHand), (boolean)level.m_5776_());
                    }
                } else {
                    if (BucketLibUtil.containsEntityType(itemstack)) {
                        ItemStack emptyBucket = this.spawnEntityFromBucket(player, level, itemstack, relativeBlockPos, true);
                        return InteractionResultHolder.m_19092_((Object)BucketLibUtil.createEmptyResult(itemstack, player, emptyBucket, interactionHand), (boolean)level.m_5776_());
                    }
                    if (BucketLibUtil.containsBlock(itemstack)) {
                        Block block = BucketLibUtil.getBlock(itemstack);
                        RegistryUtil.BucketBlock bucketBlock = RegistryUtil.getBucketBlock(block);
                        if (block != null && bucketBlock != null) {
                            ItemStack fakeStack = new ItemStack((ItemLike)bucketBlock.bucketItem());
                            player.m_21008_(interactionHand, fakeStack);
                            InteractionResult interactionResult = fakeStack.m_41661_(new UseOnContext(player, interactionHand, blockHitResult));
                            player.m_21008_(interactionHand, itemstack);
                            if (interactionResult.m_19077_()) {
                                return new InteractionResultHolder(interactionResult, (Object)BucketLibUtil.createEmptyResult(itemstack, player, BucketLibUtil.removeBlock(itemstack, true), interactionHand));
                            }
                        }
                    }
                }
            }
        }
        if (BucketLibUtil.containsMilk(itemstack)) {
            return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)interactionHand);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public ItemStack spawnEntityFromBucket(@Nullable Player player, Level level, ItemStack itemStack, BlockPos pos, boolean damage) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            EntityType<?> entityType = BucketLibUtil.getEntityType(itemStack);
            if (entityType != null) {
                Entity entity = entityType.m_20592_(serverLevel, itemStack, null, pos, MobSpawnType.BUCKET, true, false);
                if (entity instanceof Bucketable) {
                    Bucketable bucketable = (Bucketable)entity;
                    bucketable.m_142278_(itemStack.m_41784_());
                    bucketable.m_27497_(true);
                }
                if (player != null) {
                    serverLevel.m_142346_((Entity)player, GameEvent.f_157810_, pos);
                }
                return BucketLibUtil.removeEntityType(itemStack, damage);
            }
        }
        return itemStack.m_41777_();
    }

    @Nonnull
    public InteractionResult m_6880_(@Nonnull ItemStack itemStack, @Nonnull Player player, @Nonnull LivingEntity entity, @Nonnull InteractionHand interactionHand) {
        InteractionResult result;
        if (entity instanceof Bucketable && !BucketLibUtil.containsEntityType(itemStack) && this.canHoldEntity(entity.m_6095_()) && (result = this.pickupEntityWithBucket(player, interactionHand, (LivingEntity)((Bucketable)entity))).m_19077_()) {
            return result;
        }
        if (this.canMilkEntities() && BucketLibUtil.isEmpty(itemStack)) {
            return WorldInteractionUtil.tryMilkLivingEntity(itemStack, entity, player, interactionHand);
        }
        if (entity instanceof Axolotl) {
            Axolotl axolotl = (Axolotl)entity;
            if (BucketLibUtil.containsEntityType(itemStack) && Arrays.stream(AxolotlAi.m_149287_().m_43908_()).anyMatch(stack -> {
                Item patt17869$temp = stack.m_41720_();
                if (!(patt17869$temp instanceof MobBucketItem)) return false;
                MobBucketItem mobBucketItem = (MobBucketItem)patt17869$temp;
                if (BucketLibUtil.getFluid(itemStack) != mobBucketItem.getFluid()) return false;
                if (BucketLibUtil.getEntityType(itemStack) != BucketLibUtil.getEntityTypeOfMobBucketItem(mobBucketItem)) return false;
                return true;
            })) {
                int age = axolotl.m_146764_();
                if (!axolotl.m_9236_().f_46443_ && age == 0 && axolotl.m_5957_()) {
                    if (!player.m_7500_()) {
                        player.m_21008_(interactionHand, BucketLibUtil.removeEntityType(itemStack, BucketLibUtil.getFluid(itemStack) == Fluids.f_76191_));
                    }
                    axolotl.m_27595_(player);
                    return InteractionResult.SUCCESS;
                }
                if (axolotl.m_6162_()) {
                    if (!player.m_7500_()) {
                        player.m_21008_(interactionHand, BucketLibUtil.removeEntityType(itemStack, BucketLibUtil.getFluid(itemStack) == Fluids.f_76191_));
                    }
                    axolotl.m_146740_(AgeableMob.m_216967_((int)(-age)), true);
                    return InteractionResult.m_19078_((boolean)axolotl.m_9236_().f_46443_);
                }
                if (axolotl.m_9236_().f_46443_) {
                    return InteractionResult.CONSUME;
                }
            }
        }
        return super.m_6880_(itemStack, player, entity, interactionHand);
    }

    private <T extends LivingEntity> InteractionResult pickupEntityWithBucket(Player player, InteractionHand interactionHand, T entity) {
        ItemStack itemStack = player.m_21120_(interactionHand).m_41777_();
        Fluid containedFluid = FluidUtil.getFluidContained((ItemStack)itemStack).orElse(FluidStack.EMPTY).getFluid();
        Fluid entityBucketFluid = ((BucketItem)((Bucketable)entity).m_28282_().m_41720_()).getFluid();
        if (itemStack.m_41720_() instanceof UniversalBucketItem && entity.m_6084_() && entityBucketFluid == containedFluid) {
            entity.m_5496_(((Bucketable)entity).m_142623_(), 1.0f, 1.0f);
            ItemStack filledItemStack = BucketLibUtil.addEntityType(itemStack, entity.m_6095_());
            ((Bucketable)entity).m_6872_(filledItemStack);
            Level level = entity.m_9236_();
            ItemStack handItemStack = ItemUtils.m_41817_((ItemStack)itemStack, (Player)player, (ItemStack)filledItemStack, (boolean)false);
            player.m_21008_(interactionHand, handItemStack);
            if (!level.f_46443_) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, new ItemStack((ItemLike)((Bucketable)entity).m_28282_().m_41720_()));
            }
            entity.m_146870_();
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    public ItemStack m_5922_(@Nonnull ItemStack itemStack, @Nonnull Level level, @Nonnull LivingEntity player) {
        if (!level.f_46443_) {
            player.curePotionEffects(new ItemStack((ItemLike)Items.f_42455_));
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.f_10592_.m_23682_(serverPlayer, new ItemStack((ItemLike)Items.f_42455_));
            serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)Items.f_42455_));
        }
        if (BucketLibUtil.notCreative((Entity)player)) {
            return BucketLibUtil.removeMilk(itemStack);
        }
        return itemStack;
    }

    public int m_8105_(@Nonnull ItemStack itemStack) {
        if (BucketLibUtil.containsMilk(itemStack)) {
            return 32;
        }
        return super.m_8105_(itemStack);
    }

    @Nonnull
    public UseAnim m_6164_(@Nonnull ItemStack itemStack) {
        if (BucketLibUtil.containsMilk(itemStack)) {
            return UseAnim.DRINK;
        }
        return super.m_6164_(itemStack);
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        Fluid fluid;
        if (!BucketLibUtil.containsEntityType(itemStack) && (fluid = FluidUtil.getFluidContained((ItemStack)itemStack).orElse(FluidStack.EMPTY).getFluid()) != Fluids.f_76191_) {
            return ForgeHooks.getBurnTime((ItemStack)new ItemStack((ItemLike)fluid.m_6859_()), recipeType);
        }
        return super.getBurnTime(itemStack, recipeType);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return !BucketLibUtil.isEmpty(stack) && !this.isCracked(stack);
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        if (!this.hasCraftingRemainingItem(itemStack)) {
            return ItemStack.f_41583_;
        }
        if (BucketLibUtil.isAffectedByInfinityEnchantment(itemStack)) {
            return itemStack.m_41777_();
        }
        ItemStack result = itemStack.m_41777_();
        boolean damaged = BucketLibUtil.containsFluid(result);
        if (BucketLibUtil.containsBlock(result)) {
            result = BucketLibUtil.removeBlock(result, !damaged);
            damaged = true;
        }
        if (BucketLibUtil.containsEntityType(result)) {
            result = BucketLibUtil.removeEntityType(result, !damaged);
        }
        if (BucketLibUtil.containsFluid(result) || BucketLibUtil.containsMilk(result)) {
            result = BucketLibUtil.removeFluid(result);
        }
        return result;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44952_ && ((Boolean)ServerConfig.INFINITY_ENCHANTMENT_ENABLED.get()).booleanValue() && EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44952_, (ItemStack)stack) <= 0 && FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY).getFluid().m_76145_().m_205070_(BucketLibTags.Fluids.INFINITY_ENCHANTABLE)) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable CompoundTag nbt) {
        return new UniversalBucketFluidHandler(stack);
    }

    private boolean getBooleanProperty(ForgeConfigSpec.BooleanValue config, boolean defaultValue) {
        if (config != null) {
            return (Boolean)config.get();
        }
        return defaultValue;
    }

    private Integer getIntProperty(ForgeConfigSpec.IntValue config, Integer defaultValue) {
        if (config != null) {
            return (Integer)config.get();
        }
        return defaultValue;
    }

    private <T> boolean isElementListedInProperty(T element, TagKey<T> tag, List<T> defaultList) {
        if (tag != null) {
            if (element instanceof Block) {
                Block block = (Block)element;
                return Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getTag(tag).contains((Object)block);
            }
            if (element instanceof Fluid) {
                Fluid fluid = (Fluid)element;
                return Objects.requireNonNull(ForgeRegistries.FLUIDS.tags()).getTag(tag).contains((Object)fluid);
            }
            if (element instanceof EntityType) {
                EntityType entityType = (EntityType)element;
                return Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.tags()).getTag(tag).contains((Object)entityType);
            }
        }
        return defaultList != null && defaultList.contains(element);
    }

    public ResourceKey<CreativeModeTab> getCreativeTab() {
        return this.properties.tab;
    }

    public int getDurability() {
        return this.getIntProperty(this.properties.durabilityConfig, this.properties.durability);
    }

    public boolean isDyeable() {
        return this.properties.dyeable;
    }

    public int getDefaultColor() {
        return this.properties.defaultColor;
    }

    public Integer getMaxTemperature() {
        return this.getIntProperty(this.properties.maxTemperatureConfig, this.properties.maxTemperature);
    }

    public Integer getUpperBreakTemperature() {
        return this.getIntProperty(this.properties.upperBreakTemperatureConfig, this.properties.upperCrackingTemperature);
    }

    public Integer getLowerBreakTemperature() {
        return this.getIntProperty(this.properties.lowerCrackingTemperatureConfig, this.properties.lowerCrackingTemperature);
    }

    public Integer getMinTemperature() {
        return this.getIntProperty(this.properties.minTemperatureConfig, this.properties.minTemperature);
    }

    private boolean isCrackingFluid(Fluid fluid) {
        return this.isElementListedInProperty(fluid, this.properties.crackingFluidsTag, this.properties.crackingFluids);
    }

    public Integer getBurningTemperature() {
        return this.getIntProperty(this.properties.burningTemperatureConfig, this.properties.burningTemperature);
    }

    public boolean isBurningFluid(Fluid fluid) {
        return this.isElementListedInProperty(fluid, this.properties.burningFluidsTag, this.properties.burningFluids);
    }

    public boolean isBurningBlock(Block block) {
        return this.isElementListedInProperty(block, this.properties.burningBlocksTag, this.properties.burningBlocks);
    }

    public Integer getFreezingTemperature() {
        return this.getIntProperty(this.properties.freezingTemperatureConfig, this.properties.freezingTemperature);
    }

    public boolean isFreezingFluid(Fluid fluid) {
        return this.isElementListedInProperty(fluid, this.properties.freezingFluidsTag, this.properties.freezingFluids);
    }

    public boolean isFreezingBlock(Block block) {
        return this.isElementListedInProperty(block, this.properties.freezingBlocksTag, this.properties.freezingBlocks);
    }

    private boolean isDeniedFluid(Fluid fluid) {
        return this.isElementListedInProperty(fluid, this.properties.deniedFluidsTag, this.properties.deniedFluids);
    }

    private boolean isAllowedFluid(Fluid fluid) {
        return this.isElementListedInProperty(fluid, this.properties.allowedFluidsTag, this.properties.allowedFluids);
    }

    public boolean canMilkEntities() {
        return this.getBooleanProperty(this.properties.milkingConfig, this.properties.milking);
    }

    private boolean canObtainEntities() {
        return this.getBooleanProperty(this.properties.entityObtainingConfig, this.properties.entityObtaining);
    }

    private boolean isDeniedEntity(EntityType<?> entityType) {
        return this.isElementListedInProperty(entityType, this.properties.deniedEntitiesTag, this.properties.deniedEntities);
    }

    private boolean isAllowedEntity(EntityType<?> entityType) {
        return this.isElementListedInProperty(entityType, this.properties.allowedEntitiesTag, this.properties.allowedEntities);
    }

    private boolean canObtainBlocks() {
        return this.getBooleanProperty(this.properties.blockObtainingConfig, this.properties.blockObtaining);
    }

    private boolean isDeniedBlock(Block block) {
        return this.isElementListedInProperty(block, this.properties.deniedBlocksTag, this.properties.deniedBlocks);
    }

    private boolean isAllowedBlock(Block block) {
        return this.isElementListedInProperty(block, this.properties.allowedBlocksTag, this.properties.allowedBlocks);
    }

    public static class Properties {
        ResourceKey<CreativeModeTab> tab = CreativeModeTabs.f_256869_;
        int maxStackSize = 16;
        int durability = 0;
        ForgeConfigSpec.IntValue durabilityConfig = null;
        boolean dyeable = false;
        int defaultColor = -1;
        Integer maxTemperature = null;
        ForgeConfigSpec.IntValue maxTemperatureConfig = null;
        Integer upperCrackingTemperature = null;
        ForgeConfigSpec.IntValue upperBreakTemperatureConfig = null;
        Integer lowerCrackingTemperature = null;
        ForgeConfigSpec.IntValue lowerCrackingTemperatureConfig = null;
        Integer minTemperature = null;
        ForgeConfigSpec.IntValue minTemperatureConfig = null;
        List<Fluid> crackingFluids = null;
        TagKey<Fluid> crackingFluidsTag = null;
        List<Fluid> deniedFluids = null;
        TagKey<Fluid> deniedFluidsTag = null;
        List<Fluid> allowedFluids = null;
        TagKey<Fluid> allowedFluidsTag = null;
        Integer burningTemperature = null;
        ForgeConfigSpec.IntValue burningTemperatureConfig = null;
        List<Fluid> burningFluids = null;
        TagKey<Fluid> burningFluidsTag = null;
        List<Block> burningBlocks = null;
        TagKey<Block> burningBlocksTag = null;
        Integer freezingTemperature = null;
        ForgeConfigSpec.IntValue freezingTemperatureConfig = null;
        List<Fluid> freezingFluids = null;
        TagKey<Fluid> freezingFluidsTag = null;
        List<Block> freezingBlocks = null;
        TagKey<Block> freezingBlocksTag = null;
        boolean milking = true;
        ForgeConfigSpec.BooleanValue milkingConfig = null;
        boolean entityObtaining = true;
        ForgeConfigSpec.BooleanValue entityObtainingConfig = null;
        List<EntityType<?>> deniedEntities = null;
        TagKey<EntityType<?>> deniedEntitiesTag = null;
        List<EntityType<?>> allowedEntities = null;
        TagKey<EntityType<?>> allowedEntitiesTag = null;
        boolean blockObtaining = true;
        ForgeConfigSpec.BooleanValue blockObtainingConfig = null;
        List<Block> deniedBlocks = null;
        TagKey<Block> deniedBlocksTag = null;
        List<Block> allowedBlocks = null;
        TagKey<Block> allowedBlocksTag = null;

        public Properties tab(ResourceKey<CreativeModeTab> tab) {
            this.tab = tab;
            return this;
        }

        public Properties stacksTo(int maxStackSize) {
            if (maxStackSize < 1) {
                throw new RuntimeException("Unable to have stack size lower than 1.");
            }
            this.maxStackSize = maxStackSize;
            return this;
        }

        public Properties durability(int durability) {
            if (durability < 0) {
                throw new RuntimeException("Unable to have a durability lower than 0.");
            }
            this.durability = durability;
            return this;
        }

        public Properties durability(ForgeConfigSpec.IntValue durabilityConfig) {
            this.durabilityConfig = durabilityConfig;
            return this;
        }

        public Properties dyeable(int defaultColor) {
            this.dyeable = true;
            this.defaultColor = defaultColor;
            return this;
        }

        public Properties dyeable(int red, int green, int blue) {
            this.dyeable = true;
            this.defaultColor = ColorUtil.getColorFromRGB(red, green, blue);
            return this;
        }

        public Properties maxTemperature(int maxTemperature) {
            this.maxTemperature = maxTemperature;
            return this;
        }

        public Properties maxTemperature(ForgeConfigSpec.IntValue maxTemperatureConfig) {
            this.maxTemperatureConfig = maxTemperatureConfig;
            return this;
        }

        public Properties upperCrackingTemperature(int upperCrackingTemperature) {
            this.upperCrackingTemperature = upperCrackingTemperature;
            return this;
        }

        public Properties upperCrackingTemperature(ForgeConfigSpec.IntValue upperCrackingTemperatureConfig) {
            this.upperBreakTemperatureConfig = upperCrackingTemperatureConfig;
            return this;
        }

        public Properties lowerCrackingTemperature(int lowerBreakTemperature) {
            this.lowerCrackingTemperature = lowerBreakTemperature;
            return this;
        }

        public Properties lowerCrackingTemperature(ForgeConfigSpec.IntValue lowerCrackingTemperatureConfig) {
            this.lowerCrackingTemperatureConfig = lowerCrackingTemperatureConfig;
            return this;
        }

        public Properties minTemperature(int minTemperature) {
            this.minTemperature = minTemperature;
            return this;
        }

        public Properties minTemperature(ForgeConfigSpec.IntValue minTemperatureConfig) {
            this.minTemperatureConfig = minTemperatureConfig;
            return this;
        }

        public Properties crackingFluids(List<Fluid> crackingFluids) {
            this.crackingFluids = crackingFluids;
            return this;
        }

        public Properties crackingFluids(TagKey<Fluid> crackingFluidsTag) {
            this.crackingFluidsTag = crackingFluidsTag;
            return this;
        }

        public Properties burningTemperature(int burningTemperature) {
            this.burningTemperature = burningTemperature;
            return this;
        }

        public Properties burningTemperature(ForgeConfigSpec.IntValue burningTemperatureConfig) {
            this.burningTemperatureConfig = burningTemperatureConfig;
            return this;
        }

        public Properties burningFluids(List<Fluid> burningFluids) {
            this.burningFluids = burningFluids;
            return this;
        }

        public Properties burningFluids(TagKey<Fluid> burningFluidsTag) {
            this.burningFluidsTag = burningFluidsTag;
            return this;
        }

        public Properties burningBlocks(List<Block> burningBlocks) {
            this.burningBlocks = burningBlocks;
            return this;
        }

        public Properties burningBlocks(TagKey<Block> burningBlocksTag) {
            this.burningBlocksTag = burningBlocksTag;
            return this;
        }

        public Properties freezingTemperature(int freezingTemperature) {
            this.freezingTemperature = freezingTemperature;
            return this;
        }

        public Properties freezingTemperature(ForgeConfigSpec.IntValue freezingTemperatureConfig) {
            this.freezingTemperatureConfig = freezingTemperatureConfig;
            return this;
        }

        public Properties freezingFluids(List<Fluid> freezingFluids) {
            this.freezingFluids = freezingFluids;
            return this;
        }

        public Properties freezingFluids(TagKey<Fluid> freezingFluidsTag) {
            this.freezingFluidsTag = freezingFluidsTag;
            return this;
        }

        public Properties freezingBlocks(List<Block> freezingBlocks) {
            this.freezingBlocks = freezingBlocks;
            return this;
        }

        public Properties freezingBlocks(TagKey<Block> freezingBlocksTag) {
            this.freezingBlocksTag = freezingBlocksTag;
            return this;
        }

        @Deprecated(since="0.5.3.0", forRemoval=true)
        public Properties blockedFluids(List<Fluid> blockedFluids) {
            return this.deniedFluids(blockedFluids);
        }

        @Deprecated(since="0.5.3.0", forRemoval=true)
        public Properties blockedFluids(TagKey<Fluid> deniedFluidsTag) {
            return this.deniedFluids(deniedFluidsTag);
        }

        public Properties deniedFluids(List<Fluid> deniedFluids) {
            this.deniedFluids = deniedFluids;
            return this;
        }

        public Properties deniedFluids(TagKey<Fluid> blockedFluidsTag) {
            this.deniedFluidsTag = blockedFluidsTag;
            return this;
        }

        public Properties allowedFluids(List<Fluid> allowedFluids) {
            this.allowedFluids = allowedFluids;
            return this;
        }

        public Properties allowedFluids(TagKey<Fluid> allowedFluidsTag) {
            this.allowedFluidsTag = allowedFluidsTag;
            return this;
        }

        public Properties disableMilking() {
            this.milking = false;
            return this;
        }

        public Properties milking(ForgeConfigSpec.BooleanValue milkingConfig) {
            this.milkingConfig = milkingConfig;
            return this;
        }

        public Properties disableEntityObtaining() {
            this.entityObtaining = false;
            return this;
        }

        public Properties entityObtaining(ForgeConfigSpec.BooleanValue entityObtainingConfig) {
            this.entityObtainingConfig = entityObtainingConfig;
            return this;
        }

        @Deprecated(since="0.5.3.0", forRemoval=true)
        public Properties blockedEntities(List<EntityType<?>> blockedEntities) {
            return this.deniedEntities(blockedEntities);
        }

        @Deprecated(since="0.5.3.0", forRemoval=true)
        public Properties blockedEntities(TagKey<EntityType<?>> blockedEntitiesTag) {
            return this.deniedEntities(blockedEntitiesTag);
        }

        public Properties deniedEntities(List<EntityType<?>> deniedEntities) {
            this.deniedEntities = deniedEntities;
            return this;
        }

        public Properties deniedEntities(TagKey<EntityType<?>> deniedEntitiesTag) {
            this.deniedEntitiesTag = deniedEntitiesTag;
            return this;
        }

        public Properties allowedEntities(List<EntityType<?>> allowedEntities) {
            this.allowedEntities = allowedEntities;
            return this;
        }

        public Properties allowedEntities(TagKey<EntityType<?>> allowedEntitiesTag) {
            this.allowedEntitiesTag = allowedEntitiesTag;
            return this;
        }

        public Properties disableBlockObtaining() {
            this.blockObtaining = false;
            return this;
        }

        public Properties blockObtaining(ForgeConfigSpec.BooleanValue blockObtainingConfig) {
            this.blockObtainingConfig = blockObtainingConfig;
            return this;
        }

        @Deprecated(since="0.5.3.0", forRemoval=true)
        public Properties blockedBlocks(List<Block> blockedBlocks) {
            return this.deniedBlocks(blockedBlocks);
        }

        @Deprecated(since="0.5.3.0", forRemoval=true)
        public Properties blockedBlocks(TagKey<Block> blockedBlocksTag) {
            return this.deniedBlocks(blockedBlocksTag);
        }

        public Properties deniedBlocks(List<Block> deniedBlocks) {
            this.deniedBlocks = deniedBlocks;
            return this;
        }

        public Properties deniedBlocks(TagKey<Block> deniedBlocksTag) {
            this.deniedBlocksTag = deniedBlocksTag;
            return this;
        }

        public Properties allowedBlocks(List<Block> allowedBlocks) {
            this.allowedBlocks = allowedBlocks;
            return this;
        }

        public Properties allowedBlocks(TagKey<Block> allowedBlocksTag) {
            this.allowedBlocksTag = allowedBlocksTag;
            return this;
        }
    }
}

