/*
 * Decompiled with CFR 0.152.
 */
package cech12.bucketlib.api.crafting;

import cech12.bucketlib.BucketLib;
import cech12.bucketlib.util.BucketLibUtil;
import cech12.bucketlib.util.RegistryUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;

public class BlockIngredient
extends Ingredient {
    protected final Block block;
    protected final TagKey<Block> tag;
    private ItemStack[] matchingStacks;

    private BlockIngredient(Block block, TagKey<Block> tag) {
        super(Stream.of(new Ingredient.Value[0]));
        this.block = block;
        this.tag = tag;
    }

    public BlockIngredient(Block block) {
        this(block, null);
    }

    public BlockIngredient(TagKey<Block> tag) {
        this(null, tag);
    }

    public boolean test(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return false;
        }
        ITag blockIterator = this.block != null ? List.of(this.block) : Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getTag(this.tag);
        for (Block block : blockIterator) {
            RegistryUtil.BucketBlock bucketBlock = RegistryUtil.getBucketBlock(block);
            if (bucketBlock == null) continue;
            if (itemStack.m_41720_() == bucketBlock.bucketItem()) {
                return true;
            }
            return BucketLibUtil.getBlock(itemStack) == block;
        }
        return false;
    }

    @Nonnull
    public ItemStack[] m_43908_() {
        if (this.matchingStacks == null) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            ArrayList<Block> blocks = new ArrayList<Block>();
            ITagManager blockTags = ForgeRegistries.BLOCKS.tags();
            if (this.tag != null && blockTags != null) {
                blockTags.getTag(this.tag).forEach(blocks::add);
            } else if (this.block != null) {
                blocks.add(this.block);
            }
            List<RegistryUtil.BucketBlock> bucketBlocks = RegistryUtil.getBucketBlocks().stream().filter(bucketBlock -> blocks.contains(bucketBlock.block())).toList();
            for (RegistryUtil.BucketBlock bucketBlock2 : bucketBlocks) {
                stacks.add(new ItemStack((ItemLike)bucketBlock2.bucketItem()));
            }
            for (RegistryUtil.BucketBlock bucketBlock2 : bucketBlocks) {
                BucketLib.getRegisteredBuckets().forEach(bucket -> {
                    if (bucket.canHoldBlock(bucketBlock2.block())) {
                        stacks.add(BucketLibUtil.addBlock(new ItemStack((ItemLike)bucket), bucketBlock2.block()));
                    }
                });
            }
            this.matchingStacks = stacks.toArray(new ItemStack[0]);
        }
        return this.matchingStacks;
    }

    public boolean m_43947_() {
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    protected void invalidate() {
        this.matchingStacks = null;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    @Nonnull
    public JsonElement m_43942_() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", Serializer.NAME.toString());
        if (this.block != null) {
            jsonObject.addProperty("entity", Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)this.block)).toString());
        }
        if (this.tag != null) {
            jsonObject.addProperty("tag", this.tag.f_203868_().toString());
        }
        return jsonObject;
    }

    public static final class Serializer
    implements IIngredientSerializer<BlockIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation NAME = new ResourceLocation("bucketlib", "block");

        private Serializer() {
        }

        @Nonnull
        public BlockIngredient parse(@Nonnull FriendlyByteBuf buffer) {
            String block = buffer.m_130277_();
            String tagId = buffer.m_130277_();
            if (!tagId.isEmpty()) {
                TagKey tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)new ResourceLocation(tagId));
                return new BlockIngredient((TagKey<Block>)tag);
            }
            if (block.isEmpty()) {
                throw new IllegalArgumentException("Cannot create a block ingredient with no block or tag.");
            }
            return new BlockIngredient((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(block)));
        }

        @Nonnull
        public BlockIngredient parse(@Nonnull JsonObject json) {
            if (json.has("tag")) {
                ResourceLocation tagId = new ResourceLocation(json.get("tag").getAsString());
                TagKey tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)tagId);
                return new BlockIngredient((TagKey<Block>)tag);
            }
            ResourceLocation block = new ResourceLocation(json.get("block").getAsString());
            if (!ForgeRegistries.BLOCKS.containsKey(block)) {
                throw new JsonSyntaxException("Unknown block: " + block);
            }
            return new BlockIngredient((Block)ForgeRegistries.BLOCKS.getValue(block));
        }

        public void write(@Nonnull FriendlyByteBuf buffer, @Nonnull BlockIngredient ingredient) {
            buffer.m_130070_(ingredient.block != null ? Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)ingredient.block)).toString() : "");
            buffer.m_130070_(ingredient.tag != null ? ingredient.tag.f_203868_().toString() : "");
        }
    }
}

