/*
 * Decompiled with CFR 0.152.
 */
package com.bobvarioa.kubejsbotanypots.recipes;

import com.bobvarioa.kubejsbotanypots.components.DisplayComponent;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.ItemComponents;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentWithParent;
import dev.latvian.mods.kubejs.recipe.component.StringComponent;
import dev.latvian.mods.kubejs.recipe.component.TimeComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import net.darkhax.botanypots.data.displaystate.DisplayState;
import org.jetbrains.annotations.Nullable;

public interface CropRecipeJS {
    public static final RecipeKey<InputItem> SEED = ItemComponents.INPUT.key("seed");
    public static final RecipeKey<String[]> CATEGORIES = StringComponent.ANY.asArray().key("categories");
    public static final RecipeKey<Long> GROWTH_TICKS = TimeComponent.TICKS.key("growthTicks");
    public static final RecipeKey<Float> GROWTH_MODIFIER = NumberComponent.FLOAT.key("growthModifier").optional((Object)Float.valueOf(1.0f));
    public static final RecipeKey<DisplayState[]> DISPLAY = DisplayComponent.ANY.asArrayOrSelf().key("display");
    public static final RecipeComponent<OutputItem> ID_CHANCE = new RecipeComponentWithParent<OutputItem>(){

        public RecipeComponent<OutputItem> parentComponent() {
            return ItemComponents.OUTPUT;
        }

        @Nullable
        public JsonElement write(RecipeJS recipe, OutputItem value) {
            JsonObject json = super.write(recipe, (Object)value).getAsJsonObject();
            json.add("output", json.get("item"));
            return json;
        }

        public OutputItem read(RecipeJS recipe, Object from) {
            if (from instanceof JsonObject) {
                JsonObject json = (JsonObject)from;
                json.add("item", json.get("output").getAsJsonObject().get("item"));
                return (OutputItem)super.read(recipe, (Object)json);
            }
            return (OutputItem)super.read(recipe, from);
        }
    };
    public static final RecipeKey<OutputItem[]> DROPS = ID_CHANCE.asArray().key("drops");
    public static final RecipeSchema SCHEMA = new RecipeSchema(new RecipeKey[]{SEED, CATEGORIES, DISPLAY, DROPS, GROWTH_TICKS, GROWTH_MODIFIER});
}

