/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.endrem.utils;

import com.google.common.collect.ImmutableList;
import com.teamremastered.endrem.blocks.AncientPortalFrame;
import com.teamremastered.endrem.blocks.ERFrameProperties;
import com.teamremastered.endrem.registers.ERBlocks;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ERPortalPredicate
implements Predicate<BlockState> {
    private final ImmutableList<Block> VALID_BLOCKS = ImmutableList.of((Object)Blocks.f_50258_, (Object)((Block)ERBlocks.ANCIENT_PORTAL_FRAME.get()));
    private final Direction DIRECTION;
    private ERFrameProperties EXCLUDED_EYE;
    private boolean REQUIRE_ANCIENT_FRAME = false;

    private ERPortalPredicate(Direction directionIn) {
        this.DIRECTION = directionIn;
    }

    @Override
    public boolean test(@Nullable BlockState blockstate) {
        if (blockstate != null && this.VALID_BLOCKS.contains((Object)blockstate.m_60734_())) {
            if (blockstate.m_60734_() != ERBlocks.ANCIENT_PORTAL_FRAME.get() && this.REQUIRE_ANCIENT_FRAME) {
                return false;
            }
            if (blockstate.m_60734_().equals(ERBlocks.ANCIENT_PORTAL_FRAME.get()) && this.EXCLUDED_EYE != null && ((ERFrameProperties)((Object)blockstate.m_61143_(AncientPortalFrame.EYE))).equals((Object)this.EXCLUDED_EYE)) {
                return false;
            }
            return blockstate.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == this.DIRECTION;
        }
        return false;
    }

    public static ERPortalPredicate facing(Direction direction) {
        return new ERPortalPredicate(direction);
    }

    public ERPortalPredicate withoutEye(ERFrameProperties eye) {
        this.EXCLUDED_EYE = eye;
        return this;
    }

    public ERPortalPredicate requireAncientFrame(boolean var) {
        this.REQUIRE_ANCIENT_FRAME = var;
        return this;
    }
}

