/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import java.util.Collection;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformModHelper;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class ErrorUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private ErrorUtil() {
    }

    public static <T> String getIngredientInfo(T ingredient, IIngredientType<T> ingredientType, IIngredientManager ingredientManager) {
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
        return ingredientHelper.getErrorInfo(ingredient);
    }

    public static String getItemStackInfo(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return "null";
        }
        Item item = itemStack.m_41720_();
        IPlatformRegistry<Item> itemRegistry = Services.PLATFORM.getRegistry(Registries.f_256913_);
        String itemName = itemRegistry.getRegistryName(item).map(ResourceLocation::toString).orElseGet(() -> {
            if (item instanceof BlockItem) {
                String blockName;
                Block block = ((BlockItem)item).m_40614_();
                if (block == null) {
                    blockName = "null";
                } else {
                    IPlatformRegistry<Block> blockRegistry = Services.PLATFORM.getRegistry(Registries.f_256747_);
                    blockName = blockRegistry.getRegistryName(block).map(ResourceLocation::toString).orElseGet(() -> block.getClass().getName());
                }
                return "BlockItem(" + blockName + ")";
            }
            return item.getClass().getName();
        });
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt != null) {
            return itemStack + " " + itemName + " nbt:" + nbt;
        }
        return itemStack + " " + itemName;
    }

    public static void checkNotEmpty(ItemStack itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("ItemStack must not be null.");
        }
        if (itemStack.m_41619_()) {
            String info = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("ItemStack value must not be empty. " + info);
        }
    }

    public static void checkNotEmpty(ItemStack itemStack, String name) {
        if (itemStack == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (itemStack.m_41619_()) {
            String info = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("ItemStack " + name + " must not be empty. " + info);
        }
    }

    public static <T> void checkNotEmpty(T[] values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException(name + " must not be empty.");
        }
        for (T value : values) {
            if (value != null) continue;
            throw new NullPointerException(name + " must not contain null values.");
        }
    }

    public static void checkNotEmpty(Collection<?> values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (values.isEmpty()) {
            throw new IllegalArgumentException(name + " must not be empty.");
        }
        if (!(values instanceof NonNullList)) {
            for (Object value : values) {
                if (value != null) continue;
                throw new NullPointerException(name + " must not contain null values.");
            }
        }
    }

    public static <T> void checkNotNull(@Nullable T object, String name) {
        if (object == null) {
            throw new NullPointerException(name + " must not be null.");
        }
    }

    public static void checkNotNull(Collection<?> values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (!(values instanceof NonNullList)) {
            for (Object value : values) {
                if (value != null) continue;
                throw new NullPointerException(name + " must not contain null values.");
            }
        }
    }

    public static void assertMainThread() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft != null && !minecraft.m_18695_()) {
            Thread currentThread = Thread.currentThread();
            throw new IllegalStateException("A JEI API method is being called by another mod from the wrong thread:\n" + currentThread + "\nIt must be called on the main thread by using Minecraft.addScheduledTask.");
        }
    }

    public static <T> CrashReport createIngredientCrashReport(Throwable throwable, String title, IIngredientManager ingredientManager, ITypedIngredient<T> typedIngredient) {
        CrashReport crashReport = CrashReport.m_127521_((Throwable)throwable, (String)title);
        IIngredientType<T> ingredientType = typedIngredient.getType();
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
        CrashReportCategory category = crashReport.m_127514_("Ingredient");
        ErrorUtil.setIngredientCategoryDetails(category, typedIngredient, ingredientHelper);
        return crashReport;
    }

    public static <T> void logIngredientCrash(Throwable throwable, String title, IIngredientManager ingredientManager, ITypedIngredient<T> typedIngredient) {
        CrashReportCategory category = new CrashReportCategory("Ingredient");
        IIngredientType<T> ingredientType = typedIngredient.getType();
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
        ErrorUtil.setIngredientCategoryDetails(category, typedIngredient, ingredientHelper);
        LOGGER.error(ErrorUtil.crashReportToString(throwable, title, category));
    }

    private static <T> void setIngredientCategoryDetails(CrashReportCategory category, ITypedIngredient<T> typedIngredient, IIngredientHelper<T> ingredientHelper) {
        Object ingredient = typedIngredient.getIngredient();
        IIngredientType ingredientType = typedIngredient.getType();
        IPlatformModHelper modHelper = Services.PLATFORM.getModHelper();
        category.m_128165_("Name", () -> ingredientHelper.getDisplayName(ingredient));
        category.m_128165_("Mod's Name", () -> {
            String modId = ingredientHelper.getDisplayModId(ingredient);
            return modHelper.getModNameForModId(modId);
        });
        category.m_128165_("Registry Name", () -> ingredientHelper.getResourceLocation(ingredient).toString());
        category.m_128165_("Class Name", () -> ingredient.getClass().toString());
        category.m_128165_("toString Name", ingredient::toString);
        category.m_128165_("Unique Id for JEI (for JEI Blacklist)", () -> ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient));
        category.m_128165_("Ingredient Type for JEI", () -> ingredientType.getIngredientClass().toString());
        category.m_128165_("Error Info gathered from JEI", () -> ingredientHelper.getErrorInfo(ingredient));
    }

    private static String crashReportToString(Throwable t, String title, CrashReportCategory ... categories) {
        StringBuilder sb = new StringBuilder();
        sb.append(title);
        sb.append(":\n\n");
        for (CrashReportCategory category : categories) {
            category.m_128168_(sb);
            sb.append("\n\n");
        }
        sb.append("-- Stack Trace --\n\n");
        sb.append(ExceptionUtils.getStackTrace((Throwable)t));
        return sb.toString();
    }
}

