/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public final class TooltipRenderer {
    private TooltipRenderer() {
    }

    public static void drawHoveringText(GuiGraphics guiGraphics, List<Component> textLines, int x, int y) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        TooltipRenderer.drawHoveringText(guiGraphics, textLines, x, y, ItemStack.f_41583_, font);
    }

    public static <T> void drawHoveringText(GuiGraphics guiGraphics, List<Component> textLines, int x, int y, ITypedIngredient<T> typedIngredient, IIngredientManager ingredientManager) {
        IIngredientType<T> ingredientType = typedIngredient.getType();
        IIngredientRenderer<T> ingredientRenderer = ingredientManager.getIngredientRenderer(ingredientType);
        TooltipRenderer.drawHoveringText(guiGraphics, textLines, x, y, typedIngredient, ingredientRenderer, ingredientManager);
    }

    public static <T> void drawHoveringText(GuiGraphics guiGraphics, List<Component> textLines, int x, int y, ITypedIngredient<T> typedIngredient, IIngredientRenderer<T> ingredientRenderer, IIngredientManager ingredientManager) {
        ItemStack i;
        Minecraft minecraft = Minecraft.m_91087_();
        T ingredient = typedIngredient.getIngredient();
        Font font = ingredientRenderer.getFontRenderer(minecraft, ingredient);
        ItemStack itemStack = ingredient instanceof ItemStack ? (i = (ItemStack)ingredient) : ItemStack.f_41583_;
        try {
            TooltipRenderer.drawHoveringText(guiGraphics, textLines, x, y, itemStack, font);
        }
        catch (RuntimeException e) {
            CrashReport crashReport = ErrorUtil.createIngredientCrashReport(e, "Rendering ingredient tooltip", ingredientManager, typedIngredient);
            CrashReportCategory reportCategory = crashReport.m_127514_("Tooltip");
            for (int i2 = 0; i2 < textLines.size(); ++i2) {
                Component line = textLines.get(i2);
                reportCategory.m_128159_("line #" + i2 + " getString", (Object)line.getString());
                reportCategory.m_128159_("line #" + i2 + " getClass", line.getClass());
                try {
                    TooltipRenderer.drawHoveringText(guiGraphics, List.of(line), x, y, itemStack, font);
                    continue;
                }
                catch (RuntimeException ignored) {
                    reportCategory.m_128159_("line #" + i2 + " CRASHED", (Object)true);
                }
            }
            throw new ReportedException(crashReport);
        }
    }

    private static void drawHoveringText(GuiGraphics guiGraphics, List<Component> textLines, int x, int y, ItemStack itemStack, Font font) {
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (screen == null) {
            return;
        }
        Optional tooltipImage = itemStack.m_150921_();
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        renderHelper.renderTooltip(screen, guiGraphics, textLines, tooltipImage, x, y, font, itemStack);
    }
}

