/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.container.transfer;

import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.container.transfer.FilterInventoryWrapper;
import com.refinedmods.refinedstorage.container.transfer.FluidFilterInventoryWrapper;
import com.refinedmods.refinedstorage.container.transfer.IInventoryWrapper;
import com.refinedmods.refinedstorage.container.transfer.InsertionResult;
import com.refinedmods.refinedstorage.container.transfer.InsertionResultType;
import com.refinedmods.refinedstorage.container.transfer.InventoryInventoryWrapper;
import com.refinedmods.refinedstorage.container.transfer.ItemFilterInventoryWrapper;
import com.refinedmods.refinedstorage.container.transfer.ItemHandlerInventoryWrapper;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;

public class TransferManager {
    private final Map<IInventoryWrapper, List<IInventoryWrapper>> fromToMap = new HashMap<IInventoryWrapper, List<IInventoryWrapper>>();
    private final AbstractContainerMenu container;
    @Nullable
    private Function<Integer, ItemStack> notFoundHandler;

    public TransferManager(AbstractContainerMenu container) {
        this.container = container;
    }

    public void clearTransfers() {
        this.fromToMap.clear();
    }

    public void setNotFoundHandler(@Nullable Function<Integer, ItemStack> handler) {
        this.notFoundHandler = handler;
    }

    public void addTransfer(Container from, IItemHandler to) {
        this.addTransfer(new InventoryInventoryWrapper(from), new ItemHandlerInventoryWrapper(to));
    }

    public void addTransfer(Container from, Container to) {
        this.addTransfer(new InventoryInventoryWrapper(from), new InventoryInventoryWrapper(to));
    }

    public void addFilterTransfer(Container from, IItemHandlerModifiable itemTo, FluidInventory fluidTo, Supplier<Integer> typeGetter) {
        this.addTransfer(new InventoryInventoryWrapper(from), new FilterInventoryWrapper(itemTo, fluidTo, typeGetter));
    }

    public void addItemFilterTransfer(Container from, IItemHandlerModifiable to) {
        this.addTransfer(new InventoryInventoryWrapper(from), new ItemFilterInventoryWrapper(to));
    }

    public void addFluidFilterTransfer(Container from, FluidInventory to) {
        this.addTransfer(new InventoryInventoryWrapper(from), new FluidFilterInventoryWrapper(to));
    }

    public void addTransfer(IItemHandler from, Container to) {
        this.addTransfer(new ItemHandlerInventoryWrapper(from), new InventoryInventoryWrapper(to));
    }

    public void addBiTransfer(Container from, IItemHandler to) {
        this.addTransfer(from, to);
        this.addTransfer(to, from);
    }

    private void addTransfer(IInventoryWrapper from, IInventoryWrapper to) {
        List toList = this.fromToMap.computeIfAbsent(from, k -> new LinkedList());
        toList.add(to);
    }

    public ItemStack transfer(int index) {
        Slot slot = this.container.m_38853_(index);
        IInventoryWrapper key = slot instanceof SlotItemHandler ? new ItemHandlerInventoryWrapper(((SlotItemHandler)slot).getItemHandler()) : new InventoryInventoryWrapper(slot.f_40218_);
        List<IInventoryWrapper> toList = this.fromToMap.get(key);
        if (toList != null) {
            IInventoryWrapper to;
            InsertionResult result;
            ItemStack initial = slot.m_7993_().m_41777_();
            ItemStack remainder = slot.m_7993_();
            Iterator<IInventoryWrapper> iterator = toList.iterator();
            while (iterator.hasNext() && (result = (to = iterator.next()).insert(remainder)).getType() != InsertionResultType.STOP && (result.getType() != InsertionResultType.CONTINUE_IF_POSSIBLE || !(remainder = result.getValue()).m_41619_())) {
            }
            slot.m_5852_(remainder);
            slot.m_6654_();
            if (API.instance().getComparer().isEqual(remainder, initial) && this.notFoundHandler != null) {
                return this.notFoundHandler.apply(index);
            }
        } else if (this.notFoundHandler != null) {
            return this.notFoundHandler.apply(index);
        }
        return ItemStack.f_41583_;
    }
}

