/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.Content;
import com.tom.storagemod.gui.CraftingTerminalMenu;
import com.tom.storagemod.platform.PlatformRecipe;
import com.tom.storagemod.tile.StorageTerminalBlockEntity;
import com.tom.storagemod.util.CraftingMatrix;
import com.tom.storagemod.util.StoredItemStack;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CraftingTerminalBlockEntity
extends StorageTerminalBlockEntity {
    private AbstractContainerMenu craftingContainer = new AbstractContainerMenu(MenuType.f_39968_, 0){

        public boolean m_6875_(Player player) {
            return false;
        }

        public void m_6199_(Container inventory) {
            if (CraftingTerminalBlockEntity.this.f_58857_ != null && !((CraftingTerminalBlockEntity)CraftingTerminalBlockEntity.this).f_58857_.f_46443_) {
                CraftingTerminalBlockEntity.this.onCraftingMatrixChanged();
            }
        }

        public ItemStack m_7648_(Player p_38941_, int p_38942_) {
            return ItemStack.f_41583_;
        }
    };
    private PlatformRecipe currentRecipe;
    private final CraftingContainer craftMatrix = new CraftingMatrix(3, 3, () -> {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.onCraftingMatrixChanged();
        }
        this.m_6596_();
    });
    private ResultContainer craftResult = new ResultContainer();
    private HashSet<CraftingTerminalMenu> craftingListeners = new HashSet();
    private boolean refillingGrid;
    private int craftingCooldown;
    private boolean reading;

    public CraftingTerminalBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Content.craftingTerminalTile.get(), pos, state);
    }

    @Override
    public AbstractContainerMenu m_7208_(int id, Inventory plInv, Player arg2) {
        return new CraftingTerminalMenu(id, plInv, this);
    }

    @Override
    public Component m_5446_() {
        return Component.m_237115_((String)"ts.crafting_terminal");
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        ListTag listnbt = new ListTag();
        for (int i = 0; i < this.craftMatrix.m_6643_(); ++i) {
            ItemStack itemstack = this.craftMatrix.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundnbt = new CompoundTag();
            compoundnbt.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(compoundnbt);
            listnbt.add((Object)compoundnbt);
        }
        compound.m_128365_("CraftingTable", (Tag)listnbt);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.reading = true;
        ListTag listnbt = compound.m_128437_("CraftingTable", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundTag compoundnbt = listnbt.m_128728_(i);
            int j = compoundnbt.m_128445_("Slot") & 0xFF;
            if (j < 0 || j >= this.craftMatrix.m_6643_()) continue;
            this.craftMatrix.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundnbt));
        }
        this.reading = false;
    }

    public CraftingContainer getCraftingInv() {
        return this.craftMatrix;
    }

    public ResultContainer getCraftResult() {
        return this.craftResult;
    }

    public void craft(Player thePlayer) {
        if (this.currentRecipe != null) {
            NonNullList<ItemStack> remainder = this.currentRecipe.getRemainingItems(this.craftMatrix);
            boolean playerInvUpdate = false;
            this.refillingGrid = true;
            for (int i = 0; i < remainder.size(); ++i) {
                ItemStack slot = this.craftMatrix.m_8020_(i);
                ItemStack oldItem = slot.m_41777_();
                ItemStack rem = (ItemStack)remainder.get(i);
                if (ItemStack.m_41728_((ItemStack)slot, (ItemStack)rem)) continue;
                if (!slot.m_41619_()) {
                    this.craftMatrix.m_7407_(i, 1);
                    slot = this.craftMatrix.m_8020_(i);
                }
                if (slot.m_41619_() && !oldItem.m_41619_()) {
                    StoredItemStack is = this.pullStack(new StoredItemStack(oldItem), 1L);
                    if (is == null && (this.getSorting() & 0x100) != 0) {
                        for (int j = 0; j < thePlayer.m_150109_().m_6643_(); ++j) {
                            ItemStack st = thePlayer.m_150109_().m_8020_(j);
                            if (!ItemStack.m_150942_((ItemStack)oldItem, (ItemStack)st) || (st = thePlayer.m_150109_().m_7407_(j, 1)).m_41619_()) continue;
                            is = new StoredItemStack(st, 1L);
                            playerInvUpdate = true;
                            break;
                        }
                    }
                    if (is != null) {
                        this.craftMatrix.m_6836_(i, is.getActualStack());
                        slot = this.craftMatrix.m_8020_(i);
                    }
                }
                if (rem.m_41619_()) continue;
                if (slot.m_41619_()) {
                    this.craftMatrix.m_6836_(i, rem);
                    continue;
                }
                if ((rem = this.pushStack(rem)).m_41619_() || thePlayer.m_150109_().m_36054_(rem)) continue;
                thePlayer.m_36176_(rem, false);
            }
            this.refillingGrid = false;
            this.onCraftingMatrixChanged();
            this.craftingCooldown += this.craftResult.m_8020_(0).m_41613_();
            if (playerInvUpdate) {
                thePlayer.f_36096_.m_38946_();
            }
        }
    }

    public void unregisterCrafting(CraftingTerminalMenu containerCraftingTerminal) {
        this.craftingListeners.remove(containerCraftingTerminal);
    }

    public void registerCrafting(CraftingTerminalMenu containerCraftingTerminal) {
        this.craftingListeners.add(containerCraftingTerminal);
    }

    protected void onCraftingMatrixChanged() {
        if (this.refillingGrid) {
            return;
        }
        if (this.currentRecipe == null || !this.currentRecipe.matches((Container)this.craftMatrix, this.f_58857_)) {
            this.currentRecipe = PlatformRecipe.of(this.f_58857_.m_7465_().m_44015_(RecipeType.f_44107_, (Container)this.craftMatrix, this.f_58857_).orElse(null));
        }
        if (this.currentRecipe == null) {
            this.craftResult.m_6836_(0, ItemStack.f_41583_);
        } else {
            this.craftResult.m_6836_(0, this.currentRecipe.assemble((Container)this.craftMatrix, this.f_58857_.m_9598_()));
        }
        this.craftingListeners.forEach(CraftingTerminalMenu::onCraftMatrixChanged);
        this.craftResult.m_6029_(this.currentRecipe == null ? null : this.currentRecipe.recipe());
        if (!this.reading) {
            this.m_6596_();
        }
    }

    public void clear() {
        for (int i = 0; i < this.craftMatrix.m_6643_(); ++i) {
            ItemStack st = this.craftMatrix.m_8016_(i);
            if (st.m_41619_()) continue;
            this.pushOrDrop(st);
        }
        this.onCraftingMatrixChanged();
    }

    public void handlerItemTransfer(Player player, ItemStack[][] items) {
        this.clear();
        for (int i = 0; i < 9; ++i) {
            int j;
            if (items[i] == null) continue;
            ItemStack stack = ItemStack.f_41583_;
            for (j = 0; j < items[i].length; ++j) {
                ItemStack pulled = this.pullStack(items[i][j]);
                if (pulled.m_41619_()) continue;
                stack = pulled;
                break;
            }
            if (stack.m_41619_()) {
                for (j = 0; j < items[i].length; ++j) {
                    boolean br = false;
                    for (int k = 0; k < player.m_150109_().m_6643_(); ++k) {
                        if (!ItemStack.m_150942_((ItemStack)player.m_150109_().m_8020_(k), (ItemStack)items[i][j])) continue;
                        stack = player.m_150109_().m_7407_(k, 1);
                        br = true;
                        break;
                    }
                    if (br) break;
                }
            }
            if (stack.m_41619_()) continue;
            this.craftMatrix.m_6836_(i, stack);
        }
        this.onCraftingMatrixChanged();
    }

    private ItemStack pullStack(ItemStack itemStack) {
        StoredItemStack is = this.pullStack(new StoredItemStack(itemStack), 1L);
        if (is == null) {
            return ItemStack.f_41583_;
        }
        return is.getActualStack();
    }

    @Override
    public void updateServer() {
        super.updateServer();
        this.craftingCooldown = 0;
    }

    public boolean canCraft() {
        return this.craftingCooldown + this.craftResult.m_8020_(0).m_41613_() <= this.craftResult.m_8020_(0).m_41741_();
    }
}

