/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.Config;
import com.tom.storagemod.Content;
import com.tom.storagemod.block.IInventoryCable;
import com.tom.storagemod.block.InventoryCableConnectorBlock;
import com.tom.storagemod.tile.InventoryConnectorBlockEntity;
import com.tom.storagemod.tile.PaintedBlockEntity;
import com.tom.storagemod.util.IProxy;
import com.tom.storagemod.util.TickerUtil;
import java.util.HashSet;
import java.util.Stack;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class AbstractInventoryCableConnectorBlockEntity
extends PaintedBlockEntity
implements TickerUtil.TickableServer {
    protected InventoryConnectorBlockEntity master;
    protected LazyOptional<IItemHandler> invHandler;
    protected LazyOptional<IItemHandler> pointedAt;
    protected InventoryConnectorBlockEntity.LinkedInv linv;

    public AbstractInventoryCableConnectorBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    @Override
    public void updateServer() {
        if (!this.f_58857_.f_46443_ && this.f_58857_.m_46467_() % 20L == 19L) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            Direction facing = (Direction)state.m_61143_((Property)InventoryCableConnectorBlock.FACING);
            Stack<BlockPos> toCheck = new Stack<BlockPos>();
            HashSet<BlockPos> checkedBlocks = new HashSet<BlockPos>();
            checkedBlocks.add(this.f_58858_);
            toCheck.addAll(((IInventoryCable)state.m_60734_()).next(this.f_58857_, state, this.f_58858_));
            if (this.master != null) {
                this.master.unLink(this.linv);
            }
            this.master = null;
            this.linv = new InventoryConnectorBlockEntity.LinkedInv();
            this.initLinv();
            while (!toCheck.isEmpty()) {
                BlockPos cp = (BlockPos)toCheck.pop();
                if (checkedBlocks.contains(cp)) continue;
                checkedBlocks.add(cp);
                if (this.f_58857_.m_46749_(cp)) {
                    state = this.f_58857_.m_8055_(cp);
                    if (state.m_60734_() == Content.connector.get()) {
                        BlockEntity te = this.f_58857_.m_7702_(cp);
                        if (!(te instanceof InventoryConnectorBlockEntity)) break;
                        this.master = (InventoryConnectorBlockEntity)te;
                        this.linv.time = this.f_58857_.m_46467_();
                        this.linv.handler = this::getPointedAtHandler;
                        this.master.addLinked(this.linv);
                        break;
                    }
                    if (state.m_60734_() instanceof IInventoryCable) {
                        toCheck.addAll(((IInventoryCable)state.m_60734_()).next(this.f_58857_, state, cp));
                    }
                }
                if (checkedBlocks.size() <= Config.get().invConnectorMax) continue;
                break;
            }
            this.pointedAt = this.getPointedAt(this.f_58858_.m_121945_(facing), facing);
        }
    }

    protected void initLinv() {
    }

    protected LazyOptional<IItemHandler> getPointedAt(BlockPos pos, Direction facing) {
        BlockEntity te = this.f_58857_.m_7702_(pos);
        if (te != null) {
            return te.getCapability(ForgeCapabilities.ITEM_HANDLER, facing.m_122424_());
        }
        return null;
    }

    private LazyOptional<IItemHandler> getPointedAtHandler() {
        return this.pointedAt == null ? LazyOptional.empty() : this.applyFilter(this.pointedAt);
    }

    protected LazyOptional<IItemHandler> applyFilter(LazyOptional<IItemHandler> to) {
        return to;
    }

    protected LazyOptional<IItemHandler> makeCapability() {
        return this.applyFilter((LazyOptional<IItemHandler>)LazyOptional.of(() -> new InvHandler()));
    }

    protected LazyOptional<IItemHandler> getCapability() {
        if (this.invHandler == null) {
            this.invHandler = this.makeCapability();
        }
        return this.invHandler;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.invHandler != null) {
            this.invHandler.invalidate();
        }
    }

    private class InvHandler
    implements IItemHandler,
    IProxy {
        private boolean calling;

        private InvHandler() {
        }

        public <R> R call(Function<IItemHandler, R> func, R def) {
            if (this.calling) {
                return def;
            }
            this.calling = true;
            if (AbstractInventoryCableConnectorBlockEntity.this.master != null && !AbstractInventoryCableConnectorBlockEntity.this.master.m_58901_()) {
                R r = func.apply((IItemHandler)AbstractInventoryCableConnectorBlockEntity.this.master.getInventory().orElse((Object)EmptyHandler.INSTANCE));
                this.calling = false;
                return r;
            }
            this.calling = false;
            return def;
        }

        public int getSlots() {
            return this.call(IItemHandler::getSlots, 0);
        }

        public ItemStack getStackInSlot(int slot) {
            return this.call(i -> i.getStackInSlot(slot), ItemStack.f_41583_);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.call(i -> i.insertItem(slot, stack, simulate), stack);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.call(i -> i.extractItem(slot, amount, simulate), ItemStack.f_41583_);
        }

        public int getSlotLimit(int slot) {
            return this.call(i -> i.getSlotLimit(slot), 0);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.call(i -> i.isItemValid(slot, stack), false);
        }

        @Override
        public IItemHandler get() {
            if (AbstractInventoryCableConnectorBlockEntity.this.master != null && !AbstractInventoryCableConnectorBlockEntity.this.master.m_58901_()) {
                return (IItemHandler)AbstractInventoryCableConnectorBlockEntity.this.master.getInventory().orElse(null);
            }
            return null;
        }
    }
}

