/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.emi;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.storagemod.gui.CraftingTerminalMenu;
import com.tom.storagemod.util.IAutoFillTerminal;
import com.tom.storagemod.util.StoredItemStack;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class EmiTransferHandler
implements StandardRecipeHandler<CraftingTerminalMenu> {
    public List<Slot> getInputSources(CraftingTerminalMenu handler) {
        return Collections.emptyList();
    }

    public List<Slot> getCraftingSlots(CraftingTerminalMenu handler) {
        return Collections.emptyList();
    }

    public EmiPlayerInventory getInventory(AbstractContainerScreen<CraftingTerminalMenu> screen) {
        ArrayList stacks = new ArrayList();
        ((CraftingTerminalMenu)screen.m_6262_()).f_38839_.subList(1, ((CraftingTerminalMenu)screen.m_6262_()).f_38839_.size()).stream().map(Slot::m_7993_).map(EmiStack::of).forEach(stacks::add);
        ((CraftingTerminalMenu)screen.m_6262_()).getStoredItems().forEach(s -> stacks.add(EmiStack.of((ItemStack)s.getStack(), (long)s.getQuantity())));
        return new EmiPlayerInventory(stacks);
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return recipe.getCategory() == VanillaEmiRecipeCategories.CRAFTING && recipe.supportsRecipeTree();
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<CraftingTerminalMenu> context) {
        AbstractContainerScreen screen = context.getScreen();
        EmiTransferHandler.handleRecipe(recipe, (AbstractContainerScreen<CraftingTerminalMenu>)screen, false);
        Minecraft.m_91087_().m_91152_((Screen)screen);
        return true;
    }

    public void render(EmiRecipe recipe, EmiCraftContext<CraftingTerminalMenu> context, List<Widget> widgets, GuiGraphics matrices) {
        RenderSystem.enableDepthTest();
        List<Integer> missing = EmiTransferHandler.handleRecipe(recipe, (AbstractContainerScreen<CraftingTerminalMenu>)context.getScreen(), true);
        int i = 0;
        for (Widget w : widgets) {
            if (!(w instanceof SlotWidget)) continue;
            SlotWidget sw = (SlotWidget)w;
            int j = i++;
            EmiIngredient stack = sw.getStack();
            Bounds bounds = sw.getBounds();
            if (sw.getRecipe() != null || stack.isEmpty() || !missing.contains(j)) continue;
            matrices.m_280509_(bounds.x(), bounds.y(), bounds.x() + bounds.width(), bounds.y() + bounds.height(), 0x44FF0000);
        }
    }

    private static List<Integer> handleRecipe(EmiRecipe recipe, AbstractContainerScreen<CraftingTerminalMenu> screen, boolean simulate) {
        IAutoFillTerminal term = (IAutoFillTerminal)screen.m_6262_();
        ItemStack[][] stacks = (ItemStack[][])recipe.getInputs().stream().map(i -> (ItemStack[])i.getEmiStacks().stream().map(EmiStack::getItemStack).filter(s -> !s.m_41619_()).toArray(ItemStack[]::new)).toArray(x$0 -> new ItemStack[x$0][]);
        int width = recipe.getDisplayWidth();
        ArrayList<Integer> missing = new ArrayList<Integer>();
        HashSet<StoredItemStack> stored = new HashSet<StoredItemStack>(term.getStoredItems());
        int i2 = 0;
        for (ItemStack[] list : stacks) {
            if (list.length > 0) {
                boolean found = false;
                for (ItemStack stack : list) {
                    if (stack == null || Minecraft.m_91087_().f_91074_.m_150109_().m_36030_(stack) == -1) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    for (ItemStack stack : list) {
                        StoredItemStack s = new StoredItemStack(stack);
                        if (!stored.contains(s)) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    missing.add(width == 1 ? i2 * 3 : (width == 2 ? i2 % 2 + i2 / 2 * 3 : i2));
                }
            }
            ++i2;
        }
        if (!simulate) {
            CompoundTag compound = new CompoundTag();
            ListTag list = new ListTag();
            for (int i3 = 0; i3 < stacks.length; ++i3) {
                if (stacks[i3] == null) continue;
                CompoundTag CompoundTag2 = new CompoundTag();
                CompoundTag2.m_128344_("s", (byte)i3);
                int k = 0;
                for (int j = 0; j < stacks[i3].length && k < 9; ++j) {
                    StoredItemStack s;
                    if (stacks[i3][j] == null || stacks[i3][j].m_41619_() || !stored.contains(s = new StoredItemStack(stacks[i3][j])) && Minecraft.m_91087_().f_91074_.m_150109_().m_36030_(stacks[i3][j]) == -1) continue;
                    CompoundTag tag = new CompoundTag();
                    stacks[i3][j].m_41739_(tag);
                    CompoundTag2.m_128365_("i" + k++, (Tag)tag);
                }
                CompoundTag2.m_128344_("l", (byte)Math.min(9, k));
                list.add((Object)CompoundTag2);
            }
            compound.m_128365_("i", (Tag)list);
            term.sendMessage(compound);
        }
        return missing;
    }
}

