/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.specials.special;

import com.probejs.ProbeJS;
import com.probejs.docs.formatter.formatter.IFormatter;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.java.type.InfoTypeResolver;
import com.probejs.jdoc.java.type.TypeInfoClass;
import com.probejs.jdoc.java.type.TypeInfoParameterized;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeComponentFactory;
import dev.latvian.mods.kubejs.recipe.schema.RecipeComponentFactoryRegistryEvent;
import dev.latvian.mods.kubejs.util.KubeJSPlugins;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class FormatterComponents
implements IFormatter {
    private static final Map<String, RecipeComponentFactory> components = new HashMap<String, RecipeComponentFactory>();

    private IFormatter getComponentType(RecipeComponentFactory factory) {
        if (factory instanceof RecipeComponentFactory.Simple) {
            RecipeComponentFactory.Simple simple = (RecipeComponentFactory.Simple)factory;
            return Serde.getTypeFormatter(Serde.deserializeFromJavaType(InfoTypeResolver.resolveType(simple.component().getClass())));
        }
        return Serde.getTypeFormatter(Serde.deserializeFromJavaType(new TypeInfoParameterized(new TypeInfoClass(RecipeComponent.class), List.of(new TypeInfoClass(Object.class)))));
    }

    private String getComponentType(String id, RecipeComponentFactory factory) {
        String type = this.getComponentType(factory).formatFirst();
        return "%s: (%s) => %s".formatted(ProbeJS.GSON.toJson((Object)id), factory instanceof RecipeComponentFactory.Simple ? "" : "...args", type);
    }

    @Override
    public List<String> format(Integer indent, Integer stepIndent) {
        String formatted = "%sclass RecipeComponentMap{\n%sget<T extends keyof RecipeComponents>(id: T): RecipeComponents[T]\n}\n%stype RecipeComponents = {\n%s\n}".formatted(" ".repeat(indent), " ".repeat(indent + stepIndent), " ".repeat(indent), components.entrySet().stream().map(e -> this.getComponentType((String)e.getKey(), (RecipeComponentFactory)e.getValue())).collect(Collectors.joining(",\n")));
        return List.of(formatted);
    }

    public static Set<Class<?>> loadComponentsClasses() {
        if (components.isEmpty()) {
            KubeJSPlugins.forEachPlugin((Object)new RecipeComponentFactoryRegistryEvent(components), KubeJSPlugin::registerRecipeComponents);
        }
        return Set.copyOf(components.values().stream().filter(factory -> factory instanceof RecipeComponentFactory.Simple).map(factory -> ((RecipeComponentFactory.Simple)factory).component().getClass()).collect(Collectors.toSet()));
    }
}

