/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.docs.formatter.formatter.jdoc;

import com.probejs.docs.formatter.formatter.IFormatter;
import com.probejs.docs.formatter.formatter.jdoc.DocumentFormatter;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.document.DocumentClass;
import com.probejs.jdoc.document.DocumentMethod;
import com.probejs.jdoc.property.PropertyParam;
import com.probejs.jdoc.property.PropertyType;
import com.probejs.util.Util;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class FormatterMethod
extends DocumentFormatter<DocumentMethod> {
    private final DocumentClass classDocument;
    private boolean functionalInterface = false;

    public FormatterMethod(DocumentMethod document, DocumentClass declaringClass) {
        super(document);
        this.classDocument = declaringClass;
    }

    public void setFunctionalInterface(boolean functionalInterface) {
        this.functionalInterface = functionalInterface;
    }

    private boolean isReturningThis() {
        if (((DocumentMethod)this.document).isStatic()) {
            return false;
        }
        PropertyType<?> returningType = ((DocumentMethod)this.document).getReturns();
        if (returningType instanceof PropertyType.Clazz) {
            PropertyType.Clazz clazz = (PropertyType.Clazz)returningType;
            return this.classDocument.getName().equals(clazz.getName());
        }
        if (returningType instanceof PropertyType.Parameterized) {
            PropertyType.Parameterized parameterized = (PropertyType.Parameterized)returningType;
            if (!parameterized.getBase().equals(new PropertyType.Clazz(this.classDocument.getName()))) {
                return false;
            }
            List<PropertyType<?>> paramsReturn = parameterized.getParams();
            List<PropertyType<?>> paramsClazz = this.classDocument.getGenerics();
            if (parameterized.getParams().size() != this.classDocument.getGenerics().size()) {
                return false;
            }
            for (int i = 0; i < parameterized.getParams().size(); ++i) {
                if (paramsReturn.get(i).equals(paramsClazz.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public List<String> formatDocument(Integer indent, Integer stepIndent) {
        return List.of(Util.indent(indent) + "%s%s%s%s%s;".formatted(((DocumentMethod)this.document).isStatic() ? "static " : "", ((DocumentMethod)this.document).isAbstract() ? "abstract " : "", Util.getSafeName(((DocumentMethod)this.document).getName()), ((DocumentMethod)this.document).getVariables().isEmpty() ? "" : "<%s>".formatted(((DocumentMethod)this.document).getVariables().stream().map(Serde::getTypeFormatter).map(IFormatter::formatMethodVariable).collect(Collectors.joining(", "))), this.formatMethodParts(false, false)));
    }

    public String formatMethodParts(boolean formattingFunctionalInterface, boolean isAssign) {
        return "(%s)%s %s".formatted(((DocumentMethod)this.document).getParams().stream().map(FormatterParam::new).map(formatterParam -> formatterParam.underscored(!formattingFunctionalInterface)).map(IFormatter::formatParamVariable).collect(Collectors.joining(", ")), isAssign ? "=>" : ":", this.isReturningThis() ? "this" : Serde.getTypeFormatter(((DocumentMethod)this.document).getReturns()).underscored(formattingFunctionalInterface).formatParamVariable());
    }

    public Optional<FormatterBean> getBeanFormatter() {
        String name = ((DocumentMethod)this.document).getName();
        if (name.length() < 4 && !name.startsWith("is")) {
            return Optional.empty();
        }
        if (name.equals("is")) {
            return Optional.empty();
        }
        FormatterBean bean = null;
        if (name.startsWith("get") && ((DocumentMethod)this.document).getParams().isEmpty() && !Character.isDigit(name.charAt(3))) {
            bean = new FormatterObjectGetter((DocumentMethod)this.document);
        }
        if (name.startsWith("set") && ((DocumentMethod)this.document).getParams().size() == 1 && !Character.isDigit(name.charAt(3))) {
            bean = new FormatterObjectSetter((DocumentMethod)this.document);
        }
        if (name.startsWith("is") && ((DocumentMethod)this.document).getParams().isEmpty() && (((DocumentMethod)this.document).getReturns().getTypeName().equals("boolean") || ((DocumentMethod)this.document).getReturns().getTypeName().equals("java.lang.Boolean")) && !Character.isDigit(name.charAt(2))) {
            bean = new FormatterIsGetter((DocumentMethod)this.document);
        }
        return Optional.ofNullable(bean);
    }

    public static class FormatterObjectGetter
    extends FormatterBean {
        public FormatterObjectGetter(DocumentMethod document) {
            super(document);
        }

        @Override
        protected List<String> formatDocument(Integer indent, Integer stepIndent) {
            return List.of(Util.indent(indent) + "get %s(): %s".formatted(Util.getSafeName(this.getBeanName()), Serde.getTypeFormatter(((DocumentMethod)this.document).getReturns()).formatParamVariable()));
        }

        @Override
        protected String getBeanName() {
            return FormatterObjectGetter.getBeanPropertyName(((DocumentMethod)this.document).getName().substring(3));
        }
    }

    public static class FormatterObjectSetter
    extends FormatterBean {
        public FormatterObjectSetter(DocumentMethod document) {
            super(document);
        }

        @Override
        protected List<String> formatDocument(Integer indent, Integer stepIndent) {
            return List.of(Util.indent(indent) + "set %s(%s)".formatted(Util.getSafeName(this.getBeanName()), new FormatterParam(((DocumentMethod)this.document).getParams().get(0)).underscored().formatFirst()));
        }

        @Override
        protected String getBeanName() {
            return FormatterObjectSetter.getBeanPropertyName(((DocumentMethod)this.document).getName().substring(3));
        }
    }

    public static class FormatterIsGetter
    extends FormatterObjectGetter {
        public FormatterIsGetter(DocumentMethod document) {
            super(document);
        }

        @Override
        protected String getBeanName() {
            return FormatterIsGetter.getBeanPropertyName(((DocumentMethod)this.document).getName().substring(2));
        }
    }

    public static class FormatterParam
    extends DocumentFormatter<PropertyParam> {
        private boolean underscored = false;

        @Override
        public boolean canHide() {
            return false;
        }

        @Override
        public boolean hasComment() {
            return false;
        }

        public FormatterParam(PropertyParam document) {
            super(document);
        }

        @Override
        public List<String> formatDocument(Integer indent, Integer stepIndent) {
            return List.of((((PropertyParam)this.document).isVarArg() ? "..." : "") + "%s: %s".formatted(Util.isNameSafe(((PropertyParam)this.document).getName()) ? ((PropertyParam)this.document).getName() : ((PropertyParam)this.document).getName() + "_", Serde.getTypeFormatter(((PropertyParam)this.document).getType()).underscored(this.underscored).formatParamVariable()));
        }

        public FormatterParam underscored(boolean flag) {
            this.underscored = flag;
            return this;
        }

        public FormatterParam underscored() {
            return this.underscored(true);
        }
    }

    public static abstract class FormatterBean
    extends DocumentFormatter<DocumentMethod> {
        public FormatterBean(DocumentMethod document) {
            super(document);
        }

        public static String getBeanPropertyName(String text) {
            Object beanPropertyName = text;
            char ch0 = text.charAt(0);
            if (Character.isUpperCase(ch0)) {
                if (text.length() == 1) {
                    beanPropertyName = text.toLowerCase();
                } else {
                    char ch1 = text.charAt(1);
                    if (!Character.isUpperCase(ch1)) {
                        beanPropertyName = Character.toLowerCase(ch0) + text.substring(1);
                    }
                }
            }
            return beanPropertyName;
        }

        protected abstract String getBeanName();
    }
}

