/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats.common;

import fonnymunkey.simplehats.SimpleHats;
import fonnymunkey.simplehats.common.entity.HatDisplay;
import fonnymunkey.simplehats.common.init.HatJson;
import fonnymunkey.simplehats.common.init.ModRegistry;
import fonnymunkey.simplehats.common.item.HatItem;
import fonnymunkey.simplehats.common.item.HatItemDyeable;
import fonnymunkey.simplehats.util.HatEntry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.Level;

public class EventHandler {

    @Mod.EventBusSubscriber(modid="simplehats", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class EventHandlerMod {
        @SubscribeEvent
        public static void entityAttributeCreation(EntityAttributeCreationEvent event) {
            event.put((EntityType)ModRegistry.HATDISPLAYENTITY.get(), HatDisplay.createAttributes().m_22265_());
        }

        @SubscribeEvent
        public static void registerHats(RegisterEvent event) {
            if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.ITEMS)) {
                for (HatEntry entry : HatJson.getHatList()) {
                    HatItem hat = entry.getHatDyeSettings().getUseDye() ? new HatItemDyeable(entry) : new HatItem(entry);
                    event.register(ForgeRegistries.Keys.ITEMS, new ResourceLocation("simplehats", entry.getHatName()), () -> hat);
                    ModRegistry.hatList.add(hat);
                }
                SimpleHats.logger.log(Level.INFO, "Generated " + ModRegistry.hatList.size() + " hat items from hat entries.");
            }
        }

        @SubscribeEvent
        public static void populateCreativeTab(BuildCreativeModeTabContentsEvent event) {
            if (event.getTab() == ModRegistry.HAT_TAB.get()) {
                for (HatItem hat : ModRegistry.hatList) {
                    event.m_246326_((ItemLike)hat);
                }
            }
        }
    }
}

