/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot.action;

import com.almostreliable.lootjs.core.ILootAction;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;

public class LootItemFunctionWrapperAction
implements ILootAction {
    private final LootItemFunction lootItemFunction;

    public LootItemFunctionWrapperAction(LootItemFunction lootItemFunction) {
        this.lootItemFunction = lootItemFunction;
    }

    @Override
    public boolean applyLootHandler(LootContext context, List<ItemStack> loot) {
        loot.replaceAll(itemStack -> (ItemStack)this.lootItemFunction.apply(itemStack, (Object)context));
        return true;
    }

    public LootItemFunction getLootItemFunction() {
        return this.lootItemFunction;
    }

    public static class CompositeLootItemFunction
    implements LootItemFunction {
        private final List<LootItemFunction> lootItemFunctions;
        private final Predicate<ItemStack> filter;

        public CompositeLootItemFunction(List<LootItemFunction> lootItemFunctions, Predicate<ItemStack> filter) {
            this.lootItemFunctions = lootItemFunctions;
            this.filter = filter;
        }

        public LootItemFunctionType m_7162_() {
            return null;
        }

        public ItemStack apply(ItemStack itemStack, LootContext context) {
            if (!this.filter.test(itemStack)) {
                return itemStack;
            }
            itemStack = itemStack.m_41777_();
            for (LootItemFunction lootItemFunction : this.lootItemFunctions) {
                itemStack = (ItemStack)lootItemFunction.apply((Object)itemStack, (Object)context);
            }
            return itemStack;
        }
    }
}

