/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen.info;

import de.melanx.skyblockbuilder.client.SizeableCheckbox;
import de.melanx.skyblockbuilder.config.common.PermissionsConfig;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.client.screen.BaseScreen;
import de.melanx.skyguis.client.screen.base.LoadingResultHandler;
import de.melanx.skyguis.client.screen.edit.EditSpawnsScreen;
import de.melanx.skyguis.client.screen.edit.InvitablePlayersScreen;
import de.melanx.skyguis.client.screen.edit.TeamPlayersScreen;
import de.melanx.skyguis.client.screen.notification.InformationScreen;
import de.melanx.skyguis.client.screen.notification.YouSureScreen;
import de.melanx.skyguis.client.widget.BlinkingEditBox;
import de.melanx.skyguis.network.handler.EditSpawns;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.LoadingResult;
import de.melanx.skyguis.util.TextHelper;
import de.melanx.skyguis.util.ToggleButtons;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class TeamEditScreen
extends BaseScreen
implements LoadingResultHandler {
    private static final Component SPAWNS = ComponentBuilder.text("spawns", new Object[0]);
    private static final Component MEMBERS = ComponentBuilder.text("members", new Object[0]);
    private static final Component REQUESTS = ComponentBuilder.text("requests", new Object[0]);
    private static final Component INVALID = ComponentBuilder.text("invalid", new Object[0]);
    private static final Component ADD = ComponentBuilder.text("add", new Object[0]);
    private static final Component REMOVE = ComponentBuilder.text("remove", new Object[0]);
    private static final Component SHOW = ComponentBuilder.text("show", new Object[0]);
    private static final Component INVITE = ComponentBuilder.text("invite", new Object[0]);
    private static final Component ALLOW_VISITS = ComponentBuilder.text("allow_visits", new Object[0]);
    private static final Component ALLOW_REQUESTS = ComponentBuilder.text("allow_requests", new Object[0]);
    private static final MutableComponent VISIT_BASE = ComponentBuilder.button("allow_visits", new Object[0]).m_7220_((Component)Component.m_237113_((String)" "));
    private static final MutableComponent REQUEST_BASE = ComponentBuilder.button("allow_requests", new Object[0]).m_7220_((Component)Component.m_237113_((String)" "));
    private static final Component ALLOWED = ComponentBuilder.text("allowed", new Object[0]).m_130940_(ChatFormatting.GREEN);
    private static final Component DISALLOWED = ComponentBuilder.text("disallowed", new Object[0]).m_130940_(ChatFormatting.RED);
    private static final int LEFT_PADDING = 10;
    private static final int CHECKBOX_X = 10 + Math.max(TextHelper.stringLength((FormattedText)ALLOW_VISITS), TextHelper.stringLength((FormattedText)ALLOW_REQUESTS));
    private final Team team;
    private final BaseScreen prev;
    private final Random random;
    private BlinkingEditBox posBox;
    private Button addButton;
    private Button removeButton;
    private boolean posValid;

    public TeamEditScreen(Team team, BaseScreen prev) {
        super((Component)Component.m_237113_((String)team.getName()), 245, 220);
        this.team = team;
        this.prev = prev;
        this.random = new Random();
    }

    protected void m_7856_() {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)SHOW, button -> {
            for (TemplatesConfig.Spawn spawn : this.team.getPossibleSpawns()) {
                double posX = (double)spawn.pos().m_123341_() + 0.5;
                double posY = (double)spawn.pos().m_123342_() + 0.5;
                double posZ = (double)spawn.pos().m_123343_() + 0.5;
                for (int i = 0; i < 10; ++i) {
                    double offsetX = this.random.nextGaussian() * 0.1;
                    double offsetY = this.random.nextGaussian() * 0.1;
                    double offsetZ = this.random.nextGaussian() * 0.1;
                    double speedX = this.random.nextGaussian() * 10.0;
                    double speedY = this.random.nextGaussian() * 10.0;
                    double speedZ = this.random.nextGaussian() * 10.0;
                    this.f_96541_.f_91073_.m_6493_((ParticleOptions)ParticleTypes.f_123748_, false, posX + offsetX, posY + offsetY, posZ + offsetZ, speedX, speedY, speedZ);
                }
            }
            this.m_7379_();
        }).m_252987_(this.x(10), this.y(45), 70, 20).m_253136_());
        this.addButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)ADD, button -> {
            BlockPos pos = this.getPos();
            if (this.posValid && pos != null) {
                SkyGUIs.getNetwork().handleEditSpawns(EditSpawns.Type.ADD, pos, Direction.SOUTH);
                this.getLoadingCircle().setActive(true);
            }
        }).m_252987_(this.x(85), this.y(45), 70, 20).m_253136_());
        Vec3 pos = Minecraft.m_91087_().f_91074_.m_20182_();
        String posStr = (int)pos.f_82479_ + " " + (int)pos.f_82480_ + " " + (int)pos.f_82481_;
        this.posBox = new BlinkingEditBox(this.f_96547_, this.x(10), this.y(70), 145, 18, (Component)Component.m_237113_((String)posStr));
        this.posBox.m_94144_(posStr);
        this.posBox.m_94199_(Short.MAX_VALUE);
        this.m_142416_((GuiEventListener)this.posBox);
        this.removeButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)REMOVE, button -> Minecraft.m_91087_().m_91152_((Screen)new EditSpawnsScreen(this.team, this))).m_257505_(Tooltip.m_257550_((Component)BaseScreen.OPEN_NEW_SCREEN)).m_252987_(this.x(160), this.y(45), 70, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)SHOW, button -> Minecraft.m_91087_().m_91152_((Screen)new TeamPlayersScreen(this.team, this))).m_252987_(this.x(10), this.y(115), 90, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)INVITE, button -> Minecraft.m_91087_().m_91152_((Screen)new InvitablePlayersScreen(this.team, this))).m_252987_(this.x(105), this.y(115), 90, 20).m_253136_());
        this.m_142416_((GuiEventListener)new SizeableCheckbox(this.x(CHECKBOX_X + 5), this.y(147), 10, this.team.allowsVisits(), (Component)VISIT_BASE.m_6881_().m_7220_(this.team.allowsVisits() ? ALLOWED : DISALLOWED)){

            public void m_5691_() {
                super.m_5691_();
                ToggleButtons.toggleState(TeamEditScreen.this.team, (AbstractWidget)this, VISIT_BASE, ToggleButtons.Type.VISITS);
            }
        });
        this.m_142416_((GuiEventListener)new SizeableCheckbox(this.x(CHECKBOX_X + 5), this.y(162), 10, this.team.allowsJoinRequests(), (Component)REQUEST_BASE.m_6881_().m_7220_(this.team.allowsJoinRequests() ? ALLOWED : DISALLOWED)){

            public void m_5691_() {
                super.m_5691_();
                ToggleButtons.toggleState(TeamEditScreen.this.team, (AbstractWidget)this, REQUEST_BASE, ToggleButtons.Type.JOIN_REQUEST);
            }
        });
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)ComponentBuilder.button("leave_team", new Object[0]), button -> Minecraft.m_91087_().pushGuiLayer((Screen)new YouSureScreen((BaseScreen)this, List.of(ComponentBuilder.text("you_sure_leave0", new Object[0]), ComponentBuilder.text("you_sure_leave1", new Object[0])), () -> {
            SkyGUIs.getNetwork().leaveTeam((Player)Minecraft.m_91087_().f_91074_);
            this.getLoadingCircle().setActive(true);
        }))).m_252987_(this.x(CHECKBOX_X + 25), this.y(150), 90, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)PREV_SCREEN_COMPONENT, button -> Minecraft.m_91087_().m_91152_((Screen)this.prev)).m_252987_(this.x(10), this.y(this.ySize - 30), 226, 20).m_253136_());
        if (!PermissionsConfig.selfManage || !PermissionsConfig.Spawns.modifySpawns) {
            this.addButton.f_93623_ = false;
            this.removeButton.f_93623_ = false;
        }
    }

    @Override
    public void onLoadingResult(LoadingResult result) {
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.pushGuiLayer((Screen)new InformationScreen(result.reason(), TextHelper.stringLength((FormattedText)result.reason()) + 30, 100, () -> ((Minecraft)minecraft).popGuiLayer()));
    }

    @Override
    public void m_86600_() {
        this.posBox.m_94120_();
        this.updatePositionValidation();
        super.m_86600_();
    }

    @Override
    public void render_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.render_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTitle(guiGraphics);
        guiGraphics.m_280614_(this.f_96547_, SPAWNS, this.x(10), this.y(30), Color.DARK_GRAY.getRGB(), false);
        guiGraphics.m_280614_(this.f_96547_, MEMBERS, this.x(10), this.y(100), Color.DARK_GRAY.getRGB(), false);
        guiGraphics.m_280614_(this.f_96547_, ALLOW_VISITS, this.x(10), this.y(149), Color.DARK_GRAY.getRGB(), false);
        guiGraphics.m_280614_(this.f_96547_, ALLOW_REQUESTS, this.x(10), this.y(164), Color.DARK_GRAY.getRGB(), false);
        if (!this.posValid) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(1.3f, 1.3f, 1.3f);
            guiGraphics.drawString(this.f_96547_, INVALID.getString(), (float)((double)(this.x(191) - this.f_96547_.m_92852_((FormattedText)INVALID) / 2) / 1.3), (float)((double)this.y(74) / 1.3), Color.RED.getRGB(), false);
            guiGraphics.m_280168_().m_85849_();
        }
        if (this.addButton.m_274382_()) {
            this.posBox.blink();
        }
    }

    private void updatePositionValidation() {
        String posBoxValue = this.posBox.m_94155_();
        String[] args = posBoxValue.split(" ");
        boolean bl = this.posValid = args.length == 3 && Arrays.stream(args).allMatch(s -> {
            try {
                Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }) && Integer.parseInt(args[1]) >= Minecraft.m_91087_().f_91073_.m_141937_() && Integer.parseInt(args[1]) <= Minecraft.m_91087_().f_91073_.m_151558_();
        if (this.posValid) {
            this.posBox.setValid();
            if (PermissionsConfig.selfManage && PermissionsConfig.Spawns.modifySpawns) {
                this.addButton.f_93623_ = true;
                this.removeButton.f_93623_ = true;
            }
        } else {
            this.posBox.setInvalid();
            this.addButton.f_93623_ = false;
            this.removeButton.f_93623_ = false;
        }
    }

    @Nullable
    private BlockPos getPos() {
        if (this.posValid) {
            String value = this.posBox.m_94155_();
            String[] args = value.split(" ");
            int x = Integer.parseInt(args[0]);
            int y = Integer.parseInt(args[1]);
            int z = Integer.parseInt(args[2]);
            return new BlockPos(x, y, z);
        }
        return null;
    }
}

