/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.config;

import com.bisecthosting.mods.bhmenu.ModRoot;
import com.bisecthosting.mods.bhmenu.config.GlobalConfigs;
import com.bisecthosting.mods.bhmenu.config.components.text.TextConfigEditBox;
import com.bisecthosting.mods.bhmenu.config.components.toggle.TickBoxConfigComponent;
import com.bisecthosting.mods.bhmenu.config.lists.ModuleSelectionList;
import com.bisecthosting.mods.bhmenu.config.values.BooleanHolder;
import com.bisecthosting.mods.bhmenu.config.values.StringHolder;
import com.bisecthosting.mods.bhmenu.modules.IModule;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class PackConfigScreen
extends Screen {
    private static final Component MOD_TEXT = Component.m_237115_((String)"screen.config.mod");
    private static final Component CLOSE_TEXT = Component.m_237115_((String)"screen.config.close");
    private static final Component FEATURES_TEXT = Component.m_237115_((String)"screen.config.features");
    private static final Component PACK_ID_TEXT = Component.m_237115_((String)"config.pack_id");
    private static final Component PARTNER_ID_TEXT = Component.m_237115_((String)"config.partner_id");
    private static final Component PACK_EDIT_MODE_TEXT = Component.m_237115_((String)"config.pack_edit_mode");
    public static final float SPLIT = 0.3f;
    private Screen parent;
    private ModuleSelectionList moduleSelectionList;
    private TextConfigEditBox packIdEditBox;
    private TextConfigEditBox partnerIdEditBox;
    private TickBoxConfigComponent enableConfigScreenTickButton;
    public static boolean hasChanged;

    public PackConfigScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"screen.config.pack.title"));
        this.parent = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        int splitWidth = (int)((float)this.f_96543_ * 0.3f);
        this.moduleSelectionList = new ModuleSelectionList(this.f_96541_, this.f_96543_ - splitWidth, this.f_96544_, 45, this.f_96544_ - 8, 30);
        for (IModule module : ModRoot.get().modules.getAll()) {
            this.moduleSelectionList.addEntry(new ModuleSelectionList.PackEntry(module));
        }
        this.moduleSelectionList.m_93507_(splitWidth);
        this.m_142416_((GuiEventListener)this.moduleSelectionList);
        int boxWidth = 100;
        this.packIdEditBox = new TextConfigEditBox(new StringHolder(GlobalConfigs.packId), this.f_96547_, (splitWidth - boxWidth) / 2, 75, boxWidth, 20, PACK_ID_TEXT);
        this.m_142416_((GuiEventListener)this.packIdEditBox);
        this.partnerIdEditBox = new TextConfigEditBox(new StringHolder(GlobalConfigs.partnerId), this.f_96547_, (splitWidth - boxWidth) / 2, 125, boxWidth, 20, PARTNER_ID_TEXT);
        this.m_142416_((GuiEventListener)this.partnerIdEditBox);
        int buttonWidth = Math.min(splitWidth - 20, 160);
        this.enableConfigScreenTickButton = new TickBoxConfigComponent(new BooleanHolder(GlobalConfigs.packEditMode), splitWidth / 2 - 10, this.f_96544_ - 55, 20, 20);
        this.m_142416_((GuiEventListener)this.enableConfigScreenTickButton);
        Button closeButton = Button.m_253074_((Component)CLOSE_TEXT, btn -> this.m_7379_()).m_252794_((splitWidth - buttonWidth) / 2, this.f_96544_ - 28).m_252780_(buttonWidth).m_253136_();
        this.m_142416_((GuiEventListener)closeButton);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int splitWidth = (int)((float)this.f_96543_ * 0.3f);
        int buttonWidth = Math.min(splitWidth - 20, 160);
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        graphics.m_280653_(this.f_96547_, MOD_TEXT, this.f_96543_ / 2, 10, 0xFFFFFF);
        graphics.m_280653_(this.f_96547_, FEATURES_TEXT, (this.f_96543_ + splitWidth) / 2, 30, 0xFFFFFF);
        graphics.m_280653_(this.f_96547_, PACK_ID_TEXT, splitWidth / 2, 60, 0xFFFFFF);
        graphics.m_280653_(this.f_96547_, PARTNER_ID_TEXT, splitWidth / 2, 110, 0xFFFFFF);
        int n = splitWidth / 2;
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280653_(this.f_96547_, PACK_EDIT_MODE_TEXT, n, this.f_96544_ - 57 - 9, 0xFFFFFF);
    }

    public void m_7379_() {
        this.packIdEditBox.save();
        this.partnerIdEditBox.save();
        this.enableConfigScreenTickButton.save();
        this.moduleSelectionList.saveAll();
        if (hasChanged) {
            GlobalConfigs.reloadConfigs();
            hasChanged = false;
        }
        this.f_96541_.m_91152_(this.parent);
    }
}

