/*
 * Decompiled with CFR 0.152.
 */
package com.endreborn.content;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolActions;

public class UpgradableShovelItem
extends ShovelItem {
    private final int sharpness;
    private final int flexibility;

    public UpgradableShovelItem(Tier p_43114_, float p_43115_, float p_43116_, Item.Properties p_43117_, int sharpness, int flexibility) {
        super(p_43114_, p_43115_, p_43116_, p_43117_);
        this.sharpness = sharpness;
        this.flexibility = flexibility;
    }

    public Component m_7626_(ItemStack p_41458_) {
        return Component.m_237115_((String)"item.endreborn.endorium_shovel");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.relic").m_130940_(ChatFormatting.GRAY));
        if (this.sharpness > 0) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.shovel_sharpness").m_130940_(ChatFormatting.DARK_GRAY));
        } else if (this.flexibility > 0) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uni_flexibility").m_130940_(ChatFormatting.DARK_GRAY));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uni_flexibility_n").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public boolean m_7579_(ItemStack p_40994_, LivingEntity p_40995_, LivingEntity p_40996_) {
        p_40994_.m_41622_(2 + this.flexibility, p_40996_, p_41007_ -> p_41007_.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public InteractionResult m_6225_(UseOnContext p_43119_) {
        Level level = p_43119_.m_43725_();
        BlockPos blockpos = p_43119_.m_8083_();
        BlockState blockstate = level.m_8055_(blockpos);
        if (p_43119_.m_43719_() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        Player player = p_43119_.m_43723_();
        BlockState blockstate1 = blockstate.getToolModifiedState(p_43119_, ToolActions.SHOVEL_FLATTEN, false);
        BlockState blockstate2 = null;
        if (blockstate1 != null && level.m_46859_(blockpos.m_7494_())) {
            level.m_5594_(player, blockpos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
            blockstate2 = blockstate1;
        } else if (blockstate.m_60734_() instanceof CampfireBlock && ((Boolean)blockstate.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
            if (!level.m_5776_()) {
                level.m_5898_((Player)null, 1009, blockpos, 0);
            }
            CampfireBlock.m_152749_((Entity)p_43119_.m_43723_(), (LevelAccessor)level, (BlockPos)blockpos, (BlockState)blockstate);
            blockstate2 = (BlockState)blockstate.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false));
        }
        if (blockstate2 != null) {
            if (!level.f_46443_) {
                level.m_7731_(blockpos, blockstate2, 11);
                level.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockstate2));
                if (player != null) {
                    p_43119_.m_43722_().m_41622_(1 - this.sharpness, (LivingEntity)player, p_43122_ -> p_43122_.m_21190_(p_43119_.m_43724_()));
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }
}

