/*
 * Decompiled with CFR 0.152.
 */
package com.endreborn.content;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolActions;

public class UpgradableAxeItem
extends AxeItem {
    private final int sharpness;
    private final int flexibility;

    public UpgradableAxeItem(Tier p_40521_, float p_40522_, float p_40523_, Item.Properties p_40524_, int sharpness, int flexibility) {
        super(p_40521_, p_40522_, p_40523_, p_40524_);
        this.sharpness = sharpness;
        this.flexibility = flexibility;
    }

    public Component m_7626_(ItemStack p_41458_) {
        return Component.m_237115_((String)"item.endreborn.endorium_axe");
    }

    public InteractionResult m_6225_(UseOnContext p_40529_) {
        Level level = p_40529_.m_43725_();
        BlockPos blockpos = p_40529_.m_8083_();
        Player player = p_40529_.m_43723_();
        BlockState blockstate = level.m_8055_(blockpos);
        Optional<BlockState> optional = Optional.ofNullable(blockstate.getToolModifiedState(p_40529_, ToolActions.AXE_STRIP, false));
        Optional optional1 = optional.isPresent() ? Optional.empty() : Optional.ofNullable(blockstate.getToolModifiedState(p_40529_, ToolActions.AXE_SCRAPE, false));
        Optional optional2 = optional.isPresent() || optional1.isPresent() ? Optional.empty() : Optional.ofNullable(blockstate.getToolModifiedState(p_40529_, ToolActions.AXE_WAX_OFF, false));
        ItemStack itemstack = p_40529_.m_43722_();
        Optional<Object> optional3 = Optional.empty();
        if (optional.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            optional3 = optional;
        } else if (optional1.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3005, blockpos, 0);
            optional3 = optional1;
        } else if (optional2.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3004, blockpos, 0);
            optional3 = optional2;
        }
        if (optional3.isPresent()) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockpos, itemstack);
            }
            level.m_7731_(blockpos, (BlockState)optional3.get(), 11);
            level.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)((BlockState)optional3.get())));
            if (player != null) {
                itemstack.m_41622_(1 - this.sharpness, (LivingEntity)player, p_150686_ -> p_150686_.m_21190_(p_40529_.m_43724_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.relic").m_130940_(ChatFormatting.GRAY));
        if (this.sharpness > 0) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.axe_sharpness").m_130940_(ChatFormatting.DARK_GRAY));
        } else if (this.flexibility > 0) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uni_flexibility").m_130940_(ChatFormatting.DARK_GRAY));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uni_flexibility_n").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public boolean m_7579_(ItemStack p_40994_, LivingEntity p_40995_, LivingEntity p_40996_) {
        p_40994_.m_41622_(2 + this.flexibility, p_40996_, p_41007_ -> p_41007_.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }
}

