/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.requester;

import appeng.api.config.FuzzyMode;
import appeng.api.networking.IStackWatcher;
import appeng.api.networking.storage.IStorageWatcherNode;
import appeng.api.stacks.AEKey;
import com.almostreliable.merequester.platform.Platform;
import com.almostreliable.merequester.platform.TagSerializable;
import com.almostreliable.merequester.requester.RequesterBlockEntity;
import com.almostreliable.merequester.requester.Requests;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class StorageManager
implements IStorageWatcherNode,
TagSerializable<CompoundTag> {
    private final RequesterBlockEntity host;
    private final Storage[] storages;
    @Nullable
    private IStackWatcher stackWatcher;

    StorageManager(RequesterBlockEntity host) {
        this.host = host;
        this.storages = new Storage[Platform.getRequestLimit()];
    }

    public Storage get(int slot) {
        if (this.storages[slot] == null) {
            this.storages[slot] = new Storage();
        }
        return this.storages[slot];
    }

    public void updateWatcher(IStackWatcher newWatcher) {
        this.stackWatcher = newWatcher;
        this.resetWatcher();
    }

    public void onStackChange(AEKey key, long amount) {
        for (int i = 0; i < this.storages.length; ++i) {
            if (!key.equals(this.host.getRequests().getKey(i))) continue;
            this.get((int)i).knownAmount = amount;
            this.get((int)i).pendingAmount = 0L;
        }
    }

    public long computeAmountToCraft(int slot) {
        Requests requests = this.host.getRequests();
        if (requests.getKey(slot) == null) {
            return 0L;
        }
        long storedAmount = this.get((int)slot).knownAmount + this.get((int)slot).pendingAmount;
        if (storedAmount < requests.getAmount(slot)) {
            return requests.get(slot).getBatch();
        }
        return 0L;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < this.storages.length; ++i) {
            tag.m_128365_(String.valueOf(i), (Tag)this.get(i).serialize());
        }
        return tag;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        for (int i = 0; i < this.storages.length; ++i) {
            this.get(i).deserialize(tag.m_128469_(String.valueOf(i)));
        }
    }

    void addDrops(List<ItemStack> drops) {
        for (Storage storage : this.storages) {
            if (storage == null || storage.key == null) continue;
            storage.key.addDrops(storage.getBufferAmount() + storage.pendingAmount, drops, this.host.m_58904_(), this.host.m_58899_());
        }
    }

    void clear(int slot) {
        this.get((int)slot).knownAmount = -1L;
        this.computeKnownAmount(slot);
        this.resetWatcher();
    }

    private void populateWatcher(IStackWatcher watcher) {
        for (int i = 0; i < this.storages.length; ++i) {
            if (this.host.getRequests().getKey(i) == null) continue;
            watcher.add(this.host.getRequests().getKey(i));
        }
    }

    private void resetWatcher() {
        if (this.stackWatcher != null) {
            this.stackWatcher.reset();
            this.populateWatcher(this.stackWatcher);
        }
    }

    private void computeKnownAmount(int slot) {
        AEKey key = this.host.getRequests().getKey(slot);
        if (key == null) {
            return;
        }
        this.get((int)slot).knownAmount = this.host.getMainNodeGrid().getStorageService().getInventory().getAvailableStacks().get(key);
    }

    public static class Storage
    implements TagSerializable<CompoundTag> {
        private static final String KEY_ID = "key";
        private static final String BUFFER_AMOUNT_ID = "buffer_amount";
        private static final String PENDING_AMOUNT_ID = "pending_amount";
        private static final String KNOWN_AMOUNT_ID = "known_amount";
        @Nullable
        private AEKey key;
        private long totalAmount;
        private long bufferAmount;
        private long pendingAmount;
        private long knownAmount = -1L;

        @Override
        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            if (this.key != null) {
                tag.m_128365_(KEY_ID, (Tag)this.key.toTagGeneric());
            }
            tag.m_128356_(BUFFER_AMOUNT_ID, this.bufferAmount);
            tag.m_128356_(PENDING_AMOUNT_ID, this.pendingAmount);
            tag.m_128356_(KNOWN_AMOUNT_ID, this.knownAmount);
            return tag;
        }

        @Override
        public void deserialize(CompoundTag tag) {
            this.key = tag.m_128441_(KEY_ID) ? AEKey.fromTagGeneric((CompoundTag)tag.m_128469_(KEY_ID)) : null;
            this.bufferAmount = tag.m_128454_(BUFFER_AMOUNT_ID);
            this.pendingAmount = tag.m_128454_(PENDING_AMOUNT_ID);
            this.knownAmount = tag.m_128454_(KNOWN_AMOUNT_ID);
        }

        public boolean compute(long inserted) {
            this.pendingAmount += inserted;
            this.bufferAmount = this.getBufferAmount() - inserted;
            this.totalAmount -= inserted;
            if (this.bufferAmount == 0L) {
                this.key = null;
            }
            return this.bufferAmount > 0L || this.totalAmount > 0L;
        }

        void update(AEKey key, long bufferAmount) {
            if (this.key != null && !key.fuzzyEquals(this.key, FuzzyMode.PERCENT_99)) {
                throw new IllegalArgumentException("storage key mismatch");
            }
            this.key = key;
            this.bufferAmount += bufferAmount;
        }

        public void setTotalAmount(long totalAmount) {
            this.totalAmount = totalAmount;
        }

        @Nullable
        public AEKey getKey() {
            return this.key;
        }

        public long getBufferAmount() {
            return this.key == null ? 0L : this.bufferAmount;
        }

        public long getKnownAmount() {
            return this.knownAmount;
        }
    }
}

