/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CornerDir;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.DiagCornerDir;
import xfacthd.framedblocks.common.data.skippreds.slab.CheckeredCubeSegmentSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.MasonryCornerSegmentSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallInnerCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalHalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;

@CullTest(value={BlockType.FRAMED_CHECKERED_SLAB_SEGMENT})
public final class CheckeredSlabSegmentSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            boolean second = (Boolean)state.m_61143_((Property)PropertyHolder.SECOND);
            return switch (type) {
                case BlockType.FRAMED_CHECKERED_SLAB_SEGMENT -> CheckeredSlabSegmentSkipPredicate.testAgainstCheckeredSlabSegment(top, second, adjState, side);
                case BlockType.FRAMED_CHECKERED_CUBE_SEGMENT -> CheckeredSlabSegmentSkipPredicate.testAgainstCheckeredCubeSegment(top, second, adjState, side);
                case BlockType.FRAMED_SLAB_CORNER -> CheckeredSlabSegmentSkipPredicate.testAgainstSlabCorner(top, second, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> CheckeredSlabSegmentSkipPredicate.testAgainstSlabEdge(top, second, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> CheckeredSlabSegmentSkipPredicate.testAgainstVerticalStairs(top, second, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> CheckeredSlabSegmentSkipPredicate.testAgainstHalfStairs(top, second, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> CheckeredSlabSegmentSkipPredicate.testAgainstVerticalHalfStairs(top, second, adjState, side);
                case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W -> CheckeredSlabSegmentSkipPredicate.testAgainstSmallCornerSlopePanelWall(top, second, adjState, side);
                case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W -> CheckeredSlabSegmentSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(top, second, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W -> CheckeredSlabSegmentSkipPredicate.testAgainstExtendedCornerSlopePanelWall(top, second, adjState, side);
                case BlockType.FRAMED_MASONRY_CORNER_SEGMENT -> CheckeredSlabSegmentSkipPredicate.testAgainstMasonryCornerSegment(top, second, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CHECKERED_SLAB_SEGMENT})
    private static boolean testAgainstCheckeredSlabSegment(boolean top, boolean second, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjSecond = (Boolean)adjState.m_61143_((Property)PropertyHolder.SECOND);
        return CheckeredSlabSegmentSkipPredicate.getDiagCornerDir(top, second, side).isEqualTo(CheckeredSlabSegmentSkipPredicate.getDiagCornerDir(adjTop, adjSecond, side.m_122424_())) || CheckeredSlabSegmentSkipPredicate.getCornerDir(top, second, side).isEqualTo(CheckeredSlabSegmentSkipPredicate.getCornerDir(adjTop, adjSecond, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CHECKERED_CUBE_SEGMENT})
    private static boolean testAgainstCheckeredCubeSegment(boolean top, boolean second, BlockState adjState, Direction side) {
        boolean adjSecond = (Boolean)adjState.m_61143_((Property)PropertyHolder.SECOND);
        return CheckeredSlabSegmentSkipPredicate.getDiagCornerDir(top, second, side).isEqualTo(CheckeredCubeSegmentSkipPredicate.getDiagCornerDir(adjSecond, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB_CORNER})
    private static boolean testAgainstSlabCorner(boolean top, boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return CheckeredSlabSegmentSkipPredicate.getCornerDir(top, second, side).isEqualTo(SlabCornerSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstSlabEdge(boolean top, boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return CheckeredSlabSegmentSkipPredicate.getCornerDir(top, second, side).isEqualTo(SlabEdgeSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalStairs(boolean top, boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        return CheckeredSlabSegmentSkipPredicate.getCornerDir(top, second, side).isEqualTo(VerticalStairsSkipPredicate.getCornerDir(adjDir, adjType, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_STAIRS})
    private static boolean testAgainstHalfStairs(boolean top, boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        return CheckeredSlabSegmentSkipPredicate.getCornerDir(top, second, side).isEqualTo(HalfStairsSkipPredicate.getCornerDir(adjDir, adjTop, adjRight, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
    private static boolean testAgainstVerticalHalfStairs(boolean top, boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return CheckeredSlabSegmentSkipPredicate.getCornerDir(top, second, side).isEqualTo(VerticalHalfStairsSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallCornerSlopePanelWall(boolean top, boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return CheckeredSlabSegmentSkipPredicate.getCornerDir(top, second, side).isEqualTo(SmallCornerSlopePanelWallSkipPredicate.getCornerDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallInnerCornerSlopePanelWall(boolean top, boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return CheckeredSlabSegmentSkipPredicate.getCornerDir(top, second, side).isEqualTo(SmallInnerCornerSlopePanelWallSkipPredicate.getCornerDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedCornerSlopePanelWall(boolean top, boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return CheckeredSlabSegmentSkipPredicate.getCornerDir(top, second, side).isEqualTo(ExtendedCornerSlopePanelWallSkipPredicate.getCornerDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_MASONRY_CORNER_SEGMENT})
    private static boolean testAgainstMasonryCornerSegment(boolean top, boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        return CheckeredSlabSegmentSkipPredicate.getCornerDir(top, second, side).isEqualTo(MasonryCornerSegmentSkipPredicate.getCornerDir(adjDir, side.m_122424_()));
    }

    public static DiagCornerDir getDiagCornerDir(boolean top, boolean second, Direction side) {
        if (top && side == Direction.UP) {
            return second ? DiagCornerDir.UP_NW_SE : DiagCornerDir.UP_NE_SW;
        }
        if (!top && side == Direction.DOWN) {
            return second ? DiagCornerDir.DOWN_NE_SW : DiagCornerDir.DOWN_NW_SE;
        }
        return DiagCornerDir.NULL;
    }

    public static CornerDir getCornerDir(boolean top, boolean second, Direction side) {
        if (!Utils.isY(side)) {
            boolean x = Utils.isX(side);
            return CornerDir.fromDirections(side, top ? Direction.UP : Direction.DOWN, second == x ? side.m_122428_() : side.m_122427_());
        }
        return CornerDir.NULL;
    }
}

