/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.DiagCornerDir;
import xfacthd.framedblocks.common.data.skippreds.slab.CheckeredPanelSegmentSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.CheckeredSlabSegmentSkipPredicate;

@CullTest(value={BlockType.FRAMED_CHECKERED_CUBE_SEGMENT})
public final class CheckeredCubeSegmentSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            boolean second = (Boolean)state.m_61143_((Property)PropertyHolder.SECOND);
            return switch (type) {
                case BlockType.FRAMED_CHECKERED_CUBE_SEGMENT -> CheckeredCubeSegmentSkipPredicate.testAgainstCheckeredCubeSegment(second, adjState, side);
                case BlockType.FRAMED_CHECKERED_SLAB_SEGMENT -> CheckeredCubeSegmentSkipPredicate.testAgainstCheckeredSlabSegment(second, adjState, side);
                case BlockType.FRAMED_CHECKERED_PANEL_SEGMENT -> CheckeredCubeSegmentSkipPredicate.testAgainstCheckeredPanelSegment(second, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CHECKERED_CUBE_SEGMENT})
    private static boolean testAgainstCheckeredCubeSegment(boolean second, BlockState adjState, Direction side) {
        boolean adjSecond = (Boolean)adjState.m_61143_((Property)PropertyHolder.SECOND);
        return CheckeredCubeSegmentSkipPredicate.getDiagCornerDir(second, side).isEqualTo(CheckeredCubeSegmentSkipPredicate.getDiagCornerDir(adjSecond, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CHECKERED_SLAB_SEGMENT})
    private static boolean testAgainstCheckeredSlabSegment(boolean second, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjSecond = (Boolean)adjState.m_61143_((Property)PropertyHolder.SECOND);
        return CheckeredCubeSegmentSkipPredicate.getDiagCornerDir(second, side).isEqualTo(CheckeredSlabSegmentSkipPredicate.getDiagCornerDir(adjTop, adjSecond, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CHECKERED_PANEL_SEGMENT})
    private static boolean testAgainstCheckeredPanelSegment(boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjSecond = (Boolean)adjState.m_61143_((Property)PropertyHolder.SECOND);
        return CheckeredCubeSegmentSkipPredicate.getDiagCornerDir(second, side).isEqualTo(CheckeredPanelSegmentSkipPredicate.getDiagCornerDir(adjDir, adjSecond, side.m_122424_()));
    }

    public static DiagCornerDir getDiagCornerDir(boolean second, Direction side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> {
                if (second) {
                    yield DiagCornerDir.DOWN_NE_SW;
                }
                yield DiagCornerDir.DOWN_NW_SE;
            }
            case Direction.UP -> {
                if (second) {
                    yield DiagCornerDir.UP_NW_SE;
                }
                yield DiagCornerDir.UP_NE_SW;
            }
            case Direction.NORTH -> {
                if (second) {
                    yield DiagCornerDir.NORTH_UW_DE;
                }
                yield DiagCornerDir.NORTH_UE_DW;
            }
            case Direction.SOUTH -> {
                if (second) {
                    yield DiagCornerDir.SOUTH_UE_DW;
                }
                yield DiagCornerDir.SOUTH_UW_DE;
            }
            case Direction.WEST -> {
                if (second) {
                    yield DiagCornerDir.WEST_UN_DS;
                }
                yield DiagCornerDir.WEST_US_DN;
            }
            case Direction.EAST -> second ? DiagCornerDir.EAST_US_DN : DiagCornerDir.EAST_UN_DS;
        };
    }
}

