/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopeslab;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedSlopeSlabBlock;
import xfacthd.framedblocks.common.block.slopeslab.SlopeSlabShape;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedFlatSlopeSlabCornerBlock
extends FramedBlock {
    public static final ShapeCache<SlopeSlabShape> SHAPES = ShapeCache.createEnum(SlopeSlabShape.class, map -> {
        VoxelShape shapeSlopeBottom = FramedSlopeSlabBlock.SHAPES.get(SlopeSlabShape.BOTTOM_BOTTOM_HALF);
        VoxelShape shapeSlopeTop = FramedSlopeSlabBlock.SHAPES.get(SlopeSlabShape.TOP_BOTTOM_HALF);
        VoxelShape shapeBottomBottomHalf = ShapeUtils.andUnoptimized(shapeSlopeBottom, ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, shapeSlopeBottom));
        map.put(SlopeSlabShape.BOTTOM_BOTTOM_HALF, shapeBottomBottomHalf);
        map.put(SlopeSlabShape.BOTTOM_TOP_HALF, shapeBottomBottomHalf.m_83216_(0.0, 0.5, 0.0));
        VoxelShape shapeTopBottomHalf = ShapeUtils.andUnoptimized(shapeSlopeTop, ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, shapeSlopeTop));
        map.put(SlopeSlabShape.TOP_BOTTOM_HALF, shapeTopBottomHalf);
        map.put(SlopeSlabShape.TOP_TOP_HALF, shapeTopBottomHalf.m_83216_(0.0, 0.5, 0.0));
    });
    public static final ShapeCache<SlopeSlabShape> INNER_SHAPES = ShapeCache.createEnum(SlopeSlabShape.class, map -> {
        VoxelShape shapeSlopeBottom = FramedSlopeSlabBlock.SHAPES.get(SlopeSlabShape.BOTTOM_BOTTOM_HALF);
        VoxelShape shapeSlopeTop = FramedSlopeSlabBlock.SHAPES.get(SlopeSlabShape.TOP_BOTTOM_HALF);
        VoxelShape shapeBottomBottomHalf = ShapeUtils.orUnoptimized(shapeSlopeBottom, ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, shapeSlopeBottom));
        map.put(SlopeSlabShape.BOTTOM_BOTTOM_HALF, shapeBottomBottomHalf);
        map.put(SlopeSlabShape.BOTTOM_TOP_HALF, shapeBottomBottomHalf.m_83216_(0.0, 0.5, 0.0));
        VoxelShape shapeTopBottomHalf = ShapeUtils.orUnoptimized(shapeSlopeTop, ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, shapeSlopeTop));
        map.put(SlopeSlabShape.TOP_BOTTOM_HALF, shapeTopBottomHalf);
        map.put(SlopeSlabShape.TOP_TOP_HALF, shapeTopBottomHalf.m_83216_(0.0, 0.5, 0.0));
    });

    public FramedFlatSlopeSlabCornerBlock(BlockType type) {
        super(type);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PropertyHolder.TOP_HALF, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, PropertyHolder.TOP_HALF, FramedProperties.SOLID, BlockStateProperties.f_61362_, FramedProperties.Y_SLOPE});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withHalfFacing()).withTop(PropertyHolder.TOP_HALF)).withCustom((state, modCtx) -> (BlockState)state.m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(ctx.m_43723_() != null && ctx.m_43723_().m_6144_())))).withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        Direction dir;
        Direction face = hit.m_82434_();
        if (face == (dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR)).m_122424_() || face == dir.m_122427_()) {
            if (this.getBlockType() == BlockType.FRAMED_FLAT_SLOPE_SLAB_CORNER) {
                face = Direction.UP;
            } else {
                double hor;
                Vec3 vec = Utils.fraction(hit.m_82450_());
                Direction perpDir = face == dir.m_122427_() ? dir : dir.m_122428_();
                double d = hor = Utils.isX(perpDir) ? vec.m_7096_() : vec.m_7094_();
                if (!Utils.isPositive(perpDir)) {
                    hor = 1.0 - hor;
                }
                double y = vec.m_7098_();
                if (((Boolean)state.m_61143_((Property)PropertyHolder.TOP_HALF)).booleanValue()) {
                    y -= 0.5;
                }
                if (((Boolean)state.m_61143_((Property)FramedProperties.TOP)).booleanValue()) {
                    y = 0.5 - y;
                }
                if (y * 2.0 >= hor) {
                    face = Direction.UP;
                }
            }
        }
        return this.rotate(state, face, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (Utils.isY(face)) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.m_61122_((Property)PropertyHolder.TOP_HALF);
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, mirror);
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int maskTop = 4;
        int maskTopHalf = 8;
        VoxelShape[] shapes = new VoxelShape[16];
        ShapeUtils.makeHorizontalRotations(SHAPES.get(SlopeSlabShape.BOTTOM_BOTTOM_HALF), Direction.NORTH, shapes, 0);
        ShapeUtils.makeHorizontalRotations(SHAPES.get(SlopeSlabShape.BOTTOM_TOP_HALF), Direction.NORTH, shapes, maskTopHalf);
        ShapeUtils.makeHorizontalRotations(SHAPES.get(SlopeSlabShape.TOP_BOTTOM_HALF), Direction.NORTH, shapes, maskTop);
        ShapeUtils.makeHorizontalRotations(SHAPES.get(SlopeSlabShape.TOP_TOP_HALF), Direction.NORTH, shapes, maskTop | maskTopHalf);
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            int top = (Boolean)state.m_61143_((Property)FramedProperties.TOP) != false ? maskTop : 0;
            int topHalf = (Boolean)state.m_61143_((Property)PropertyHolder.TOP_HALF) != false ? maskTopHalf : 0;
            int idx = dir.m_122416_() | top | topHalf;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateInnerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int maskTop = 4;
        int maskTopHalf = 8;
        VoxelShape[] shapes = new VoxelShape[16];
        ShapeUtils.makeHorizontalRotations(INNER_SHAPES.get(SlopeSlabShape.BOTTOM_BOTTOM_HALF), Direction.NORTH, shapes, 0);
        ShapeUtils.makeHorizontalRotations(INNER_SHAPES.get(SlopeSlabShape.BOTTOM_TOP_HALF), Direction.NORTH, shapes, maskTopHalf);
        ShapeUtils.makeHorizontalRotations(INNER_SHAPES.get(SlopeSlabShape.TOP_BOTTOM_HALF), Direction.NORTH, shapes, maskTop);
        ShapeUtils.makeHorizontalRotations(INNER_SHAPES.get(SlopeSlabShape.TOP_TOP_HALF), Direction.NORTH, shapes, maskTop | maskTopHalf);
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            int top = (Boolean)state.m_61143_((Property)FramedProperties.TOP) != false ? maskTop : 0;
            int topHalf = (Boolean)state.m_61143_((Property)PropertyHolder.TOP_HALF) != false ? maskTopHalf : 0;
            int idx = dir.m_122416_() | top | topHalf;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

