/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.ExtPlacementStateBuilder;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.slopepanel.SlopePanelShape;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedSlopePanelBlock
extends FramedBlock {
    public static final ShapeCache<SlopePanelShape> SHAPES = ShapeCache.create(map -> {
        VoxelShape shapeUp = ShapeUtils.orUnoptimized(FramedSlopePanelBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)8.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)0.5, (double)0.0, (double)16.0, (double)4.0, (double)7.75), FramedSlopePanelBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)6.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)4.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.0, (double)2.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)0.5));
        map.put(SlopePanelShape.UP_BACK, shapeUp);
        map.put(SlopePanelShape.UP_FRONT, shapeUp.m_83216_(0.0, 0.0, 0.5));
        VoxelShape shapeRight = ShapeUtils.orUnoptimized(FramedSlopePanelBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)8.0), FramedSlopePanelBlock.m_49796_((double)0.5, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)7.75), FramedSlopePanelBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)6.0), FramedSlopePanelBlock.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0), FramedSlopePanelBlock.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)2.0), FramedSlopePanelBlock.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.5));
        map.put(SlopePanelShape.RIGHT_BACK, shapeRight);
        map.put(SlopePanelShape.RIGHT_FRONT, shapeRight.m_83216_(0.0, 0.0, 0.5));
        VoxelShape shapeDown = ShapeUtils.orUnoptimized(FramedSlopePanelBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)8.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.5, (double)7.75), FramedSlopePanelBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)6.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)4.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)4.0, (double)2.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)0.5));
        map.put(SlopePanelShape.DOWN_BACK, shapeDown);
        map.put(SlopePanelShape.DOWN_FRONT, shapeDown.m_83216_(0.0, 0.0, 0.5));
        VoxelShape shapeLeft = ShapeUtils.orUnoptimized(FramedSlopePanelBlock.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), FramedSlopePanelBlock.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)7.75), FramedSlopePanelBlock.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)6.0), FramedSlopePanelBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)4.0), FramedSlopePanelBlock.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)2.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)0.5));
        map.put(SlopePanelShape.LEFT_BACK, shapeLeft);
        map.put(SlopePanelShape.LEFT_FRONT, shapeLeft.m_83216_(0.0, 0.0, 0.5));
    });

    public FramedSlopePanelBlock() {
        super(BlockType.FRAMED_SLOPE_PANEL);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)PropertyHolder.FRONT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, PropertyHolder.FRONT, FramedProperties.SOLID, BlockStateProperties.f_61362_, FramedProperties.Y_SLOPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return FramedSlopePanelBlock.getStateForPlacement(this, context);
    }

    public static BlockState getStateForPlacement(Block block, BlockPlaceContext context) {
        return ((ExtPlacementStateBuilder)((ExtPlacementStateBuilder)ExtPlacementStateBuilder.of(block, context).withHorizontalFacing()).withCrossOrSideRotation().withFront().withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        if (face.m_122434_() == dir.m_122434_() || face == rotation.withFacing(dir)) {
            return (BlockState)state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation.rotate(rot)));
        }
        if (Utils.isY(face)) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.m_61122_((Property)PropertyHolder.FRONT);
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction side = Direction.UP;
        if (state.m_61143_(PropertyHolder.ROTATION) == HorizontalRotation.UP) {
            side = Direction.DOWN;
        }
        return this.rotate(state, side, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return FramedSlopePanelBlock.mirrorPanel(state, mirror);
    }

    public static BlockState mirrorPanel(BlockState state, Mirror mirror) {
        BlockState newState = Utils.mirrorFaceBlock(state, mirror);
        HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        if (newState != state && !rot.isVertical()) {
            state = (BlockState)state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rot.getOpposite()));
        }
        return state;
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int maskFront = 16;
        VoxelShape[] shapes = new VoxelShape[32];
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape shape = SHAPES.get(SlopePanelShape.get(rot, false));
            VoxelShape shapeFront = SHAPES.get(SlopePanelShape.get(rot, true));
            ShapeUtils.makeHorizontalRotations(shape, Direction.NORTH, shapes, rot.ordinal() << 2);
            ShapeUtils.makeHorizontalRotations(shapeFront, Direction.NORTH, shapes, maskFront | rot.ordinal() << 2);
        }
        for (BlockState state : states) {
            HorizontalRotation rot;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            int front = (Boolean)state.m_61143_((Property)PropertyHolder.FRONT) != false ? maskFront : 0;
            int idx = dir.m_122416_() | rot.ordinal() << 2 | front;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

