/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slope;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedPyramidBlock
extends FramedBlock {
    public FramedPyramidBlock(BlockType type) {
        super(type);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP)).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_, FramedProperties.SOLID, BlockStateProperties.f_61362_, FramedProperties.Y_SLOPE});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withTargetFacing(true)).withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction side, Rotation rot) {
        return (BlockState)state.m_61122_((Property)BlockStateProperties.f_61372_);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction dir = rot.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_));
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)dir);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorFaceBlock(state, BlockStateProperties.f_61372_, mirror);
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        VoxelShape shapeUp = ShapeUtils.orUnoptimized(FramedPyramidBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), FramedPyramidBlock.m_49796_((double)0.5, (double)0.5, (double)0.5, (double)15.5, (double)4.0, (double)15.5), FramedPyramidBlock.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), FramedPyramidBlock.m_49796_((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), FramedPyramidBlock.m_49796_((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
        VoxelShape shapeDown = ShapeUtils.orUnoptimized(FramedPyramidBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedPyramidBlock.m_49796_((double)0.5, (double)12.0, (double)0.5, (double)15.5, (double)15.5, (double)15.5), FramedPyramidBlock.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), FramedPyramidBlock.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), FramedPyramidBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0));
        VoxelShape shapeNorth = ShapeUtils.orUnoptimized(FramedPyramidBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), FramedPyramidBlock.m_49796_((double)0.5, (double)0.5, (double)12.0, (double)15.5, (double)15.5, (double)15.5), FramedPyramidBlock.m_49796_((double)2.0, (double)2.0, (double)8.0, (double)14.0, (double)14.0, (double)12.0), FramedPyramidBlock.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)8.0), FramedPyramidBlock.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0));
        VoxelShape[] horShapes = ShapeUtils.makeHorizontalRotations(shapeNorth, Direction.NORTH);
        for (BlockState state : states) {
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            VoxelShape shape = switch (facing) {
                case Direction.UP -> shapeUp;
                case Direction.DOWN -> shapeDown;
                default -> horShapes[facing.m_122416_()];
            };
            builder.put((Object)state, (Object)shape);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateSlabShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        VoxelShape shapeUp = ShapeUtils.orUnoptimized(FramedPyramidBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), FramedPyramidBlock.m_49796_((double)0.5, (double)0.5, (double)0.5, (double)15.5, (double)2.0, (double)15.5), FramedPyramidBlock.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), FramedPyramidBlock.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), FramedPyramidBlock.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0));
        VoxelShape shapeDown = ShapeUtils.orUnoptimized(FramedPyramidBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedPyramidBlock.m_49796_((double)0.5, (double)14.0, (double)0.5, (double)15.5, (double)15.5, (double)15.5), FramedPyramidBlock.m_49796_((double)2.0, (double)12.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), FramedPyramidBlock.m_49796_((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), FramedPyramidBlock.m_49796_((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0));
        VoxelShape shapeNorth = ShapeUtils.orUnoptimized(FramedPyramidBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), FramedPyramidBlock.m_49796_((double)0.5, (double)0.5, (double)14.0, (double)15.5, (double)15.5, (double)15.5), FramedPyramidBlock.m_49796_((double)2.0, (double)2.0, (double)12.0, (double)14.0, (double)14.0, (double)14.0), FramedPyramidBlock.m_49796_((double)4.0, (double)4.0, (double)10.0, (double)12.0, (double)12.0, (double)12.0), FramedPyramidBlock.m_49796_((double)6.0, (double)6.0, (double)8.0, (double)10.0, (double)10.0, (double)10.0));
        VoxelShape[] horShapes = ShapeUtils.makeHorizontalRotations(shapeNorth, Direction.NORTH);
        for (BlockState state : states) {
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            VoxelShape shape = switch (facing) {
                case Direction.UP -> shapeUp;
                case Direction.DOWN -> shapeDown;
                default -> horShapes[facing.m_122416_()];
            };
            builder.put((Object)state, (Object)shape);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

