/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen;

import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.render.item.ItemRenderHelper;
import xfacthd.framedblocks.client.screen.FramingSawScreen;
import xfacthd.framedblocks.client.util.RecipeViewer;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeAdditive;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeMatchResult;
import xfacthd.framedblocks.common.menu.IFramingSawMenu;
import xfacthd.framedblocks.common.menu.PoweredFramingSawMenu;
import xfacthd.framedblocks.common.net.SelectFramingSawRecipePacket;

public class PoweredFramingSawScreen
extends AbstractContainerScreen<PoweredFramingSawMenu> {
    private static final ResourceLocation BACKGROUND = Utils.rl("textures/gui/powered_framing_saw.png");
    public static final Component TITLE_TARGETBLOCK = Utils.translate("title", "powered_saw.target_block");
    public static final MutableComponent MSG_STATUS = Utils.translate("msg", "powered_saw.status");
    public static final Component MSG_STATUS_NO_RECIPE = Utils.translate("msg", "powered_saw.status.no_recipe").m_130948_(Style.f_131099_.m_178520_(0xDD7700));
    public static final Component MSG_STATUS_NO_MATCH = Utils.translate("msg", "powered_saw.status.no_match").m_130948_(Style.f_131099_.m_178520_(0xDD0000));
    public static final Component MSG_STATUS_READY = Utils.translate("msg", "powered_saw.status.ready").m_130948_(Style.f_131099_.m_178520_(56576));
    public static final Component TOOLTIP_STATUS_NO_RECIPE = Utils.translate("tooltip", "powered_saw.status.no_recipe");
    public static final String TOOLTIP_ENERGY = Utils.translationKey("tooltip", "powered_saw.energy");
    private static final int TITLE_TARGETBLOCK_X = 88;
    private static final int TITLE_TARGETBLOCK_Y = 24;
    private static final int TARGET_STACK_X = 92;
    private static final int TARGET_STACK_Y = 20;
    private static final int STATUS_X = 8;
    private static final int STATUS_Y = 62;
    private static final int ENERGY_X = 8;
    private static final int ENERGY_Y = 18;
    private static final int ENERGY_WIDTH = 14;
    private static final int ENERGY_HEIGHT = 48;
    private static final int ENERGY_U = 176;
    private static final int ENERGY_V = 16;
    public static final int PROGRESS_X = 115;
    public static final int PROGRESS_Y = 46;
    public static final int PROGRESS_WIDTH = 22;
    public static final int PROGRESS_HEIGHT = 16;
    private static final int PROGRESS_U = 176;
    private static final int PROGRESS_V = 0;
    private static final int CROSS_SIZE = 16;
    private static final int CROSS_U = 176;
    private static final int CROSS_V = 64;
    private static final Rect2i EMPTY = new Rect2i(0, 0, 0, 0);
    private static final RecipeViewer RECIPE_VIEWER = RecipeViewer.get();
    private final FramingSawRecipeCache cache = FramingSawRecipeCache.get(true);
    private final ItemStack cubeStack = new ItemStack((ItemLike)FBContent.BLOCK_FRAMED_CUBE.get());
    private int targetStackX;
    private int targetStackY;
    private Rect2i statusTooltipArea = EMPTY;
    private List<Component> statusTooltip = List.of();

    public PoweredFramingSawScreen(PoweredFramingSawMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.f_97727_ = 182;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.targetStackX = this.f_97735_ + 92;
        this.targetStackY = this.f_97736_ + 20;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        this.m_280273_(graphics);
        graphics.m_280218_(BACKGROUND, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int tx = this.f_97735_ + 88 - this.f_96547_.m_92852_((FormattedText)TITLE_TARGETBLOCK);
        int ty = this.f_97736_ + 24;
        graphics.m_280614_(this.f_96547_, TITLE_TARGETBLOCK, tx, ty, 0x404040, false);
        FramingSawRecipe recipe = ((PoweredFramingSawMenu)this.f_97732_).getSelectedRecipe();
        FramingSawRecipeMatchResult match = ((PoweredFramingSawMenu)this.f_97732_).getMatchResult();
        this.drawRecipeInfo(graphics, recipe, match);
        this.drawStatus(graphics, recipe, match);
        this.drawEnergyBar(graphics, mouseX, mouseY);
    }

    private void drawRecipeInfo(GuiGraphics graphics, FramingSawRecipe recipe, FramingSawRecipeMatchResult match) {
        Slot inputSlot = ((PoweredFramingSawMenu)this.f_97732_).m_38853_(0);
        if (!inputSlot.m_6657_()) {
            int ix = this.f_97735_ + inputSlot.f_40220_;
            int iy = this.f_97736_ + inputSlot.f_40221_;
            ItemRenderHelper.renderFakeItemTransparent(graphics.m_280168_(), this.cubeStack, ix, iy, 127);
        }
        if (recipe != null) {
            float progress;
            ItemStack result = recipe.getResult();
            ItemRenderHelper.renderFakeItemTransparent(graphics.m_280168_(), result, this.targetStackX, this.targetStackY, 127);
            List<FramingSawRecipeAdditive> additives = recipe.getAdditives();
            for (int i = 0; i < 3; ++i) {
                Slot additiveSlot = ((PoweredFramingSawMenu)this.f_97732_).m_38853_(1 + i);
                if (i >= additives.size()) {
                    int ax = this.f_97735_ + additiveSlot.f_40220_;
                    int ay = this.f_97736_ + additiveSlot.f_40221_;
                    graphics.m_280218_(BACKGROUND, ax, ay, 176, 64, 16, 16);
                    continue;
                }
                if (additiveSlot.m_6657_()) continue;
                ItemStack[] items = additives.get(i).ingredient().m_43908_();
                int t = (int)(System.currentTimeMillis() / 1700L) % items.length;
                int ax = this.f_97735_ + additiveSlot.f_40220_;
                int ay = this.f_97736_ + additiveSlot.f_40221_;
                ItemRenderHelper.renderFakeItemTransparent(graphics.m_280168_(), items[t], ax, ay, 127);
            }
            if (match != null && match.success() && (progress = (float)((PoweredFramingSawMenu)this.f_97732_).getProgress() / 30.0f) > 0.0f) {
                int width = Math.round(22.0f * progress);
                graphics.m_280218_(BACKGROUND, this.f_97735_ + 115, this.f_97736_ + 46, 176, 0, width, 16);
            }
        }
    }

    private void drawStatus(GuiGraphics graphics, FramingSawRecipe recipe, FramingSawRecipeMatchResult match) {
        Rect2i rect2i;
        MutableComponent status = MSG_STATUS.m_6881_();
        int width = -1;
        if (recipe == null) {
            status = status.m_7220_(MSG_STATUS_NO_RECIPE);
            this.statusTooltip = List.of(TOOLTIP_STATUS_NO_RECIPE);
            width = this.f_96547_.m_92852_((FormattedText)MSG_STATUS_NO_RECIPE);
        } else if (match != null && !match.success()) {
            status = status.m_7220_(MSG_STATUS_NO_MATCH);
            this.statusTooltip = FramingSawScreen.appendRecipeFailure(new ArrayList<Component>(), this.cache, ((PoweredFramingSawMenu)this.f_97732_).getSelectedRecipe(), match, (IFramingSawMenu)this.f_97732_);
            width = this.f_96547_.m_92852_((FormattedText)MSG_STATUS_NO_MATCH);
        } else {
            status = status.m_7220_(MSG_STATUS_READY);
        }
        int sx = this.f_97735_ + 8;
        Objects.requireNonNull(this.f_96547_);
        int sy = this.f_97736_ + 62 + 9;
        graphics.m_280614_(this.f_96547_, (Component)status, sx, sy, 0x404040, false);
        if (width == -1) {
            rect2i = EMPTY;
        } else {
            int n = sx + this.f_96547_.m_92852_((FormattedText)MSG_STATUS);
            Objects.requireNonNull(this.f_96547_);
            rect2i = new Rect2i(n, sy, width, 9);
        }
        this.statusTooltipArea = rect2i;
    }

    private void drawEnergyBar(GuiGraphics graphics, int mouseX, int mouseY) {
        float energy = (float)((PoweredFramingSawMenu)this.f_97732_).getEnergy() / 5000.0f;
        int height = (int)(energy * 48.0f);
        int y = this.f_97736_ + 18 + (48 - height);
        graphics.m_280218_(BACKGROUND, this.f_97735_ + 8, y, 176, 16 + (48 - height), 14, height);
        int minX = this.f_97735_ + 8;
        int minY = this.f_97736_ + 18;
        if (mouseX >= minX && mouseX < minX + 14 && mouseY >= minY && mouseY < minY + 48) {
            this.m_257404_((Component)Component.m_237110_((String)TOOLTIP_ENERGY, (Object[])new Object[]{((PoweredFramingSawMenu)this.f_97732_).getEnergy(), 5000}));
        }
    }

    protected void m_280072_(GuiGraphics graphics, int mouseX, int mouseY) {
        if (((PoweredFramingSawMenu)this.f_97732_).m_142621_().m_41619_() && this.f_97734_ != null && this.f_97734_.m_6657_()) {
            this.renderHoveredItemTooltip(graphics, mouseX, mouseY, this.f_97734_.m_7993_());
            return;
        }
        if (this.statusTooltipArea.m_110087_(mouseX, mouseY)) {
            graphics.renderTooltip(this.f_96547_, this.statusTooltip, Optional.empty(), ItemStack.f_41583_, mouseX, mouseY);
            this.statusTooltipArea = EMPTY;
            this.statusTooltip = List.of();
        }
    }

    private void renderHoveredItemTooltip(GuiGraphics graphics, int mouseX, int mouseY, ItemStack stack) {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(PoweredFramingSawScreen.m_280152_((Minecraft)this.f_96541_, (ItemStack)stack));
        Optional tooltip = stack.m_150921_();
        int material = this.cache.getMaterialValue(stack.m_41720_());
        if (material > 0) {
            components.add(Component.m_237110_((String)FramingSawScreen.TOOLTIP_MATERIAL, (Object[])new Object[]{material}));
        }
        graphics.renderTooltip(this.f_96547_, components, tooltip, stack, mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int btn) {
        if (mouseX >= (double)this.targetStackX && mouseX < (double)(this.targetStackX + 18) && mouseY >= (double)this.targetStackY && mouseY < (double)(this.targetStackY + 18)) {
            this.selectRecipe(((PoweredFramingSawMenu)this.f_97732_).m_142621_());
            return true;
        }
        return super.m_6375_(mouseX, mouseY, btn);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        RecipeViewer.LookupTarget target;
        if (RECIPE_VIEWER != null && (target = RECIPE_VIEWER.isShowRecipePressed(keyCode, scanCode)) != null) {
            Window window = Objects.requireNonNull(this.f_96541_).m_91268_();
            MouseHandler mouseHandler = this.f_96541_.f_91067_;
            double mouseX = mouseHandler.m_91589_() * (double)window.m_85445_() / (double)window.m_85443_();
            double mouseY = mouseHandler.m_91594_() * (double)window.m_85446_() / (double)window.m_85444_();
            FramingSawRecipe recipe = ((PoweredFramingSawMenu)this.f_97732_).getSelectedRecipe();
            if (recipe != null && this.isMouseOverRecipeSlot(mouseX, mouseY) && RECIPE_VIEWER.handleShowRecipeRequest(recipe.getResult(), target)) {
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean isMouseOverRecipeSlot(double mouseX, double mouseY) {
        return mouseX >= (double)this.targetStackX && mouseX < (double)(this.targetStackX + 18) && mouseY >= (double)this.targetStackY && mouseY < (double)(this.targetStackY + 18);
    }

    public void selectRecipe(ItemStack cursorStack) {
        if (cursorStack.m_41619_() || this.cache.getMaterialValue(cursorStack.m_41720_()) != -1) {
            int id;
            FramingSawRecipe recipe = this.cache.findRecipeFor(cursorStack);
            if (recipe == ((PoweredFramingSawMenu)this.f_97732_).getSelectedRecipe()) {
                return;
            }
            int n = id = recipe == null ? -1 : this.cache.getRecipes().indexOf(recipe);
            if (((PoweredFramingSawMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, id)) {
                FramedBlocks.CHANNEL.sendToServer((Object)new SelectFramingSawRecipePacket(((PoweredFramingSawMenu)this.f_97732_).f_38840_, id));
            }
        }
    }

    public int getTargetStackX() {
        return this.targetStackX;
    }

    public int getTargetStackY() {
        return this.targetStackY;
    }
}

