/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slopeslab;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.slopeslab.FramedSlopeSlabModel;

public class FramedCompoundSlopeSlabModel
extends FramedBlockModel {
    private final Direction dir;
    private final boolean ySlope;

    public FramedCompoundSlopeSlabModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        this.ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        if (quadDir == this.dir) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(true, 0.5f)).export(quadMap.get(quadDir));
            if (!this.ySlope) {
                QuadModifier.geometry(quad).apply(Modifiers.makeVerticalSlope(false, FramedSlopeSlabModel.SLOPE_ANGLE)).apply(Modifiers.offset(Direction.DOWN, 0.5f)).export(quadMap.get(null));
            }
        } else if (quadDir == this.dir.m_122424_()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(false, 0.5f)).export(quadMap.get(quadDir));
            if (!this.ySlope) {
                QuadModifier.geometry(quad).apply(Modifiers.makeVerticalSlope(true, FramedSlopeSlabModel.SLOPE_ANGLE)).apply(Modifiers.offset(Direction.UP, 0.5f)).export(quadMap.get(null));
            }
        } else if (this.ySlope && Utils.isY(quadDir)) {
            Direction edge = quadDir == Direction.UP ? this.dir.m_122424_() : this.dir;
            QuadModifier.geometry(quad).apply(Modifiers.makeVerticalSlope(edge, FramedSlopeSlabModel.SLOPE_ANGLE_VERT)).export(quadMap.get(null));
        } else if (quadDir.m_122434_() == this.dir.m_122427_().m_122434_()) {
            boolean cw = quadDir == this.dir.m_122427_();
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(false, cw ? 0.5f : 1.0f, cw ? 1.0f : 0.5f)).apply(Modifiers.cutSideUpDown(true, cw ? 1.0f : 0.5f, cw ? 0.5f : 1.0f)).export(quadMap.get(null));
        }
    }
}

