/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.FoodProvider;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.forge.SoftFluidImpl;
import net.mehvahdjukaar.moonlight.api.misc.StrOpt;
import net.mehvahdjukaar.moonlight.api.misc.Triplet;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class SoftFluid {
    private final Component name;
    private final LazyFluidSet equivalentFluids;
    private final FluidContainerList containerList;
    private final FoodProvider food;
    private final List<String> NBTFromItem;
    public final boolean isGenerated;
    private final ResourceLocation stillTexture;
    private final ResourceLocation flowingTexture;
    @Nullable
    private final ResourceLocation useTexturesFrom;
    private final int luminosity;
    private final int emissivity;
    private final int tintColor;
    private final TintMethod tintMethod;
    protected int averageTextureTint = -1;
    public static final int BOTTLE_COUNT = Capacity.BOTTLE.getValue();
    public static final int BOWL_COUNT = Capacity.BOWL.getValue();
    public static final int BUCKET_COUNT = Capacity.BUCKET.getValue();
    public static final int WATER_BUCKET_COUNT = 3;
    public static final Codec<Holder<SoftFluid>> HOLDER_CODEC = RegistryFileCodec.m_135589_(SoftFluidRegistry.KEY, CODEC);
    public static final Codec<Component> COMPONENT_CODEC = Codec.either((Codec)ExtraCodecs.f_252442_, (Codec)Codec.STRING).xmap(either -> (Component)either.map(c -> c, Component::m_237115_), Either::left);
    public static final Codec<SoftFluid> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("still_texture").forGetter(SoftFluid::getStillTexture), (App)ResourceLocation.f_135803_.fieldOf("flowing_texture").forGetter(SoftFluid::getFlowingTexture), (App)StrOpt.of(COMPONENT_CODEC, "translation_key").forGetter(SoftFluid.getHackyOptional(SoftFluid::getTranslatedName)), (App)StrOpt.of(Codec.intRange((int)0, (int)15), "luminosity").forGetter(SoftFluid.getHackyOptional(SoftFluid::getLuminosity)), (App)StrOpt.of(Codec.intRange((int)0, (int)15), "emissivity").forGetter(SoftFluid.getHackyOptional(SoftFluid::getEmissivity)), (App)StrOpt.of(ColorUtils.CODEC, "color").forGetter(SoftFluid.getHackyOptional(SoftFluid::getTintColor)), (App)StrOpt.of(TintMethod.CODEC, "tint_method").forGetter(SoftFluid.getHackyOptional(SoftFluid::getTintMethod)), (App)FoodProvider.CODEC.optionalFieldOf("food").forGetter(SoftFluid.getHackyOptional(SoftFluid::getFoodProvider)), (App)StrOpt.of(Codec.STRING.listOf(), "preserved_tags_from_item").forGetter(SoftFluid.getHackyOptional(SoftFluid::getNbtKeyFromItem)), (App)StrOpt.of(FluidContainerList.Category.CODEC.listOf(), "containers").forGetter(f -> f.getContainerList().encodeList()), (App)StrOpt.of(LazyFluidSet.CODEC, "equivalent_fluids", LazyFluidSet.EMPTY).forGetter(s -> s.equivalentFluids), (App)StrOpt.of(ResourceLocation.f_135803_, "use_texture_from").forGetter(s -> Optional.ofNullable(s.getTextureOverride()))).apply((Applicative)instance, SoftFluid::create));
    private static final SoftFluid DEFAULT_DUMMY = new SoftFluid(new Builder(new ResourceLocation(""), new ResourceLocation("")));

    private SoftFluid(Builder builder) {
        Triplet<ResourceLocation, ResourceLocation, Integer> data;
        this.tintMethod = builder.tintMethod;
        this.equivalentFluids = new LazyFluidSet(builder.equivalentFluids);
        this.luminosity = builder.luminosity;
        this.emissivity = builder.emissivity;
        this.containerList = builder.containerList;
        this.food = builder.food;
        this.name = builder.name;
        this.NBTFromItem = builder.NBTFromItem;
        this.useTexturesFrom = builder.useTexturesFrom;
        ResourceLocation still = builder.stillTexture;
        ResourceLocation flowing = builder.flowingTexture;
        int tint = builder.tintColor;
        if (this.useTexturesFrom != null && PlatHelper.getPhysicalSide().isClient() && (data = SoftFluid.getRenderingData(this.useTexturesFrom)) != null) {
            still = data.left();
            flowing = data.middle();
            tint = data.right();
        }
        this.stillTexture = still;
        this.flowingTexture = flowing;
        this.tintColor = tint;
        this.isGenerated = builder.isFromData;
    }

    @Nullable
    public ResourceLocation getTextureOverride() {
        return this.useTexturesFrom;
    }

    public FoodProvider getFoodProvider() {
        return this.food;
    }

    public Component getTranslatedName() {
        return this.name;
    }

    @Deprecated(forRemoval=true)
    public String getTranslationKey() {
        return "fluid";
    }

    public boolean isEnabled() {
        return !this.equivalentFluids.isEmpty() || !this.containerList.getPossibleFilled().isEmpty();
    }

    @Deprecated(forRemoval=true)
    public String getFromMod() {
        return "minecraft";
    }

    public Fluid getVanillaFluid() {
        Iterator<Fluid> iterator = this.getEquivalentFluids().iterator();
        if (iterator.hasNext()) {
            Fluid fluid = iterator.next();
            return fluid;
        }
        return Fluids.f_76191_;
    }

    @Deprecated(forRemoval=true)
    public Fluid getForgeFluid() {
        return this.getVanillaFluid();
    }

    public List<String> getNbtKeyFromItem() {
        return this.NBTFromItem;
    }

    public List<Fluid> getEquivalentFluids() {
        return this.equivalentFluids.getFluids();
    }

    public boolean isEquivalent(Fluid fluid) {
        return this.equivalentFluids.getFluids().contains(fluid);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public boolean isEmpty() {
        return this == SoftFluidRegistry.empty();
    }

    public boolean isEmptyFluid() {
        return this == SoftFluidRegistry.empty();
    }

    public Optional<Item> getFilledContainer(Item emptyContainer) {
        return this.containerList.getFilled(emptyContainer);
    }

    public Optional<Item> getEmptyContainer(Item filledContainer) {
        return this.containerList.getEmpty(filledContainer);
    }

    public FluidContainerList getContainerList() {
        return this.containerList;
    }

    public int getLuminosity() {
        return this.luminosity;
    }

    public int getEmissivity() {
        return this.emissivity;
    }

    public int getTintColor() {
        return this.tintColor;
    }

    public int getAverageTextureTintColor() {
        return this.averageTextureTint;
    }

    public TintMethod getTintMethod() {
        return this.tintMethod;
    }

    public boolean isColored() {
        return this.tintColor != -1;
    }

    public ResourceLocation getFlowingTexture() {
        return this.flowingTexture;
    }

    public ResourceLocation getStillTexture() {
        return this.stillTexture;
    }

    public boolean isFood() {
        return !this.food.isEmpty();
    }

    protected static SoftFluid create(ResourceLocation still, ResourceLocation flowing, Optional<Component> translation, Optional<Integer> luminosity, Optional<Integer> emissivity, Optional<Integer> color, Optional<TintMethod> tint, Optional<FoodProvider> food, Optional<List<String>> nbtKeys, Optional<List<FluidContainerList.Category>> containers, LazyFluidSet equivalent, Optional<ResourceLocation> textureFrom) {
        Builder builder = new Builder(still, flowing);
        translation.ifPresent(builder::translation);
        luminosity.ifPresent(builder::luminosity);
        emissivity.ifPresent(builder::emissivity);
        color.ifPresent(builder::color);
        tint.ifPresent(builder::tintMethod);
        food.ifPresent(builder::food);
        nbtKeys.ifPresent(k -> k.forEach(xva$0 -> builder.keepNBTFromItem((String)xva$0)));
        containers.ifPresent(b -> builder.containers(new FluidContainerList((List<FluidContainerList.Category>)b)));
        LazyFluidSet.merge(new LazyFluidSet(builder.equivalentFluids), equivalent);
        textureFrom.ifPresent(builder::copyTexturesFrom);
        return builder.build();
    }

    private static <T> Function<SoftFluid, Optional<T>> getHackyOptional(Function<SoftFluid, T> getter) {
        return f -> {
            Object value = getter.apply((SoftFluid)f);
            Object def = getter.apply(DEFAULT_DUMMY);
            return value == null || value.equals(def) ? Optional.empty() : Optional.of(value);
        };
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addFluidSpecificAttributes(Builder builder, Fluid fluid) {
        void var1_1;
        SoftFluidImpl.addFluidSpecificAttributes(builder, (Fluid)var1_1);
    }

    @ApiStatus.Internal
    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Triplet<ResourceLocation, ResourceLocation, Integer> getRenderingData(ResourceLocation useTexturesFrom) {
        return SoftFluidImpl.getRenderingData(useTexturesFrom);
    }

    public static class Builder {
        private ResourceLocation stillTexture;
        private ResourceLocation flowingTexture;
        private Component name = Component.m_237115_((String)"fluid.moonlight.generic_fluid");
        private int luminosity = 0;
        private int emissivity = 0;
        private int tintColor = -1;
        private TintMethod tintMethod = TintMethod.STILL_AND_FLOWING;
        private FoodProvider food = FoodProvider.EMPTY;
        private FluidContainerList containerList = new FluidContainerList();
        private final List<String> NBTFromItem = new ArrayList<String>();
        private final List<String> equivalentFluids = new ArrayList<String>();
        private boolean isFromData = true;
        private ResourceLocation useTexturesFrom;

        public Builder(ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            this.stillTexture = stillTexture;
            this.flowingTexture = flowingTexture;
        }

        public Builder(Fluid fluid) {
            this(new ResourceLocation("block/water_still"), new ResourceLocation("minecraft:block/water_flowing"));
            this.copyTexturesFrom(Utils.getID(fluid));
            this.addEqFluid(fluid);
            this.isFromData = false;
            SoftFluid.addFluidSpecificAttributes(this, fluid);
        }

        public final Builder textures(ResourceLocation still, ResourceLocation flow) {
            this.stillTexture = still;
            this.flowingTexture = flow;
            return this;
        }

        @Deprecated(forRemoval=true)
        public final Builder translationKey(String translationKey) {
            if (translationKey != null) {
                this.name = Component.m_237115_((String)translationKey);
            }
            return this;
        }

        public final Builder translation(Component component) {
            if (component != null) {
                this.name = component;
            }
            return this;
        }

        public final Builder keepNBTFromItem(String ... NBTkey) {
            this.NBTFromItem.addAll(Arrays.asList(NBTkey));
            return this;
        }

        public final Builder color(int tintColor) {
            this.tintColor = tintColor;
            return this;
        }

        public final Builder noTint() {
            this.tintMethod = TintMethod.NO_TINT;
            return this;
        }

        public final Builder tinted() {
            this.tintMethod = TintMethod.STILL_AND_FLOWING;
            return this;
        }

        public final Builder onlyFlowingTinted() {
            this.tintMethod = TintMethod.FLOWING;
            return this;
        }

        public final Builder tintMethod(TintMethod tint) {
            this.tintMethod = tint;
            return this;
        }

        public final Builder luminosity(int luminosity) {
            this.luminosity = luminosity;
            this.emissivity = luminosity;
            return this;
        }

        public final Builder emissivity(int emissivity) {
            this.emissivity = emissivity;
            return this;
        }

        public final Builder addEqFluid(Fluid fluid) {
            if (fluid != null && fluid != Fluids.f_76191_) {
                this.equivalentFluids.add(BuiltInRegistries.f_257020_.m_7981_((Object)fluid).toString());
                Item i = fluid.m_6859_();
                if (i != Items.f_41852_ && i != Items.f_42446_) {
                    this.bucket(i);
                }
            }
            return this;
        }

        public final Builder copyTexturesFrom(ResourceLocation fluidRes) {
            this.useTexturesFrom = fluidRes;
            return this;
        }

        public final Builder copyTexturesFrom(String fluidRes) {
            return this.copyTexturesFrom(new ResourceLocation(fluidRes));
        }

        public final Builder containerItem(Item filledItem, Item emptyItem, int itemCapacity) {
            if (filledItem != Items.f_41852_) {
                this.containerList.add(emptyItem, filledItem, itemCapacity);
            }
            return this;
        }

        public final Builder containerItem(Item filledItem, Item emptyItem, int itemCapacity, SoundEvent fillSound, SoundEvent emptySound) {
            if (filledItem != Items.f_41852_) {
                this.containerList.add(emptyItem, filledItem, itemCapacity, fillSound, emptySound);
            }
            return this;
        }

        public final Builder containers(FluidContainerList containerList) {
            this.containerList = containerList;
            return this;
        }

        public final Builder emptyHandContainerItem(Item filledItem, int itemCapacity) {
            if (filledItem != Items.f_41852_) {
                return this.containerItem(filledItem, Items.f_41852_, itemCapacity);
            }
            return this;
        }

        public final Builder bottle(Item item) {
            this.containerItem(item, Items.f_42590_, BOTTLE_COUNT);
            return this;
        }

        public final Builder drink(Item item) {
            return this.bottle(item).food(item, BOTTLE_COUNT);
        }

        public final Builder bucket(Item item) {
            this.containerItem(item, Items.f_42446_, BUCKET_COUNT, SoundEvents.f_11781_, SoundEvents.f_11778_);
            return this;
        }

        public final Builder bowl(Item item) {
            this.containerItem(item, Items.f_42399_, BOWL_COUNT);
            return this;
        }

        public final Builder stew(Item item) {
            return this.bowl(item).food(item, BOWL_COUNT);
        }

        public final Builder food(Item item) {
            return this.food(item, 1);
        }

        public final Builder food(Item item, int foodDivider) {
            if (item != null) {
                this.food(FoodProvider.create(item, foodDivider));
            }
            return this;
        }

        public final Builder food(FoodProvider foodProvider) {
            this.food = foodProvider;
            return this;
        }

        public SoftFluid build() {
            return new SoftFluid(this);
        }

        @Deprecated(forRemoval=true)
        public final Builder fromMod(String s) {
            return this;
        }
    }

    public static enum TintMethod implements StringRepresentable
    {
        NO_TINT,
        FLOWING,
        STILL_AND_FLOWING;

        public static final Codec<TintMethod> CODEC;

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public boolean appliesToFlowing() {
            return this == FLOWING || this == STILL_AND_FLOWING;
        }

        public boolean appliesToStill() {
            return this == STILL_AND_FLOWING;
        }

        static {
            CODEC = StringRepresentable.m_216439_(TintMethod::values);
        }
    }

    private static class LazyFluidSet {
        protected static final LazyFluidSet EMPTY = new LazyFluidSet(Collections.emptyList());
        protected static final Codec<LazyFluidSet> CODEC = Codec.STRING.listOf().xmap(LazyFluidSet::new, s -> s.keys);
        private final List<String> keys;
        private final List<Fluid> fluids;
        private final List<TagKey<Fluid>> tags = new ArrayList<TagKey<Fluid>>();

        private LazyFluidSet(List<String> keys) {
            this.keys = keys;
            LinkedHashSet set = new LinkedHashSet();
            for (String key : keys) {
                if (key.startsWith("#")) {
                    this.tags.add((TagKey<Fluid>)TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)new ResourceLocation(key.substring(1))));
                    continue;
                }
                BuiltInRegistries.f_257020_.m_6612_(new ResourceLocation(key)).ifPresent(set::add);
            }
            this.fluids = List.of(set.toArray(new Fluid[0]));
        }

        public static LazyFluidSet merge(LazyFluidSet first, LazyFluidSet second) {
            if (first.isEmpty()) {
                return second;
            }
            if (second.isEmpty()) {
                return first;
            }
            ArrayList<String> keys = new ArrayList<String>(first.keys);
            keys.addAll(second.keys);
            return new LazyFluidSet(keys);
        }

        public List<Fluid> getFluids() {
            if (this.tags.isEmpty()) {
                return this.fluids;
            }
            ArrayList<Fluid> list = new ArrayList<Fluid>(this.fluids);
            for (TagKey<Fluid> tag : this.tags) {
                BuiltInRegistries.f_257020_.m_206058_(tag).forEach(e -> list.add((Fluid)e.m_203334_()));
            }
            return list;
        }

        public boolean isEmpty() {
            return this.getFluids().isEmpty();
        }
    }

    public static enum Capacity implements StringRepresentable
    {
        BOTTLE(1, 1),
        BOWL(2, 1),
        BUCKET(4, 3),
        BLOCK(4, 4);

        public final int value;
        public static final Codec<Capacity> CODEC;
        public static final Codec<Integer> INT_CODEC;

        private Capacity(int forge, int fabric) {
            this.value = PlatHelper.getPlatform().isForge() ? forge : fabric;
        }

        public String m_7912_() {
            return this.name().toUpperCase(Locale.ROOT);
        }

        public int getValue() {
            return this.value;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Capacity::values);
            INT_CODEC = Codec.either((Codec)Codec.INT, CODEC).xmap(either -> (Integer)either.map(i -> i, Capacity::getValue), Either::left);
        }
    }
}

