/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.client.emotes.base;

import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.player.EntityPlayer;
import vazkii.aurelienribon.tweenengine.BaseTween;
import vazkii.aurelienribon.tweenengine.Timeline;
import vazkii.aurelienribon.tweenengine.TweenCallback;
import vazkii.aurelienribon.tweenengine.TweenManager;
import vazkii.quark.vanity.client.emotes.base.EmoteHandler;
import vazkii.quark.vanity.client.emotes.base.EmoteState;

public abstract class EmoteBase {
    public static final float PI_F = (float)Math.PI;
    public TweenManager emoteManager = new TweenManager();
    private ModelBiped model;
    private ModelBiped armorModel;
    private ModelBiped armorLegsModel;
    private EmoteState state = new EmoteState(this);
    private boolean done = false;

    public EmoteBase(EntityPlayer player, ModelBiped model, ModelBiped armorModel, ModelBiped armorLegsModel) {
        this.model = model;
        this.armorModel = armorModel;
        this.armorLegsModel = armorLegsModel;
        this.startTimeline(player, model, true);
        this.startTimeline(player, armorModel, false);
        this.startTimeline(player, armorLegsModel, false);
    }

    void startTimeline(EntityPlayer player, ModelBiped model, boolean callback) {
        Timeline timeline = (Timeline)this.getTimeline(player, model).start(this.emoteManager);
        if (callback) {
            timeline.setCallback(new FinishCallback());
        }
    }

    public abstract Timeline getTimeline(EntityPlayer var1, ModelBiped var2);

    public abstract boolean usesBodyPart(int var1);

    public void update(boolean doUpdate) {
        this.state.load(this.model);
        this.state.load(this.armorModel);
        this.state.load(this.armorLegsModel);
        if (doUpdate) {
            this.emoteManager.update(EmoteHandler.delta);
            this.state.save(this.model);
        }
    }

    public boolean isDone() {
        return this.done;
    }

    private class FinishCallback
    implements TweenCallback {
        private FinishCallback() {
        }

        @Override
        public void onEvent(int type, BaseTween<?> source) {
            if (type == 8) {
                EmoteBase.this.done = true;
            }
        }
    }
}

