/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.structures.helpers;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.structures.helpers.Structure;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureProxy {
    private final Structure structure;
    private Template.EntityInfo[][][] entities;
    private Template.BlockInfo[][][] blocks;
    private int width;
    private int height;
    private int length;
    private BlockPos offset;

    public StructureProxy(World worldObj, String name) {
        this.structure = new Structure(worldObj, name, new PlacementSettings());
        if (this.structure.isTemplateMissing()) {
            return;
        }
        BlockPos size = this.structure.getSize(Rotation.NONE);
        this.width = size.func_177958_n();
        this.height = size.func_177956_o();
        this.length = size.func_177952_p();
        this.blocks = new Template.BlockInfo[this.width][this.height][this.length];
        this.entities = new Template.EntityInfo[this.width][this.height][this.length];
        for (Template.BlockInfo info : this.structure.getBlockInfo()) {
            BlockPos tempPos = info.field_186242_a;
            this.blocks[tempPos.func_177958_n()][tempPos.func_177956_o()][tempPos.func_177952_p()] = info;
            this.entities[tempPos.func_177958_n()][tempPos.func_177956_o()][tempPos.func_177952_p()] = null;
            if (!(info.field_186243_b.func_177230_c() instanceof AbstractBlockHut)) continue;
            this.offset = info.field_186242_a;
        }
        for (Template.EntityInfo info : this.structure.getTileEntities()) {
            BlockPos tempPos = info.field_186248_b;
            this.entities[tempPos.func_177958_n()][tempPos.func_177956_o()][tempPos.func_177952_p()] = info;
        }
    }

    public BlockPos getOffset() {
        return this.offset;
    }

    public void setOffset(BlockPos pos) {
        this.offset = pos;
    }

    public String getType() {
        if (this.hasOffset()) {
            return "Hut";
        }
        return "Decoration";
    }

    private boolean hasOffset() {
        return !BlockPosUtil.isEqual(this.offset, 0, 0, 0);
    }

    public Structure getStructure() {
        return this.structure;
    }

    public IBlockState getBlockState(@NotNull BlockPos pos) {
        return this.blocks[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()].field_186243_b;
    }

    public Template.BlockInfo getBlockInfo(@NotNull BlockPos pos) {
        return this.blocks[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()];
    }

    public List<Template.EntityInfo> getTileEntities() {
        return this.structure.getTileEntities();
    }

    @Nullable
    public Template.EntityInfo getEntityinfo(@NotNull BlockPos pos) {
        if (this.entities[pos.func_177958_n()][pos.func_177956_o()].length == 0) {
            return null;
        }
        return this.entities[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()];
    }

    public int getWidth() {
        return this.width;
    }

    public int getLength() {
        return this.length;
    }

    public int getHeight() {
        return this.height;
    }

    public void rotateWithMirror(int times, World world, BlockPos rotatePos, Mirror mirror) {
        Rotation rotation;
        switch (times) {
            case 1: {
                rotation = Rotation.CLOCKWISE_90;
                break;
            }
            case 2: {
                rotation = Rotation.CLOCKWISE_180;
                break;
            }
            case 3: {
                rotation = Rotation.COUNTERCLOCKWISE_90;
                break;
            }
            default: {
                rotation = Rotation.NONE;
            }
        }
        this.structure.setPlacementSettings(new PlacementSettings().func_186220_a(rotation).func_186214_a(mirror));
        BlockPos size = this.structure.getSize(rotation);
        this.width = size.func_177958_n();
        this.height = size.func_177956_o();
        this.length = size.func_177952_p();
        this.blocks = new Template.BlockInfo[this.width][this.height][this.length];
        this.entities = new Template.EntityInfo[this.width][this.height][this.length];
        int minX = 0;
        int minY = 0;
        int minZ = 0;
        for (Template.BlockInfo info : this.structure.getBlockInfoWithSettings(new PlacementSettings().func_186220_a(rotation).func_186214_a(mirror))) {
            BlockPos tempPos = info.field_186242_a;
            int x = tempPos.func_177958_n();
            int y = tempPos.func_177956_o();
            int z = tempPos.func_177952_p();
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (z >= minZ) continue;
            minZ = z;
        }
        minX = Math.abs(minX);
        minY = Math.abs(minY);
        minZ = Math.abs(minZ);
        boolean foundHut = false;
        PlacementSettings settings = new PlacementSettings().func_186220_a(rotation).func_186214_a(mirror);
        for (Template.BlockInfo info : this.structure.getBlockInfoWithSettings(settings)) {
            BlockPos tempPos = info.field_186242_a;
            int x = tempPos.func_177958_n() + minX;
            int y = tempPos.func_177956_o() + minY;
            int z = tempPos.func_177952_p() + minZ;
            this.blocks[x][y][z] = info;
            this.entities[x][y][z] = null;
            if (!(info.field_186243_b.func_177230_c() instanceof AbstractBlockHut)) continue;
            foundHut = true;
            this.offset = info.field_186242_a.func_177982_a(minX, minY, minZ);
        }
        this.updateOffSetIfDecoration(foundHut, size, times, minX, minY, minZ);
        for (Template.EntityInfo info : this.structure.getTileEntities()) {
            Template.EntityInfo newInfo = this.structure.transformEntityInfoWithSettings(info, world, rotatePos.func_177973_b((Vec3i)this.offset).func_177971_a((Vec3i)new BlockPos(minX, minY, minZ)), settings);
            BlockPos tempPos = Template.func_186266_a((PlacementSettings)settings, (BlockPos)info.field_186248_b);
            int x = tempPos.func_177958_n() + minX;
            int y = tempPos.func_177956_o() + minY;
            int z = tempPos.func_177952_p() + minZ;
            this.entities[x][y][z] = newInfo;
        }
    }

    private void updateOffSetIfDecoration(boolean foundHut, BlockPos size, int rotation, int minX, int minY, int minZ) {
        if (!foundHut) {
            BlockPos tempSize = size;
            if (rotation == 1) {
                tempSize = new BlockPos(-size.func_177958_n(), size.func_177956_o(), size.func_177952_p());
            }
            if (rotation == 2) {
                tempSize = new BlockPos(-size.func_177958_n(), size.func_177956_o(), -size.func_177952_p());
            }
            if (rotation == 3) {
                tempSize = new BlockPos(size.func_177958_n(), size.func_177956_o(), -size.func_177952_p());
            }
            this.offset = new BlockPos(tempSize.func_177958_n() / 2, 0, tempSize.func_177952_p() / 2).func_177982_a(minX, minY, minZ);
        }
    }
}

