/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.structures.helpers;

import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.client.gui.WindowBuildTool;
import com.minecolonies.structures.helpers.Structure;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Settings {
    public static final Settings instance = new Settings();
    private final BlockPos.MutableBlockPos offset = new BlockPos.MutableBlockPos();
    private BlockPos pos = null;
    private boolean isMirrored = false;
    @Nullable
    private Structure structure = null;
    private int rotation = 0;
    private String structureName = null;
    private boolean isPendingReset = false;
    private boolean staticSchematicMode = false;
    private String staticSchematicName = "";
    private WindowBuildTool.FreeMode freeMode;

    private Settings() {
    }

    public void setupStaticMode(String name, WindowBuildTool.FreeMode freeMode) {
        this.staticSchematicMode = true;
        this.staticSchematicName = name;
        this.freeMode = freeMode;
    }

    public BlockPos getPosition() {
        return this.pos;
    }

    public void setPosition(BlockPos position) {
        this.pos = position;
    }

    public void moveTo(BlockPos pos) {
        if (this.structure == null) {
            return;
        }
        this.pos = this.pos.func_177971_a((Vec3i)pos);
    }

    @Nullable
    public Structure getActiveStructure() {
        if (this.structure != null && this.structure.isTemplateMissing()) {
            this.structure = null;
        }
        return this.structure;
    }

    public void setActiveSchematic(Structure structure) {
        if (structure == null) {
            this.reset();
        } else {
            this.structure = structure;
        }
    }

    public void reset() {
        this.structure = null;
        this.isPendingReset = false;
        this.offset.func_181079_c(0, 0, 0);
        this.rotation = 0;
        this.isMirrored = false;
        this.staticSchematicMode = false;
        this.freeMode = null;
        this.staticSchematicName = "";
    }

    public void setSchematicInfo(String structureName, int rotation) {
        this.structureName = structureName;
        this.rotation = rotation;
    }

    public String getStructureName() {
        return this.structureName;
    }

    public void setStructureName(String structureName) {
        this.structureName = structureName;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public void markDirty() {
        this.isPendingReset = true;
    }

    public boolean isDirty() {
        return this.isPendingReset;
    }

    @NotNull
    public BlockPos getOffset(PlacementSettings settings) {
        if (this.structure != null) {
            for (Template.BlockInfo info : this.structure.getBlockInfoWithSettings(settings)) {
                if (!(info.field_186243_b.func_177230_c() instanceof AbstractBlockHut)) continue;
                this.offset.func_189533_g((Vec3i)info.field_186242_a);
                return info.field_186242_a;
            }
        }
        return new BlockPos(0, 0, 0);
    }

    public void mirror() {
        if (this.structure == null) {
            return;
        }
        this.isMirrored = !this.isMirrored;
        this.structure.setPlacementSettings(this.structure.getSettings().func_186214_a(this.getMirror()));
    }

    public Mirror getMirror() {
        if (this.isMirrored) {
            return Mirror.FRONT_BACK;
        }
        return Mirror.NONE;
    }

    public boolean isStaticSchematicMode() {
        return this.staticSchematicMode;
    }

    public String getStaticSchematicName() {
        return this.staticSchematicName;
    }

    public WindowBuildTool.FreeMode getFreeMode() {
        return this.freeMode;
    }
}

