/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.structures.fake;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.jetbrains.annotations.NotNull;

public class FakeWorld
extends World {
    private final Map<BlockPos, IBlockState> stateHashMap = new HashMap<BlockPos, IBlockState>();
    private final Map<BlockPos, TileEntity> entityHashMap = new HashMap<BlockPos, TileEntity>();
    private final IBlockState blockState;
    private final TileEntity entity;
    private final boolean simulateWorld;

    public FakeWorld(IBlockState blockState, ISaveHandler saveHandlerIn, WorldInfo info, WorldProvider providerIn, Profiler profilerIn, boolean client) {
        super(saveHandlerIn, info, providerIn, profilerIn, client);
        this.blockState = blockState;
        this.entity = null;
        this.simulateWorld = false;
    }

    public FakeWorld(IBlockState blockState, ISaveHandler saveHandlerIn, WorldInfo info, WorldProvider providerIn, Profiler profilerIn, boolean client, TileEntity entity, boolean simulateWorld) {
        super(saveHandlerIn, info, providerIn, profilerIn, client);
        this.blockState = blockState;
        this.entity = entity;
        this.simulateWorld = simulateWorld;
    }

    @NotNull
    protected IChunkProvider func_72970_h() {
        return null;
    }

    protected boolean func_175680_a(int x, int z, boolean allowEmpty) {
        return false;
    }

    public boolean func_175656_a(BlockPos pos, IBlockState state) {
        this.stateHashMap.put(pos, state);
        return true;
    }

    @NotNull
    public IBlockState func_180495_p(BlockPos pos) {
        if (this.simulateWorld) {
            if (this.stateHashMap.containsKey(pos)) {
                return this.stateHashMap.get(pos);
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        return this.blockState;
    }

    public TileEntity func_175625_s(BlockPos pos) {
        if (this.simulateWorld) {
            return this.entityHashMap.get(pos);
        }
        return this.entity;
    }

    public void func_175690_a(BlockPos pos, @Nullable TileEntity tileEntityIn) {
        if (tileEntityIn != null) {
            this.entityHashMap.put(pos, tileEntityIn);
            tileEntityIn.func_145834_a((World)this);
        }
    }
}

