/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.pathfinding.PathResult;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WorkerUtil {
    private static final double MIDDLE_BLOCK_OFFSET = 0.5;

    private WorkerUtil() {
    }

    public static boolean isWorkerAtSiteWithMove(@NotNull EntityCitizen worker, @NotNull BlockPos site, int range) {
        return WorkerUtil.isWorkerAtSiteWithMove(worker, site.func_177958_n(), site.func_177956_o(), site.func_177952_p(), range);
    }

    public static boolean isWorkerAtSiteWithMove(@NotNull EntityCitizen worker, int x, int y, int z, int range) {
        if (!EntityUtils.isLivingAtSiteWithMove((EntityLiving)worker, x, y, z, range)) {
            if (worker.getNavigator().func_75500_f() && !EntityUtils.tryMoveLivingToXYZ((EntityLiving)worker, x, y, z)) {
                worker.setStatus(EntityCitizen.Status.PATHFINDING_ERROR);
            }
            return false;
        }
        return true;
    }

    public static PathResult moveLivingToXYZ(@NotNull EntityCitizen citizen, @NotNull BlockPos destination) {
        return citizen.getNavigator().moveToXYZ(destination.func_177958_n(), destination.func_177956_o(), destination.func_177952_p(), 1.0);
    }

    public static boolean setSpawnPoint(@Nullable BlockPos spawnPoint, @NotNull EntityCitizen citizen) {
        if (spawnPoint == null) {
            return false;
        }
        citizen.func_70012_b((double)spawnPoint.func_177958_n() + 0.5, spawnPoint.func_177956_o(), (double)spawnPoint.func_177952_p() + 0.5, citizen.field_70177_z, citizen.field_70125_A);
        citizen.getNavigator().func_75499_g();
        return true;
    }

    public static IToolType getBestToolForBlock(Block target) {
        IToolType toolType = ToolType.getToolType(target.getHarvestTool(target.func_176223_P()));
        if (toolType == ToolType.NONE && target.func_176223_P().func_185904_a() == Material.field_151575_d) {
            return ToolType.AXE;
        }
        if (target == Blocks.field_150405_ch || target == Blocks.field_150406_ce) {
            return ToolType.PICKAXE;
        }
        return toolType;
    }

    public static int getCorrectHavestLevelForBlock(Block target) {
        int required = target.getHarvestLevel(target.func_176223_P());
        if (required == -1 && target.func_176223_P().func_185904_a() == Material.field_151575_d || target == Blocks.field_150405_ch || target == Blocks.field_150406_ce) {
            return 0;
        }
        return required;
    }

    public static boolean isPathingTo(@NotNull EntityCitizen citizen, int x, int z) {
        PathPoint pathpoint = citizen.getNavigator().func_75505_d().func_75870_c();
        return pathpoint != null && pathpoint.field_75839_a == x && pathpoint.field_75838_c == z;
    }
}

