/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.sounds.AbstractWorkerSounds;
import com.minecolonies.coremod.sounds.ModSoundEvents;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SoundUtils {
    private static final String GUARD_TOWER = "GuardTower";
    private static final int ONE_HUNDRED = 100;
    private static final double PITCH = 0.9;
    private static final Random rand = new Random();
    private static final double VOLUME = 0.5;
    private static final int CHANCE_TO_PLAY_SOUND = 2400;

    private SoundUtils() {
    }

    public static void playRandomSound(@NotNull World worldIn, @NotNull EntityCitizen citizen, double saturation) {
        if (1 >= rand.nextInt(2400)) {
            String prefix = "";
            if (citizen.getWorkBuilding() != null) {
                prefix = citizen.getWorkBuilding().getJobName();
            }
            if (GUARD_TOWER.equals(prefix) && citizen.getWorkBuilding() instanceof AbstractBuildingGuards) {
                prefix = ((AbstractBuildingGuards)citizen.getWorkBuilding()).getJob() == AbstractBuildingGuards.GuardJob.RANGER ? "archer" : "knight";
            }
            for (AbstractWorkerSounds sounds : ModSoundEvents.handlers) {
                if (!sounds.getWorkerString().equals(prefix)) continue;
                sounds.playSound(worldIn, citizen.func_180425_c(), citizen.isFemale(), saturation);
            }
        }
    }

    public static void playSoundAtCitizen(@NotNull World worldIn, @NotNull BlockPos position, @NotNull SoundEvent event) {
        worldIn.func_184133_a((EntityPlayer)null, position, event, SoundCategory.NEUTRAL, 0.5f, 0.9f);
    }

    public static void playSoundAtCitizenWithChance(@NotNull World worldIn, @NotNull BlockPos position, @Nullable SoundEvent event, int chance) {
        if (event == null) {
            return;
        }
        if (chance > rand.nextInt(100)) {
            worldIn.func_184133_a((EntityPlayer)null, position, event, SoundCategory.NEUTRAL, 0.5f, 0.9f);
        }
    }

    public static void playInteractionSoundAtCitizenWithChance(@NotNull World world, @NotNull BlockPos position, int chance, @NotNull EntityCitizen citizen) {
        if (chance > rand.nextInt(100)) {
            String prefix = "";
            if (citizen.getWorkBuilding() != null) {
                prefix = citizen.getWorkBuilding().getJobName();
            }
            if (GUARD_TOWER.equals(prefix) && citizen.getWorkBuilding() instanceof AbstractBuildingGuards) {
                prefix = ((AbstractBuildingGuards)citizen.getWorkBuilding()).getJob() == AbstractBuildingGuards.GuardJob.RANGER ? "archer" : "knight";
            }
            for (AbstractWorkerSounds sounds : ModSoundEvents.handlers) {
                if (!sounds.getWorkerString().equals(prefix)) continue;
                sounds.playInteractionSound(world, citizen.func_180425_c(), citizen.isFemale());
            }
        }
    }
}

