/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.api.colony.permissions.Player;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ServerUtils {
    private ServerUtils() {
    }

    @Nullable
    public static EntityPlayer getPlayerFromUUID(@NotNull World world, @NotNull UUID id) {
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            if (!id.equals(((EntityPlayer)world.field_73010_i.get(i)).func_146103_bH().getId())) continue;
            return (EntityPlayer)world.field_73010_i.get(i);
        }
        return null;
    }

    @NotNull
    public static List<EntityPlayer> getPlayersFromUUID(@NotNull World world, @NotNull Collection<UUID> ids) {
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
        for (Object o : world.field_73010_i) {
            EntityPlayer player;
            if (!(o instanceof EntityPlayer) || !ids.contains((player = (EntityPlayer)o).func_146103_bH().getId())) continue;
            players.add(player);
            if (players.size() != ids.size()) continue;
            return players;
        }
        return players;
    }

    @NotNull
    public static List<EntityPlayer> getPlayersFromPermPlayer(@NotNull List<Player> players, @NotNull World world) {
        ArrayList<EntityPlayer> playerList = new ArrayList<EntityPlayer>();
        for (Player player : players) {
            playerList.add(ServerUtils.getPlayerFromPermPlayer(player, world));
        }
        return playerList;
    }

    @Nullable
    public static EntityPlayer getPlayerFromPermPlayer(@NotNull Player player, @NotNull World world) {
        return ServerUtils.getPlayerFromUUID(player.getID(), world);
    }

    @Nullable
    public static EntityPlayer getPlayerFromUUID(@Nullable UUID uuid, @NotNull World world) {
        if (uuid == null || world == null || world.func_73046_m() == null) {
            return null;
        }
        List allPlayers = world.func_73046_m().func_184103_al().func_181057_v();
        for (EntityPlayerMP player : allPlayers) {
            if (!player.func_110124_au().equals(uuid)) continue;
            return player;
        }
        return null;
    }
}

