/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.blocks.BlockInfoPoster;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.tileentities.TileEntityInfoPoster;
import com.minecolonies.structures.helpers.Settings;
import com.minecolonies.structures.helpers.Structure;
import com.minecolonies.structures.lib.ModelHolder;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class RenderUtils {
    private static final double HALF_BLOCK_OFFSET = 0.5;
    private static final int FIX_POINT_OFFSET = 10;
    private static final int WHOLE_CIRCLE = 360;
    private static final int HALF_A_CIRCLE = 180;

    private RenderUtils() {
    }

    public static void renderWayPoints(BlockPos position, WorldClient clientWorld, float partialTicks) {
        ColonyView colonyView = ColonyManager.getClosestColonyView((World)clientWorld, position);
        if (colonyView == null) {
            return;
        }
        Set<BlockPos> waypoints = colonyView.getWayPoints();
        for (BlockPos pos : waypoints) {
            EntityEnderCrystal crystal = new EntityEnderCrystal((World)clientWorld);
            crystal.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            crystal.func_184516_a(pos.func_177981_b(10));
            crystal.func_184517_a(false);
            crystal.field_70261_a = 0;
            Minecraft.func_71410_x().func_175598_ae().func_188388_a((Entity)crystal, 0.0f, true);
        }
    }

    public static void renderSigns(WorldClient clientWorld, float partialTicks, CitizenDataView citizenDataView, EntityPlayer player, BlockPos citizen) {
        BlockInfoPoster block = ModBlocks.blockInfoPoster;
        BlockPos vector = citizen.func_177973_b((Vec3i)player.func_180425_c());
        EnumFacing facing = EnumFacing.func_176737_a((float)vector.func_177958_n(), (float)0.0f, (float)vector.func_177952_p()).func_176734_d();
        BlockPos pos = citizen.func_177981_b(2).func_177972_a(facing);
        IBlockState iblockstate = block.func_176223_P().func_177226_a((IProperty)BlockInfoPoster.FACING, (Comparable)facing);
        IBlockState iBlockExtendedState = block.getExtendedState(iblockstate, (IBlockAccess)clientWorld, pos);
        IBakedModel ibakedmodel = Minecraft.func_71410_x().func_175602_ab().func_184389_a(iblockstate);
        TileEntityInfoPoster sign = new TileEntityInfoPoster();
        sign.func_174878_a(pos);
        for (int i = 0; i < sign.signText.length; ++i) {
            if (i >= citizenDataView.getLatestStatus().length) continue;
            sign.signText[i] = citizenDataView.getLatestStatus()[i];
        }
        ModelHolder models = new ModelHolder(pos, iblockstate, iBlockExtendedState, sign, ibakedmodel);
        Structure.getQuads(models, models.quads);
        new Structure((World)Minecraft.func_71410_x().field_71441_e).renderGhost((World)clientWorld, models, player, partialTicks, false);
    }

    public static void renderColonyBorder(BlockPos position, WorldClient clientWorld, float partialTicks, EntityPlayer thePlayer, List<BlockPos> colonyBorder) {
        if (colonyBorder.isEmpty()) {
            RenderUtils.calculateColonyBorder(clientWorld, thePlayer, colonyBorder);
        }
        for (BlockPos pos : colonyBorder) {
            Block block = Blocks.field_150484_ah;
            IBlockState iblockstate = block.func_176223_P();
            IBlockState iBlockExtendedState = block.getExtendedState(iblockstate, (IBlockAccess)clientWorld, pos);
            IBakedModel ibakedmodel = Minecraft.func_71410_x().func_175602_ab().func_184389_a(iblockstate);
            TileEntity tileentity = null;
            ModelHolder models = new ModelHolder(pos, iblockstate, iBlockExtendedState, tileentity, ibakedmodel);
            Structure.getQuads(models, models.quads);
            Settings.instance.getActiveStructure().renderGhost((World)clientWorld, models, thePlayer, partialTicks, false);
        }
    }

    private static void calculateColonyBorder(WorldClient theWorld, EntityPlayer thePlayer, List<BlockPos> colonyBorder) {
        ColonyView colonyView = ColonyManager.getClosestColonyView((World)theWorld, thePlayer.func_180425_c());
        if (colonyView == null) {
            return;
        }
        BlockPos center = colonyView.getCenter();
        int radius = Configurations.Gameplay.workingRangeTownHall;
        for (double degrees = 0.0; degrees < 360.0; degrees += 1.0) {
            double rads = degrees / 180.0 * Math.PI;
            double x = Math.round((double)center.func_177958_n() + (double)radius * Math.sin(rads));
            double z = Math.round((double)center.func_177952_p() + (double)radius * Math.cos(rads));
            colonyBorder.add(BlockPosUtil.getFloor(new BlockPos(x, (double)center.func_177956_o(), z), (World)theWorld).func_177984_a());
        }
    }
}

