/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.util.StructureWrapper;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.Mirror;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ColonyUtils {
    public static boolean isCitizenMissingFromWorld(@NotNull CitizenData citizen) {
        EntityCitizen entityCitizen = citizen.getCitizenEntity();
        return entityCitizen != null && CompatibilityUtils.getWorld((Entity)entityCitizen).func_73045_a(entityCitizen.func_145782_y()) == null;
    }

    public static boolean hasNewSubscribers(@NotNull Set<EntityPlayerMP> oldSubscribers, @NotNull Set<EntityPlayerMP> subscribers) {
        for (EntityPlayerMP player : subscribers) {
            if (oldSubscribers.contains(player)) continue;
            return true;
        }
        return false;
    }

    public static Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> calculateCorners(BlockPos pos, World world, StructureWrapper wrapper, int rotation, boolean isMirrored) {
        wrapper.rotate(rotation, world, pos, isMirrored ? Mirror.FRONT_BACK : Mirror.NONE);
        wrapper.setPosition(pos);
        int x1 = wrapper.getPosition().func_177958_n() - wrapper.getOffset().func_177958_n() - 1;
        int z1 = wrapper.getPosition().func_177952_p() - wrapper.getOffset().func_177952_p() - 1;
        int x2 = wrapper.getPosition().func_177958_n() + (wrapper.getWidth() - wrapper.getOffset().func_177958_n());
        int z2 = wrapper.getPosition().func_177952_p() + (wrapper.getLength() - wrapper.getOffset().func_177952_p());
        return new Tuple((Object)new Tuple((Object)x1, (Object)x2), (Object)new Tuple((Object)z1, (Object)z2));
    }
}

