/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.StructureName;
import com.minecolonies.structures.helpers.Settings;
import com.minecolonies.structures.helpers.Structure;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public final class ClientStructureWrapper {
    private ClientStructureWrapper() {
    }

    public static void handleSaveScanMessage(NBTTagCompound nbttagcompound, long currentMillis) {
        StructureName structureName = new StructureName("scans", "new", LanguageHandler.format("item.scepterSteel.scanFormat", currentMillis));
        File file = new File(Structure.getClientSchematicsFolder(), structureName.toString() + ".nbt");
        ClientStructureWrapper.checkDirectory(file.getParentFile());
        try (FileOutputStream outputstream = new FileOutputStream(file);){
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound, (OutputStream)outputstream);
        }
        catch (IOException e) {
            LanguageHandler.sendPlayerMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, "item.scepterSteel.scanFailure", new Object[0]);
            Log.getLogger().warn("Exception while trying to scan.", (Throwable)e);
            return;
        }
        LanguageHandler.sendPlayerMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, "item.scepterSteel.scanSuccess", file);
        Settings.instance.setStructureName(structureName.toString());
    }

    private static void checkDirectory(@NotNull File directory) {
        if (!directory.exists() && !directory.mkdirs()) {
            Log.getLogger().error("Directory doesn't exist and failed to be created: " + directory.toString());
        }
    }

    public static void sendMessageSchematicTooBig(int maxSize) {
        LanguageHandler.sendPlayerMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, "com.minecolonies.coremod.network.messages.schematicsavemessage.toobig", maxSize);
    }
}

