/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.tileentities;

import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.coremod.inventory.InventoryCitizen;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import com.minecolonies.coremod.tileentities.TileEntityRack;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityWareHouse
extends TileEntityColonyBuilding {
    public boolean hasMatchinItemStackInWarehouse(@NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        return ItemStackUtils.isEmpty(this.getFirstMatchingItemStackInWarehouse(itemStackSelectionPredicate)) == false;
    }

    @Nullable
    public ItemStack getFirstMatchingItemStackInWarehouse(@NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        if (this.getBuilding() != null) {
            Set tileEntities = this.getBuilding().getAdditionalCountainers().stream().map(pos -> this.func_145831_w().func_175625_s(pos)).collect(Collectors.toSet());
            tileEntities.removeIf(Objects::isNull);
            tileEntities.add(this);
            return tileEntities.stream().map(tileEntity -> InventoryUtils.filterProvider((ICapabilityProvider)tileEntity, itemStackSelectionPredicate)).filter(itemStacks -> !itemStacks.isEmpty()).map(itemStacks -> (ItemStack)itemStacks.get(0)).findFirst().orElse(ItemStackUtils.EMPTY);
        }
        return ItemStackUtils.EMPTY;
    }

    @Override
    @Nullable
    public BlockPos getPositionOfChestWithItemStack(@NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        if (this.getBuilding() != null) {
            Set tileEntities = this.getBuilding().getAdditionalCountainers().stream().map(pos -> this.func_145831_w().func_175625_s(pos)).collect(Collectors.toSet());
            tileEntities.removeIf(Objects::isNull);
            tileEntities.add(this);
            return tileEntities.stream().filter(tileEntity -> InventoryUtils.hasItemInProvider((ICapabilityProvider)tileEntity, itemStackSelectionPredicate)).map(TileEntity::func_174877_v).findFirst().orElse(null);
        }
        return null;
    }

    public void dumpInventoryIntoWareHouse(@NotNull InventoryCitizen inventoryCitizen) {
        for (int i = 0; i < new InvWrapper((IInventory)inventoryCitizen).getSlots(); ++i) {
            ItemStack stack = inventoryCitizen.func_70301_a(i);
            if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
            TileEntity chest = this.searchRightChestForStack(stack);
            if (chest == null) {
                LanguageHandler.sendPlayersMessage(this.getColony().getMessageEntityPlayers(), "com.minecolonies.coremod.wareHouse.full", new Object[0]);
                return;
            }
            InventoryUtils.transferItemStackIntoNextFreeSlotInProvider((IItemHandler)new InvWrapper((IInventory)inventoryCitizen), i, (ICapabilityProvider)chest);
        }
    }

    @Nullable
    private TileEntity searchRightChestForStack(@NotNull ItemStack stack) {
        if (InventoryUtils.findSlotInProviderNotFullWithItem((ICapabilityProvider)this, stack.func_77973_b(), stack.func_77952_i(), ItemStackUtils.getSize(stack)) != -1) {
            return this;
        }
        for (BlockPos pos : this.getBuilding().getAdditionalCountainers()) {
            TileEntity entity = this.func_145831_w().func_175625_s(pos);
            if (!TileEntityWareHouse.isInRack(stack, entity, false) && !TileEntityWareHouse.isInChest(stack, entity, false)) continue;
            return entity;
        }
        TileEntity chest = this.searchChestWithSimilarItem(stack);
        return chest == null ? this.searchMostEmptySlot() : chest;
    }

    private static boolean isInRack(ItemStack stack, TileEntity entity, boolean ignoreDamageValue) {
        return entity instanceof TileEntityRack && !((TileEntityRack)entity).isEmpty() && ((TileEntityRack)entity).hasItemStack(stack, ignoreDamageValue) && InventoryUtils.findSlotInProviderNotFullWithItem((ICapabilityProvider)entity, stack.func_77973_b(), ignoreDamageValue ? -1 : stack.func_77952_i(), ItemStackUtils.getSize(stack)) != -1;
    }

    private static boolean isInChest(ItemStack stack, TileEntity entity, boolean ignoreDamageValue) {
        return entity instanceof TileEntityChest && InventoryUtils.findSlotInProviderNotFullWithItem((ICapabilityProvider)entity, stack.func_77973_b(), ignoreDamageValue ? -1 : stack.func_77952_i(), ItemStackUtils.getSize(stack)) != -1;
    }

    @Nullable
    private TileEntity searchChestWithSimilarItem(ItemStack stack) {
        for (BlockPos pos : this.getBuilding().getAdditionalCountainers()) {
            TileEntity entity = this.func_145831_w().func_175625_s(pos);
            if (!TileEntityWareHouse.isInRack(stack, entity, true) && !TileEntityWareHouse.isInChest(stack, entity, true)) continue;
            return entity;
        }
        return null;
    }

    @Nullable
    private TileEntity searchMostEmptySlot() {
        int freeSlots = 0;
        TileEntity emptiestChest = null;
        for (BlockPos pos : this.getBuilding().getAdditionalCountainers()) {
            int tempFreeSlots;
            TileEntity entity = this.func_145831_w().func_175625_s(pos);
            if (entity == null) {
                this.getBuilding().removeContainerPosition(pos);
                continue;
            }
            if (entity instanceof TileEntityRack) {
                if (((TileEntityRack)entity).isEmpty()) {
                    return entity;
                }
                tempFreeSlots = ((TileEntityRack)entity).getFreeSlots();
                if (freeSlots >= tempFreeSlots) continue;
                freeSlots = tempFreeSlots;
                emptiestChest = entity;
                continue;
            }
            if (!(entity instanceof TileEntityChest) || InventoryUtils.getFirstOpenSlotFromProvider((ICapabilityProvider)entity) == -1 || freeSlots >= (tempFreeSlots = ((TileEntityChest)entity).func_70302_i_() - InventoryUtils.getAmountOfStacksInProvider((ICapabilityProvider)entity))) continue;
            freeSlots = tempFreeSlots;
            emptiestChest = entity;
        }
        return emptiestChest;
    }
}

