/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.tileentities;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.blocks.BlockMinecoloniesRack;
import com.minecolonies.coremod.blocks.RackType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class TileEntityRack
extends TileEntity {
    private static final String TAG_NEIGHBOR = "neighbor";
    private static final String TAG_INVENTORY = "inventory";
    private static final String TAG_SIZE = "tagSIze";
    private static final String TAG_MAIN = "main";
    private static final int TAG_COMPOUND = 10;
    private static final int DEFAULT_SIZE = 27;
    private static final int SLOT_PER_LINE = 9;
    private final Map<ItemStorage, Integer> content = new HashMap<ItemStorage, Integer>();
    private boolean single = true;
    private BlockPos neighbor = BlockPos.field_177992_a;
    private boolean main = false;
    private int size = 0;
    private IItemHandlerModifiable inventory = new ItemStackHandler(27){

        protected void onContentsChanged(int slot) {
            TileEntityRack.this.updateItemStorage();
            super.onContentsChanged(slot);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack result = super.extractItem(slot, amount, simulate);
            TileEntityRack.this.updateItemStorage();
            return result;
        }
    };

    public boolean hasItemStack(ItemStack stack) {
        return this.content.containsKey(new ItemStorage(stack));
    }

    public boolean freeStacks() {
        return this.content.isEmpty();
    }

    public int getFreeSlots() {
        int freeSlots = this.inventory.getSlots();
        for (int itemAmount : this.content.values()) {
            double slotsNeeded = (double)itemAmount / 64.0;
            freeSlots -= (int)Math.ceil(slotsNeeded);
        }
        return freeSlots;
    }

    public boolean hasItemStack(ItemStack stack, boolean ignoreDamageValue) {
        ItemStorage compareStorage = new ItemStorage(stack, ignoreDamageValue);
        for (Map.Entry<ItemStorage, Integer> entry : this.content.entrySet()) {
            if (!compareStorage.equals(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    public boolean hasItemStack(@NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        for (Map.Entry<ItemStorage, Integer> entry : this.content.entrySet()) {
            if (!itemStackSelectionPredicate.test(entry.getKey().getItemStack())) continue;
            return true;
        }
        return false;
    }

    public void upgradeItemStorage() {
        ++this.size;
        ItemStackHandler tempInventory = new ItemStackHandler(27 + this.size * 9){

            protected void onContentsChanged(int slot) {
                TileEntityRack.this.updateItemStorage();
                super.onContentsChanged(slot);
            }
        };
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            tempInventory.setStackInSlot(slot, this.inventory.getStackInSlot(slot));
        }
        this.inventory = tempInventory;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public int getItemCount(Predicate<ItemStack> predicate) {
        for (Map.Entry<ItemStorage, Integer> entry : this.content.entrySet()) {
            if (!predicate.test(entry.getKey().getItemStack())) continue;
            return entry.getValue();
        }
        return 0;
    }

    public void updateItemStorage() {
        this.content.clear();
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
            ItemStorage storage = new ItemStorage(stack.func_77946_l());
            int amount = ItemStackUtils.getSize(stack);
            if (this.content.containsKey(storage)) {
                amount += this.content.remove(storage).intValue();
            }
            this.content.put(storage, amount);
        }
        this.updateBlockState();
        this.func_70296_d();
    }

    private void updateBlockState() {
        if (this.field_145850_b != null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockMinecoloniesRack && (this.main || this.single)) {
            IBlockState typeNeighbor;
            IBlockState typeHere;
            if (this.content.isEmpty() && (this.getOtherChest() == null || this.getOtherChest().isEmpty())) {
                if (this.getOtherChest() != null && this.field_145850_b.func_180495_p(this.neighbor).func_177230_c() instanceof BlockMinecoloniesRack) {
                    typeHere = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a(BlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.EMPTYAIR));
                    typeNeighbor = this.field_145850_b.func_180495_p(this.neighbor).func_177226_a(BlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.DEFAULTDOUBLE)).func_177226_a((IProperty)BlockMinecoloniesRack.FACING, (Comparable)BlockPosUtil.getFacing(this.field_174879_c, this.neighbor));
                } else {
                    typeHere = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a(BlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.DEFAULT));
                    typeNeighbor = null;
                }
            } else if (this.getOtherChest() != null && this.field_145850_b.func_180495_p(this.neighbor).func_177230_c() instanceof BlockMinecoloniesRack) {
                typeHere = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a(BlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.EMPTYAIR));
                typeNeighbor = this.field_145850_b.func_180495_p(this.neighbor).func_177226_a(BlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.FULLDOUBLE)).func_177226_a((IProperty)BlockMinecoloniesRack.FACING, (Comparable)BlockPosUtil.getFacing(this.field_174879_c, this.neighbor));
            } else {
                typeHere = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a(BlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.FULL));
                typeNeighbor = null;
            }
            this.field_145850_b.func_175656_a(this.field_174879_c, typeHere);
            if (typeNeighbor != null) {
                this.field_145850_b.func_175656_a(this.neighbor, typeNeighbor);
            }
        }
    }

    public TileEntityRack getOtherChest() {
        if (this.neighbor.equals((Object)BlockPos.field_177992_a)) {
            return null;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.neighbor);
        if (tileEntity instanceof TileEntityRack) {
            ((TileEntityRack)tileEntity).setNeighbor(this.func_174877_v());
            return (TileEntityRack)tileEntity;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public void setMain(boolean main) {
        this.main = main;
    }

    public void neighborChanged(BlockPos newNeighbor) {
        TileEntity entity = this.field_145850_b.func_175625_s(newNeighbor);
        if (!this.neighbor.equals((Object)BlockPos.field_177992_a) && this.neighbor.func_177951_i((Vec3i)this.field_174879_c) > 1.0 && entity instanceof TileEntityRack) {
            this.softReset();
        }
        if (this.neighbor.equals((Object)BlockPos.field_177992_a) && this.field_145850_b.func_180495_p(newNeighbor).func_177230_c() instanceof BlockMinecoloniesRack && (!(entity instanceof TileEntityRack) || ((TileEntityRack)entity).getOtherChest() == null)) {
            this.neighbor = newNeighbor;
            this.single = false;
            if (entity instanceof TileEntityRack && !((TileEntityRack)entity).isMain()) {
                this.main = true;
                ((TileEntityRack)entity).setMain(false);
            }
            ((TileEntityRack)entity).setNeighbor(this.func_174877_v());
            entity.func_70296_d();
            this.updateItemStorage();
            this.func_70296_d();
        } else if (this.neighbor.equals((Object)newNeighbor) && !(this.field_145850_b.func_180495_p(newNeighbor).func_177230_c() instanceof BlockMinecoloniesRack)) {
            this.neighbor = BlockPos.field_177992_a;
            this.single = true;
            this.main = false;
            this.updateItemStorage();
        }
    }

    public void softReset() {
        this.neighbor = BlockPos.field_177992_a;
        this.single = true;
        this.main = false;
    }

    public boolean isMain() {
        return this.main;
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b(TAG_SIZE)) {
            this.size = compound.func_74762_e(TAG_SIZE);
            if (this.size > 0) {
                this.inventory = new ItemStackHandler(27 + this.size * 9){

                    protected void onContentsChanged(int slot) {
                        TileEntityRack.this.updateItemStorage();
                        super.onContentsChanged(slot);
                    }
                };
            }
        }
        this.neighbor = BlockPosUtil.readFromNBT(compound, TAG_NEIGHBOR);
        if (!this.neighbor.equals((Object)BlockPos.field_177992_a)) {
            this.single = false;
        }
        NBTTagList inventoryTagList = compound.func_150295_c(TAG_INVENTORY, 10);
        for (int i = 0; i < inventoryTagList.func_74745_c(); ++i) {
            NBTTagCompound inventoryCompound = inventoryTagList.func_150305_b(i);
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)inventoryCompound);
            if (ItemStackUtils.getSize(stack) <= 0) {
                this.inventory.setStackInSlot(i, ItemStackUtils.EMPTY);
                continue;
            }
            this.inventory.setStackInSlot(i, stack);
        }
        this.main = compound.func_74767_n(TAG_MAIN);
        this.updateItemStorage();
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a(TAG_SIZE, this.size);
        BlockPosUtil.writeToNBT(compound, TAG_NEIGHBOR, this.neighbor);
        NBTTagList inventoryTagList = new NBTTagList();
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            NBTTagCompound inventoryCompound = new NBTTagCompound();
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack == ItemStackUtils.EMPTY) {
                new ItemStack(Blocks.field_150350_a, 0).func_77955_b(inventoryCompound);
            } else {
                stack.func_77955_b(inventoryCompound);
            }
            inventoryTagList.func_74742_a((NBTBase)inventoryCompound);
        }
        compound.func_74782_a(TAG_INVENTORY, (NBTBase)inventoryTagList);
        compound.func_74757_a(TAG_MAIN, this.main);
        return super.func_189515_b(compound);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a(TAG_SIZE, this.size);
        BlockPosUtil.writeToNBT(compound, TAG_NEIGHBOR, this.neighbor);
        NBTTagList inventoryTagList = new NBTTagList();
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            NBTTagCompound inventoryCompound = new NBTTagCompound();
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack == ItemStackUtils.EMPTY) {
                new ItemStack(Blocks.field_150350_a, 0).func_77955_b(inventoryCompound);
            } else {
                stack.func_77955_b(inventoryCompound);
            }
            inventoryTagList.func_74742_a((NBTBase)inventoryCompound);
        }
        compound.func_74782_a(TAG_INVENTORY, (NBTBase)inventoryTagList);
        compound.func_74757_a(TAG_MAIN, this.main);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    @NotNull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.size = compound.func_74762_e(TAG_SIZE);
        if (compound.func_74764_b(TAG_SIZE)) {
            this.size = compound.func_74762_e(TAG_SIZE);
            if (this.size > 0) {
                this.inventory = new ItemStackHandler(27 + this.size * 9){

                    protected void onContentsChanged(int slot) {
                        TileEntityRack.this.updateItemStorage();
                        super.onContentsChanged(slot);
                    }
                };
            }
        }
        this.neighbor = BlockPosUtil.readFromNBT(compound, TAG_NEIGHBOR);
        if (!this.neighbor.equals((Object)BlockPos.field_177992_a)) {
            this.single = false;
        }
        NBTTagList inventoryTagList = compound.func_150295_c(TAG_INVENTORY, 10);
        for (int i = 0; i < inventoryTagList.func_74745_c(); ++i) {
            NBTTagCompound inventoryCompound = inventoryTagList.func_150305_b(i);
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)inventoryCompound);
            if (ItemStackUtils.getSize(stack) <= 0) {
                this.inventory.setStackInSlot(i, ItemStackUtils.EMPTY);
                continue;
            }
            this.inventory.setStackInSlot(i, stack);
        }
        this.main = compound.func_74767_n(TAG_MAIN);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@NotNull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.single) {
                return (T)this.inventory;
            }
            if (this.getOtherChest() != null) {
                if (this.main && this.getOtherChest() != null) {
                    return (T)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, this.getOtherChest().inventory});
                }
                return (T)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.getOtherChest().inventory, this.inventory});
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public BlockPos getNeighbor() {
        return this.neighbor;
    }

    public void setNeighbor(BlockPos neighbor) {
        if (!neighbor.equals((Object)BlockPos.field_177992_a)) {
            this.neighbor = neighbor;
            this.single = false;
        } else {
            this.neighbor = BlockPos.field_177992_a;
            this.single = true;
        }
    }
}

